/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

import kd.bos.dataentity.utils.StringUtils;

public class VINumberTransfer {
    private static final String[] NUMBERS = new String[]{"kh\u00f4ng", "m\u1ed9t", "hai", "ba", "b\u1ed1n", "n\u0103m", "s\u00e1u", "b\u1ea3y", "t\u00e1m", "ch\u00edn"};
    private static final String[] UNITS = new String[]{"", "ngh\u00ecn", "tri\u1ec7u", "t\u1ef7", "ngh\u00ecn t\u1ef7", "tri\u1ec7u t\u1ef7"};
    private static final String BLACK_SPACE = " ";
    private static final String ONLY = "\u0111\u1ed3ng ch\u1eb5n";
    private static final String DECIMAL = "\u0111\u1ed3ng";
    private static final String POINT = "ph\u1ea9y";
    private static final String MINUS = "\u00e2m";

    public static String convert(String number) {
        String decimalResult;
        StringBuilder sb = new StringBuilder();
        String[] split = number.split("\\.");
        String integerPart = split[0].replaceFirst("[+-]", "");
        for (int i = 5; i >= 0; --i) {
            VINumberTransfer.trans(VINumberTransfer.getDigit(integerPart, i), i, sb);
        }
        String result = sb.toString().trim();
        if (number.contains("-")) {
            result = String.join((CharSequence)BLACK_SPACE, MINUS, result);
        }
        if (split.length > 1 && StringUtils.isNotEmpty((CharSequence)(decimalResult = VINumberTransfer.transX(split[1])))) {
            return String.join((CharSequence)BLACK_SPACE, result, POINT, decimalResult, DECIMAL);
        }
        return String.join((CharSequence)BLACK_SPACE, result, ONLY);
    }

    private static String getDigit(String number, int index) {
        int len = number.length();
        int startIndex = Math.max(0, len - (index + 1) * 3);
        int endIndex = Math.max(0, len - index * 3);
        return number.substring(startIndex, endIndex);
    }

    private static String transX(String number) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)number) || Integer.parseInt(number) == 0) {
            return "";
        }
        if (number.length() == 1) {
            return sb.append(NUMBERS[Integer.parseInt(number)]).toString();
        }
        String[] decimal = new String[]{number.substring(1, 2), number.substring(0, 1)};
        if (Integer.parseInt(decimal[1]) == 0) {
            sb.append(NUMBERS[0]).append(BLACK_SPACE).append(NUMBERS[Integer.parseInt(decimal[0])]);
        } else if (Integer.parseInt(decimal[0]) == 0) {
            sb.append(NUMBERS[Integer.parseInt(decimal[1])]);
        } else {
            VINumberTransfer.appendTwoDigit(new String[]{number.substring(1, 2), number.substring(0, 1)}, sb);
        }
        return sb.toString();
    }

    private static void trans(String number, int index, StringBuilder sb) {
        if (StringUtils.isEmpty((CharSequence)number) || "000".equals(number)) {
            return;
        }
        int len = number.length();
        String[] digits = new String[]{number.substring(Math.max(0, len - 1), len), number.substring(Math.max(0, len - 2), Math.max(0, len - 1)), number.substring(Math.max(0, len - 3), Math.max(0, len - 2))};
        switch (len) {
            case 1: {
                sb.append(NUMBERS[Integer.parseInt(number)]);
                break;
            }
            case 2: {
                VINumberTransfer.appendTwoDigit(digits, sb);
                break;
            }
            case 3: {
                VINumberTransfer.appendThreeDigit(digits, sb);
                break;
            }
        }
        sb.append(BLACK_SPACE).append(UNITS[index]).append(BLACK_SPACE);
    }

    private static void appendTwoDigit(String[] digits, StringBuilder sb) {
        int unit = Integer.parseInt(digits[0]);
        int ten = Integer.parseInt(digits[1]);
        sb.append(ten == 1 ? "m\u01b0\u1eddi" : NUMBERS[ten] + " m\u01b0\u01a1i");
        String unitTran = VINumberTransfer.getUnitTran(unit, ten);
        if (StringUtils.isNotEmpty((CharSequence)unitTran)) {
            sb.append(BLACK_SPACE).append(unitTran);
        }
    }

    private static void appendThreeDigit(String[] digits, StringBuilder sb) {
        int unit = Integer.parseInt(digits[0]);
        int ten = Integer.parseInt(digits[1]);
        int hundred = Integer.parseInt(digits[2]);
        sb.append(NUMBERS[hundred]).append(" tr\u0103m ");
        if (ten == 0 && unit > 0) {
            sb.append("l\u1ebb ");
        }
        if (ten > 0) {
            sb.append(NUMBERS[ten]).append(" m\u01b0\u01a1i ");
        }
        sb.append(VINumberTransfer.getUnitTran(unit, ten));
    }

    private static String getUnitTran(int unit, int ten) {
        String tran = "";
        if (unit > 0) {
            tran = NUMBERS[unit];
        }
        if (unit == 1 && ten > 1) {
            tran = "m\u1ed1t";
        }
        if (unit == 5 && ten > 0) {
            tran = "l\u0103m";
        }
        return tran;
    }
}

