/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.i18n.api.enums.DateType;
import kd.bos.i18n.api.enums.Week;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WorkingPlanUtils {
    private static final Boolean TRUE = Boolean.TRUE;
    private static final Boolean FALSE = Boolean.FALSE;
    private static final String BOS_MSERVICE_I18N = "bos-mservice-i18n";

    public static Map<String, Object> applyWorkingPlan(Long workingPlanPk, Calendar calendar) {
        DynamicObject workingPlan = BusinessDataServiceHelper.loadSingleFromCache((Object)workingPlanPk, (String)"working_plan");
        return WorkingPlanUtils.applyWorkingPlan(workingPlan, calendar);
    }

    public static Map<String, Object> applyWorkingPlan(DynamicObject workingPlan, Calendar calendar) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (workingPlan == null) {
            resultMap.put("valid", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u65e0\u6548\u5de5\u4f5c\u65e5\u8ba1\u5212\u3002", (String)"WorkingPlanUtils_0", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        Date startValidDate = workingPlan.getDate("startdate");
        Date endValidDate = workingPlan.getDate("enddate");
        if (calendar.before(WorkingPlanUtils.dateToCalendar(startValidDate)) || calendar.after(WorkingPlanUtils.dateToCalendar(endValidDate))) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            resultMap.put("valid", FALSE);
            resultMap.put("errorMsg", String.format(ResManager.loadKDString((String)"\u65e5\u671f%s\u4e0d\u5728\u5de5\u4f5c\u65e5\u8ba1\u5212\u6709\u6548\u671f\u5185\u3002", (String)"WorkingPlanUtils_1", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]), dateFormat.format(calendar.getTime())));
            return resultMap;
        }
        DynamicObjectCollection workingTimeColl = workingPlan.getDynamicObjectCollection("cardentryentity");
        DynamicObjectCollection holidayColl = workingPlan.getDynamicObjectCollection("entryentity2");
        DynamicObjectCollection specialDateColl = workingPlan.getDynamicObjectCollection("entryentity1");
        Map<Object, Object> result = new HashMap();
        result = WorkingPlanUtils.applySpecialDateInDayInfo(calendar, specialDateColl);
        if (((Boolean)result.get("valid")).booleanValue()) {
            resultMap.put("valid", TRUE);
            resultMap.put("dateType", ((DateType)result.get("dateType")).getCode());
            resultMap.put("workRangeList", result.get("workRangeList"));
        } else {
            result = WorkingPlanUtils.applyHolidayInDayInfo(calendar, holidayColl);
            if (((Boolean)result.get("valid")).booleanValue()) {
                resultMap.put("valid", TRUE);
                resultMap.put("dateType", ((DateType)result.get("dateType")).getCode());
                resultMap.put("holidayName", result.get("holidayname"));
                resultMap.put("holidaytype", result.get("holidaytype"));
                resultMap.put("holidayClass", result.get("holidayClass"));
                if (((Boolean)result.get("holidaytype")).booleanValue()) {
                    ArrayList workRangeNewList = new ArrayList();
                    DynamicObject timeperiod = (DynamicObject)result.get("timeperiod");
                    if (timeperiod != null) {
                        DynamicObjectCollection workingHoursEntry = timeperiod.getDynamicObjectCollection("entryentity");
                        for (DynamicObject hoursEntry : workingHoursEntry) {
                            Integer startTime = hoursEntry.getInt("starttime");
                            Integer endTime = hoursEntry.getInt("endtime");
                            HashMap<String, Object> workRange = new HashMap<String, Object>();
                            workRange.put("workingHoursId", timeperiod.getString("id"));
                            workRange.put("startTime", startTime);
                            workRange.put("endTime", endTime);
                            workRangeNewList.add(workRange);
                        }
                    }
                    resultMap.put("workRangeList", workRangeNewList);
                    resultMap.put("halfDayInWorkDay", TRUE);
                    return resultMap;
                }
                resultMap.put("halfDayInWorkDay", FALSE);
            } else {
                result = WorkingPlanUtils.applyWorkingTimeInDayInfo(calendar, workingTimeColl);
                if (((Boolean)result.get("valid")).booleanValue()) {
                    resultMap.put("valid", TRUE);
                    resultMap.put("dateType", ((DateType)result.get("dateType")).getCode());
                    resultMap.put("workRangeList", result.get("workRangeList"));
                } else {
                    resultMap.put("valid", FALSE);
                    resultMap.put("errorMsg", result.get("errorMsg"));
                }
            }
        }
        return resultMap;
    }

    private static Map<String, Object> applySpecialDateInDayInfo(Calendar calendar, DynamicObjectCollection specialDateColl) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("valid", FALSE);
        for (DynamicObject specialDate : specialDateColl) {
            Date date = specialDate.getDate("date1");
            Date enddate1 = specialDate.getDate("enddate1");
            if (date == null || enddate1 == null || calendar.before(WorkingPlanUtils.dateToCalendar(date)) || calendar.after(WorkingPlanUtils.dateToCalendar(enddate1))) continue;
            String dateTypeStr = specialDate.getString("datetype1");
            result.put("valid", TRUE);
            DateType dateType = DateType.getByCode((int)Integer.parseInt(dateTypeStr));
            result.put("dateType", dateType);
            DynamicObject hours = specialDate.getDynamicObject("hours1");
            if (hours == null) {
                return result;
            }
            DynamicObjectCollection workingHoursEntry = hours.getDynamicObjectCollection("entryentity");
            ArrayList workRangeList = new ArrayList(10);
            for (DynamicObject hoursEntry : workingHoursEntry) {
                Integer startTime = hoursEntry.getInt("starttime");
                Integer endTime = hoursEntry.getInt("endtime");
                HashMap<String, Integer> workRange = new HashMap<String, Integer>();
                workRange.put("startTime", startTime);
                workRange.put("endTime", endTime);
                workRangeList.add(workRange);
            }
            result.put("workRangeList", workRangeList);
            return result;
        }
        return result;
    }

    private static Map<String, Object> applyHolidayInDayInfo(Calendar calendar, DynamicObjectCollection holidayColl) {
        DynamicObject dynamicObject;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("valid", FALSE);
        DynamicObject holiday = null;
        Iterator iterator = holidayColl.iterator();
        while (iterator.hasNext() && (dynamicObject = (DynamicObject)iterator.next()).getDynamicObject("holiday1") != null) {
            Calendar dayByWeek;
            DynamicObject fixWeekHoliday;
            int holidayMonth;
            holiday = dynamicObject.getDynamicObject("holiday1");
            String type = holiday.getString("type");
            if ("1".equals(type)) {
                String[] split;
                DynamicObject fixedDateHoliday = BusinessDataServiceHelper.loadSingleFromCache((Object)holiday.getPkValue(), (String)"public_holiday_fixeddate");
                holidayMonth = Integer.parseInt(fixedDateHoliday.getString("month"));
                String dayofmonth = fixedDateHoliday.getString("dayofmonth");
                if (!StringUtils.isNotBlank((CharSequence)dayofmonth)) continue;
                for (String s : split = dayofmonth.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    int holidayDayOfMonth = Integer.parseInt(s);
                    if (WorkingPlanUtils.isOnFixDayHoliday(calendar, holidayMonth, holidayDayOfMonth)) {
                        result.put("valid", TRUE);
                        break;
                    }
                    if (!WorkingPlanUtils.isInPostponeHoliday(calendar, fixedDateHoliday, holidayMonth, holidayDayOfMonth)) continue;
                    result.put("valid", TRUE);
                    break;
                }
                if (!((Boolean)result.get("valid")).booleanValue()) continue;
                break;
            }
            if ("2".equals(type)) {
                DynamicObject appointday = BusinessDataServiceHelper.loadSingleFromCache((Object)holiday.getPkValue(), (String)"public_holiday_appointday");
                DynamicObjectCollection collection = appointday.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : collection) {
                    Date startdate = object.getDate("startdate");
                    Date enddate = object.getDate("enddate");
                    if (calendar.before(WorkingPlanUtils.dateToCalendar(startdate)) || calendar.after(WorkingPlanUtils.dateToCalendar(enddate))) continue;
                    result.put("valid", TRUE);
                    break;
                }
                if (!((Boolean)result.get("valid")).booleanValue()) continue;
                break;
            }
            if (!"3".equals(type) || (fixWeekHoliday = BusinessDataServiceHelper.loadSingleFromCache((Object)holiday.getPkValue(), (String)"public_holiday_fixedweek")) == null) continue;
            holidayMonth = Integer.parseInt(fixWeekHoliday.getString("month"));
            String week = fixWeekHoliday.getString("weekofmonth");
            String dayOfWeekStr = fixWeekHoliday.getString("dayofweek");
            int dayOfWeek = Week.getCodeByName((String)dayOfWeekStr);
            if (holidayMonth != calendar.get(2) + 1 || !WorkingPlanUtils.isInSameDay(calendar, dayByWeek = WorkingPlanUtils.getDayByIndex(calendar, dayOfWeek = dayOfWeek == 7 ? 1 : dayOfWeek + 1, week))) continue;
            result.put("valid", TRUE);
            break;
        }
        if (((Boolean)result.get("valid")).booleanValue() && holiday != null) {
            DynamicObject holidayclass;
            boolean holidayType = holiday.getBoolean("holidaytype");
            DynamicObject timeperiod = holiday.getDynamicObject("timeperiod");
            if (timeperiod != null) {
                timeperiod = BusinessDataServiceHelper.loadSingleFromCache((Object)timeperiod.getPkValue(), (String)"working_hours");
                result.put("timeperiod", timeperiod);
            }
            if ((holidayclass = holiday.getDynamicObject("holidayclass")) != null) {
                holidayclass = BusinessDataServiceHelper.loadSingleFromCache((Object)holidayclass.getPkValue(), (String)"int_holidayclass");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", holidayclass.getString("id"));
                map.put("name", holidayclass.getString("name"));
                map.put("number", holidayclass.getString("number"));
                result.put("holidayClass", map);
            }
            result.put("holidaytype", holidayType);
            result.put("holidayname", holiday.getString("name"));
            result.put("dateType", DateType.HOLIDAY);
        }
        return result;
    }

    private static Calendar getDayByIndex(Calendar old, int dayOfWeek, String index) {
        Calendar instance = Calendar.getInstance();
        instance.set(1, old.get(1));
        instance.set(2, old.get(2));
        instance.set(5, 1);
        if ("last".equals(index)) {
            instance.add(2, 1);
            instance.add(5, -1);
            int lastDayOfWeek = instance.get(7);
            instance.add(5, dayOfWeek - lastDayOfWeek > 0 ? -lastDayOfWeek - (7 - dayOfWeek) : dayOfWeek - lastDayOfWeek);
        } else {
            int firstDayWeek = instance.get(7);
            int addDay = 0;
            addDay = dayOfWeek - firstDayWeek >= 0 ? dayOfWeek - firstDayWeek + (Integer.parseInt(index) - 1) * 7 : dayOfWeek - firstDayWeek + Integer.parseInt(index) * 7;
            instance.add(5, addDay);
        }
        return instance;
    }

    private static boolean isInPostponeHoliday(Calendar calendar, DynamicObject holiday, int holidayMonth, int holidayDayOfMonth) {
        String[] extendRulesStrArr;
        String extendRulesStr = holiday.getString("extendrules");
        if (StringUtils.isBlank((CharSequence)extendRulesStr)) {
            return false;
        }
        HashMap<Integer, Integer> extendRulesMap = new HashMap<Integer, Integer>(16);
        for (String rule : extendRulesStrArr = extendRulesStr.split(",")) {
            int weekIndex = Integer.parseInt(rule.substring(0, 1));
            int postPoneRule = Integer.parseInt(rule.substring(1, 3));
            extendRulesMap.put(weekIndex, postPoneRule);
        }
        int year = calendar.get(1);
        if (extendRulesMap.size() > 0) {
            for (int i = -1; i < 2; ++i) {
                GregorianCalendar postponeCal = new GregorianCalendar();
                postponeCal.set(year + i, holidayMonth - 1, holidayDayOfMonth);
                int weekIndex = postponeCal.get(7) == 1 ? 7 : postponeCal.get(7) - 1;
                Integer postponeRule = (Integer)extendRulesMap.get(weekIndex);
                if (postponeRule == null) continue;
                postponeCal.add(6, postponeRule);
                if (!WorkingPlanUtils.isInSameDay(calendar, postponeCal)) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, Object> applyWorkingTimeInDayInfo(Calendar calendar, DynamicObjectCollection workingTimeColl) {
        Map<String, Object> result = new HashMap<String, Object>();
        for (DynamicObject workingTimeEntry : workingTimeColl) {
            DynamicObject workingTime = workingTimeEntry.getDynamicObject("workingtime");
            Date startDate = workingTimeEntry.getDate("validity_startdate");
            Date enddate = workingTimeEntry.getDate("validity_enddate");
            if (workingTime == null || startDate == null || enddate == null) continue;
            Calendar startDateCal = WorkingPlanUtils.dateToCalendar(startDate);
            Calendar endDateCal = WorkingPlanUtils.dateToCalendar(enddate);
            if (calendar.before(startDateCal) || calendar.after(endDateCal)) continue;
            String cycleMode = workingTime.getString("cyclemode");
            if ("A".equals(cycleMode)) {
                result = WorkingPlanUtils.applyWeekCycleModeWorkingTime(calendar, workingTime);
                continue;
            }
            if ("B".equals(cycleMode)) {
                result = WorkingPlanUtils.applyCustomCycleModeWorkingTime(calendar, startDateCal, workingTime);
                continue;
            }
            result.put("valid", FALSE);
            result.put("errorMsg", ResManager.loadKDString((String)"\u5de5\u4f5c\u65f6\u95f4\u4e0d\u652f\u6301\u6b64\u79cd\u5faa\u73af\u6a21\u5f0f\u3002", (String)"WorkingPlanUtils_2", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        if (!result.containsKey("valid")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            result.put("valid", FALSE);
            result.put("errorMsg", String.format(ResManager.loadKDString((String)"\u65e5\u671f%s\u4e0d\u5728\u5de5\u4f5c\u65f6\u95f4\u6709\u6548\u671f\u5185\u3002", (String)"WorkingPlanUtils_3", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]), dateFormat.format(calendar.getTime())));
        }
        return result;
    }

    private static Map<String, Object> applyWeekCycleModeWorkingTime(Calendar calendar, DynamicObject workingTime) {
        DynamicObject hours;
        int dayOfWeek = calendar.get(7);
        int weekIndex = dayOfWeek == 1 ? 6 : dayOfWeek - 2;
        DynamicObject weekCycleModeDay = (DynamicObject)workingTime.getDynamicObjectCollection("entryentity").get(weekIndex);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("valid", TRUE);
        DateType dateType = DateType.getByCode((int)Integer.parseInt(weekCycleModeDay.getString("datetype")));
        result.put("dateType", dateType);
        ArrayList workRangeList = new ArrayList(10);
        if ((DateType.WORKING == dateType || DateType.HALF_WORKING == dateType) && (hours = weekCycleModeDay.getDynamicObject("hours")) != null) {
            DynamicObjectCollection workingHoursEntry = BusinessDataServiceHelper.loadSingleFromCache((Object)hours.getPkValue(), (String)"working_hours").getDynamicObjectCollection("entryentity");
            for (DynamicObject hoursEntry : workingHoursEntry) {
                Integer startTime = hoursEntry.getInt("starttime");
                Integer endTime = hoursEntry.getInt("endtime");
                HashMap<String, Integer> workRange = new HashMap<String, Integer>();
                workRange.put("startTime", startTime);
                workRange.put("endTime", endTime);
                workRangeList.add(workRange);
            }
        }
        result.put("workRangeList", workRangeList);
        return result;
    }

    private static Map<String, Object> applyCustomCycleModeWorkingTime(Calendar calendar, Calendar startDateCal, DynamicObject workingTime) {
        DynamicObjectCollection customCycleModeItems = workingTime.getDynamicObjectCollection("entryentity");
        int cycle = customCycleModeItems.size();
        int diffDay = WorkingPlanUtils.differentDays(startDateCal, calendar);
        int itemsIndex = diffDay % cycle;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("valid", TRUE);
        DateType dateType = DateType.getByCode((int)Integer.parseInt(((DynamicObject)customCycleModeItems.get(itemsIndex)).getString("datetype")));
        result.put("dateType", dateType);
        if (DateType.WORKING == dateType || DateType.HALF_WORKING == dateType) {
            DynamicObject hours = ((DynamicObject)customCycleModeItems.get(itemsIndex)).getDynamicObject("hours");
            if (hours == null) {
                return result;
            }
            DynamicObjectCollection workingHoursEntry = BusinessDataServiceHelper.loadSingleFromCache((Object)hours.getPkValue(), (String)"working_hours").getDynamicObjectCollection("entryentity");
            ArrayList workRangeList = new ArrayList(10);
            for (DynamicObject hoursEntry : workingHoursEntry) {
                Integer startTime = hoursEntry.getInt("starttime");
                Integer endTime = hoursEntry.getInt("endtime");
                HashMap<String, Integer> workRange = new HashMap<String, Integer>();
                workRange.put("startTime", startTime);
                workRange.put("endTime", endTime);
                workRangeList.add(workRange);
            }
            result.put("workRangeList", workRangeList);
        }
        return result;
    }

    public static int differentDays(Date start, Date end, boolean containsEndDay) {
        Calendar calendarS = WorkingPlanUtils.dateToCalendar(start);
        Calendar calendarE = WorkingPlanUtils.dateToCalendar(end);
        int result = WorkingPlanUtils.differentDays(calendarS, calendarE);
        return containsEndDay ? result + 1 : result;
    }

    public static int differentDays(Calendar cal1, Calendar cal2) {
        int year2;
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        if (year1 != (year2 = cal2.get(1))) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    private static boolean isOnFixDayHoliday(Calendar calendar, int holidayMonth, int holidayDayOfMonth) {
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        return month == holidayMonth && dayOfMonth == holidayDayOfMonth;
    }

    public static boolean isInSameDay(Calendar calendar, Date date) {
        return WorkingPlanUtils.isInSameDay(calendar, WorkingPlanUtils.dateToCalendar(date));
    }

    private static boolean isInSameDay(Calendar calendar1, Calendar calendar2) {
        int year1 = calendar1.get(1);
        int month1 = calendar1.get(2);
        int day1 = calendar1.get(5);
        int year2 = calendar2.get(1);
        int month2 = calendar2.get(2);
        int day2 = calendar2.get(5);
        return year1 == year2 && month1 == month2 && day1 == day2;
    }

    public static Calendar dateToCalendar(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }
}

