/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.i18n.mservice.utils.NumberTranslate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ZhCashTransfer {
    private static final char LING = '\u96f6';
    private static final char ZHENG = '\u6574';
    private static final char MINUS = '\u8d1f';
    private static NumberTranslate numberTranslate = new NumberTranslate();

    public static String transfer(String currencyNumber, String intUnit, String tenthsUnit, String percentileUnit, String amount) {
        DynamicObject currency;
        int pointIndex = amount.indexOf(46);
        String intStr = amount.substring(0, pointIndex);
        String tenthsStr = amount.substring(pointIndex + 1, pointIndex + 2);
        String percentileStr = amount.substring(pointIndex + 2, pointIndex + 3);
        boolean hasDec = true;
        if ("0".equals(tenthsStr) && "0".equals(percentileStr)) {
            hasDec = false;
        }
        boolean isMinus = false;
        if (intStr.contains("-")) {
            intStr = intStr.substring(1);
            isMinus = true;
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)currencyNumber) && (currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNumber)})) != null) {
            sb.append(currency.getLocaleString("name").getLocaleValue_zh_CN());
        }
        if (!hasDec && intStr.equals("0")) {
            sb.append('\u96f6').append(intUnit);
        } else if (!isMinus) {
            sb.append(numberTranslate.toNumber(intStr)).append(intUnit);
        } else {
            sb.append('\u8d1f').append(numberTranslate.toNumber(intStr)).append(intUnit);
        }
        if (hasDec) {
            if ("0".equals(tenthsStr)) {
                if (!"0".equals(percentileStr)) {
                    sb.append('\u96f6').append(numberTranslate.toNumber(percentileStr)).append(percentileUnit);
                }
            } else {
                boolean hasTenthsUnit = StringUtils.isNotEmpty((String)tenthsUnit);
                if (hasTenthsUnit) {
                    sb.append(numberTranslate.toNumber(tenthsStr)).append(tenthsUnit);
                    if (!"0".equals(percentileStr)) {
                        sb.append(numberTranslate.toNumber(percentileStr)).append(percentileUnit);
                    }
                } else {
                    sb.append(numberTranslate.toNumber(tenthsStr + percentileStr)).append(percentileUnit);
                }
            }
        } else {
            sb.append('\u6574');
        }
        return sb.toString();
    }
}

