/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.common.builder;

import java.beans.PropertyDescriptor;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import kd.bos.common.constant.MetaDataConst;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public interface FilterAndSortBuilder {
    public static final Log logger = LogFactory.getLog(FilterAndSortBuilder.class);

    default public String sqlFilterAndSortPackage(String sql, List<QFilter> qFilters, String orderBys) {
        StringBuilder builder = new StringBuilder(" SELECT * FROM ( ");
        builder.append(sql);
        builder.append(" ) A WHERE 1 = 1 ");
        if (qFilters != null && qFilters.size() > 0) {
            for (QFilter qFilter : qFilters) {
                builder.append("AND ").append(qFilter);
            }
        }
        String string = orderBys = orderBys != null ? orderBys.replace("ID DESC", "") : "";
        if (StringUtils.isNotBlank((CharSequence)orderBys)) {
            builder.append(" ORDER BY ").append(orderBys);
        }
        return builder.toString();
    }

    default public <T> Predicate<T> cacheFilterPackage(List<QFilter> filters, Class<T> beanType) {
        return obj -> {
            Boolean predicate = Boolean.TRUE;
            for (int i = 0; i < filters.size(); ++i) {
                predicate = this.isPredicate(filters, beanType, obj, predicate, i);
            }
            return predicate;
        };
    }

    default public <T> boolean isPredicate(List<QFilter> filters, Class<T> beanType, T obj, boolean predicate, int i) {
        try {
            QFilter filter = filters.get(i);
            String value = filter.getValue().toString();
            PropertyDescriptor pd = new PropertyDescriptor(filter.getProperty(), beanType);
            String propertyValue = Optional.ofNullable(pd.getReadMethod().invoke(obj, new Object[0])).orElseGet(() -> "").toString();
            switch (filter.getCP()) {
                case "=": {
                    predicate = predicate && propertyValue.equals(value);
                    break;
                }
                case "<>": {
                    predicate = predicate && !propertyValue.equals(value);
                    break;
                }
                case "is null": {
                    predicate = predicate && StringUtils.isBlank((CharSequence)propertyValue);
                    break;
                }
                case "is not null": {
                    predicate = predicate && StringUtils.isNotBlank((CharSequence)propertyValue);
                    break;
                }
                case "ftlike": {
                    if (value.startsWith("%") && value.endsWith("%")) {
                        predicate = predicate && propertyValue.contains(value.substring(1, value.length() - 1));
                        break;
                    }
                    if (value.startsWith("%")) {
                        predicate = predicate && propertyValue.endsWith(value.substring(1));
                        break;
                    }
                    if (!value.endsWith("%")) break;
                    predicate = predicate && propertyValue.startsWith(value.substring(0, value.length() - 1));
                    break;
                }
                case "not like": {
                    predicate = predicate && !propertyValue.contains(value.substring(1, value.length() - 1));
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return predicate;
    }

    default public <T> Comparator<T> cacheSortPackage(String orderBys, Class<T> beanType) {
        Comparator comparator = (o1, o2) -> 0;
        if (StringUtils.isBlank((CharSequence)orderBys)) {
            return comparator;
        }
        comparator = (obj1, obj2) -> {
            int i = 0;
            try {
                String[] split = orderBys.split(",");
                if (split.length == 0) {
                    return i;
                }
                String[] orderSort = split[0].split(" ");
                PropertyDescriptor pd = new PropertyDescriptor(orderSort[0], beanType);
                String o1value = Optional.ofNullable(pd.getReadMethod().invoke(obj1, new Object[0])).orElseGet(() -> "").toString();
                String o2value = Optional.ofNullable(pd.getReadMethod().invoke(obj2, new Object[0])).orElseGet(() -> "").toString();
                i = orderSort[1].equalsIgnoreCase("ASC") ? o1value.compareTo(o2value) : -o1value.compareTo(o2value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return i;
        };
        return comparator;
    }

    default public Comparator<DynamicObject> compStatusComparator(boolean isDesc) {
        return (twce1, twce2) -> {
            int statusOrder2;
            int statusOrder1 = MetaDataConst.STATUS_ORDER_MAP.get(twce1.getString("wordstatus"));
            if (statusOrder1 == (statusOrder2 = MetaDataConst.STATUS_ORDER_MAP.get(twce2.getString("wordstatus")).intValue())) {
                String id1 = twce1.getString("id");
                String id2 = twce2.getString("id");
                return isDesc ? id1.compareTo(id2) : id2.compareTo(id1);
            }
            return isDesc ? statusOrder1 - statusOrder2 : statusOrder2 - statusOrder1;
        };
    }
}

