/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

@Deprecated
public class AppChoseTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String TREE_LEFT = "tree_all";
    private static final String TREE_RIGHT = "tree_select";
    private static final String BTN_ADD_NODE = "btn_addnode";
    private static final String BTN_DEL_NODE = "btn_delnode";
    private static final String BTN_OK = "btnok";
    private static final String SELECTED_APP_IDS = "selectedAppIds";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tv = (TreeView)this.getControl(TREE_LEFT);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{BTN_ADD_NODE, BTN_DEL_NODE, BTN_OK});
    }

    public void afterCreateNewData(EventObject evt) {
        this.loadAllTreeData();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        TreeView treeLeft = (TreeView)this.getView().getControl(TREE_LEFT);
        TreeView treeRight = (TreeView)this.getView().getControl(TREE_RIGHT);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btn_addnode": {
                List leftSelectedNodes = treeLeft.getTreeState().getSelectedNodes();
                this.allocateAppTree(leftSelectedNodes);
                break;
            }
            case "btn_delnode": {
                List selectedNodeId = treeRight.getTreeState().getSelectedNodeId();
                treeLeft.uncheckNodes(selectedNodeId);
                treeRight.deleteNodes(selectedNodeId);
                Set<String> selected = this.getSelectedAppIds();
                if (selected == null) break;
                selected.removeAll(selectedNodeId);
                this.getPageCache().put(SELECTED_APP_IDS, SerializationUtils.toJsonString(selected));
                break;
            }
            case "btnok": {
                Set<String> appIds = this.getSelectedAppIds();
                if (StringUtils.isBlank(appIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63d0\u793a\u8bed\u5e94\u7528\u8303\u56f4\u3002", (String)"AppChoseTreePlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getView().returnDataToParent(appIds);
                this.getView().close();
                break;
            }
        }
    }

    private void loadAllTreeData() {
        Map<String, List<Map<String, String>>> cloudId2AppMap = this.getCloudId2AppMaps();
        TreeView treeLeft = (TreeView)this.getView().getControl(TREE_LEFT);
        TreeNode root = new TreeNode("", ROOT_NODE_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"AppChoseTreePlugin_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        Set<Map.Entry<String, List<Map<String, String>>>> entries = cloudId2AppMap.entrySet();
        for (Map.Entry<String, List<Map<String, String>>> entry : entries) {
            String cloudId = entry.getKey();
            List<Map<String, String>> value = entry.getValue();
            DynamicObject bizCloudById = BizCloudServiceHelp.getBizCloudByID((String)cloudId);
            TreeNode tn = new TreeNode(ROOT_NODE_ID, entry.getKey(), bizCloudById.getString("name"), (Object)1);
            for (Map<String, String> map : value) {
                tn.addChild(new TreeNode(cloudId, map.get("id"), map.get("name"), (Object)1));
            }
            root.addChild(tn);
        }
        treeLeft.addNode(root);
    }

    private void allocateAppTree(List<Map<String, Object>> selectedNodes) {
        HashSet<String> selectedAppIds = new HashSet<String>(16);
        TreeView treeRight = (TreeView)this.getView().getControl(TREE_RIGHT);
        TreeNode root = new TreeNode("", ROOT_NODE_ID, ResManager.loadKDString((String)"\u5df2\u5206\u914d", (String)"AppChoseTreePlugin_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        for (Map<String, Object> node : selectedNodes) {
            String id = (String)node.get("id");
            String text = (String)node.get("text");
            String parentId = (String)node.get("parentid");
            boolean isParent = (Boolean)node.get("isParent");
            if ("".equals(parentId)) continue;
            if (isParent) {
                TreeNode cloudNode = new TreeNode(ROOT_NODE_ID, id, text);
                cloudNode.setIsOpened(true);
                cloudNode.addChildren(new ArrayList());
                root.addChild(cloudNode);
                continue;
            }
            TreeNode treeNode = root.getTreeNode(parentId, 2);
            if (treeNode == null) {
                DynamicObject bizCloudById = BizCloudServiceHelp.getBizCloudByID((String)parentId);
                treeNode = new TreeNode(ROOT_NODE_ID, parentId, bizCloudById.getString("name"), (Object)1);
                treeNode.setIsOpened(true);
                root.addChild(treeNode);
            }
            TreeNode appNode = new TreeNode(parentId, id, text);
            treeNode.addChild(appNode);
            selectedAppIds.add(id);
        }
        this.getPageCache().put(SELECTED_APP_IDS, SerializationUtils.toJsonString(selectedAppIds));
        treeRight.addNode(root);
        treeRight.updateNode(root);
    }

    private Set<String> getSelectedAppIds() {
        Set selected = null;
        String selectedAppIds = this.getPageCache().get(SELECTED_APP_IDS);
        if (selectedAppIds != null) {
            selected = (Set)SerializationUtils.fromJsonString((String)selectedAppIds, Set.class);
        }
        return selected;
    }

    private Map<String, List<Map<String, String>>> getCloudId2AppMaps() {
        String sql = "SELECT fappid FROM t_cts_termproject where fenable = '1' GROUP BY fappid";
        HashMap<String, List<Map<String, String>>> cloudId2AppMap = new HashMap<String, List<Map<String, String>>>(16);
        DB.query((DBRoute)DBRoute.basedata, (String)sql, rs -> {
            while (rs.next()) {
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)rs.getString(1), (String)"bos_devportal_bizapp");
                if (object == null) continue;
                ArrayList appId2Name = (ArrayList)cloudId2AppMap.get(((DynamicObject)object.get("bizcloud")).getString("id"));
                if (appId2Name == null) {
                    appId2Name = new ArrayList();
                }
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("id", object.getString("id"));
                map.put("name", object.getString("name"));
                appId2Name.add(map);
                cloudId2AppMap.put(((DynamicObject)object.get("bizcloud")).getString("id"), appId2Name);
            }
            return cloudId2AppMap;
        });
        return cloudId2AppMap;
    }
}

