/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.BaseDataUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.bos.utils.LocalMemroyCacheUtil;

public class FrontEndEntryListPlugin
extends AbstractListPlugin {
    Log logger = LogFactory.getLog(FrontEndEntryListPlugin.class);
    private static final String CTS_FRONTEND_ENTRY = "cts_frontend_entry";
    private static final String CTS_RENAME_LOG = "cts_rename_log";
    private static final String REVERT_NEW_NAME = "revertnewname";
    private static final String PAGE_CLOSED = "page_closed";
    private static final String BTN_UPDATE = "btnupdate";
    private static final String BTN_REVERT = "btnrevert";
    private static final String BTN_LOG = "btnlog";
    private static final String LAN_ID = "lanid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BTN_UPDATE, BTN_REVERT, BTN_LOG});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList billlist = (BillList)this.getControl("billlistap");
        switch (evt.getItemKey()) {
            case "btnupdate": {
                RequestContext requestContext = RequestContext.get();
                String path = requestContext.getClientFullContextPath();
                long userId = UserServiceHelper.getCurrentUserId();
                String lanId = this.getPageCache().get(LAN_ID) != null ? this.getPageCache().get(LAN_ID) : "328738425610159104";
                String lanNum = BaseDataUtil.getLangNumByLanId(lanId);
                this.updateLoginWords(userId, Long.parseLong(lanId), lanNum, path);
                this.updateWebWords(userId, Long.parseLong(lanId), lanNum, path);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62bd\u53d6\u6210\u529f\u3002", (String)"FrontEndElementListPlugin_5", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                billlist.refresh();
                break;
            }
            case "btnrevert": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                Set pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)CTS_FRONTEND_ENTRY, (String)"id, name, newname", (QFilter[])new QFilter("id", "in", pkIds).toArray());
                if (Arrays.stream(dynamicObjects).noneMatch(e -> StringUtils.isNotEmpty((String)e.getString("newname")))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b0\u540d\u79f0\u4e0d\u4e3a\u7a7a\u7684\u6570\u636e\u3002", (String)"FrontEndElementListPlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REVERT_NEW_NAME, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u201c\u65b0\u540d\u79f0\u201d\u5c06\u6e05\u9664\uff0c\u9875\u9762\u5c06\u81ea\u52a8\u5237\u65b0\u5e76\u6062\u590d\u539f\u540d\u79f0\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"FrontEndElementListPlugin_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
            case "btnlog": {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId(CTS_RENAME_LOG);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (REVERT_NEW_NAME.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.name().equals(messageBoxClosedEvent.getResult().name())) {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                ArrayList nameList = new ArrayList(16);
                ArrayList newNameList = new ArrayList(16);
                selectedRows.forEach(e -> {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)CTS_FRONTEND_ENTRY, (QFilter[])new QFilter("id", "=", e.getPrimaryKeyValue()).toArray());
                    if (StringUtils.isNotEmpty((String)dynamicObject.getString("newname"))) {
                        nameList.add(dynamicObject.getString("name"));
                        newNameList.add(dynamicObject.getString("newname"));
                    }
                });
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)CTS_FRONTEND_ENTRY, (String)"id, name, newname", (QFilter[])new QFilter("name", "in", nameList).toArray());
                ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(16);
                Arrays.stream(dynamicObjects).forEach(e -> e.set("newname", (Object)""));
                for (int i = 0; i < nameList.size(); ++i) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)CTS_RENAME_LOG);
                    String userName = RequestContext.get().getUserName();
                    dynamicObject.set("username", (Object)userName);
                    dynamicObject.set("opname", (Object)ResManager.loadKDString((String)"\u6062\u590d", (String)"FrontEndElementListPlugin_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    dynamicObject.set("opdesc", nameList.get(i));
                    dynamicObject.set("oldvalue", newNameList.get(i));
                    dynamicObject.set("newvalue", (Object)"");
                    dynamicObject.set("opdate", (Object)new Date());
                    logList.add(dynamicObject);
                }
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
                BillList billlist = (BillList)this.getControl("billlistap");
                billlist.refresh();
                RequestContext requestContext = RequestContext.get();
                String accountId = requestContext.getAccountId();
                LocalMemroyCacheUtil.clear((String)(accountId + "_i18n_web"));
                LocalMemroyCacheUtil.clear((String)(accountId + "_i18n_login"));
                this.refreshPage();
            }
        } else if (PAGE_CLOSED.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.name().equals(messageBoxClosedEvent.getResult().name())) {
                this.refreshPage();
            } else if (MessageBoxResult.No.name().equals(messageBoxClosedEvent.getResult().name())) {
                this.getView().close();
                this.getPageCache().put(PAGE_CLOSED, "true");
                this.getPageCache().remove("status");
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        CommonFilterColumn commonFilterColumn = (CommonFilterColumn)args.getCommonFilterColumns().get(0);
        Map<String, String> lanId2Name = BaseDataUtil.getEnabledLanguage();
        ArrayList comboItems = new ArrayList(16);
        lanId2Name.entrySet().forEach(v -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString((String)v.getValue()));
            comboItem.setValue((String)v.getKey());
            comboItems.add(comboItem);
        });
        String lanId = BaseDataUtil.getLangIdByLanNum(Lang.get().name());
        commonFilterColumn.setDefaultValue(lanId);
        commonFilterColumn.setComboItems(comboItems);
        this.getPageCache().put(LAN_ID, lanId);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        if (null != args.getSearchClickEvent().getFilterValue("langid.id")) {
            this.getPageCache().put(LAN_ID, args.getSearchClickEvent().getFilterValue("langid.id").toString());
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new FrontEndElementProvider());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String pagClose = this.getPageCache().get(PAGE_CLOSED) == null ? "true" : this.getPageCache().get(PAGE_CLOSED);
        String returnData = this.getView().getPageCache().get("status");
        if ("true".equals(pagClose) && "modified".equals(returnData)) {
            e.setCancel(true);
            this.getPageCache().put(PAGE_CLOSED, "false");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(PAGE_CLOSED, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9875\u9762\u5237\u65b0\u540e\u5c06\u751f\u6548\uff0c\u662f\u5426\u7acb\u5373\u5237\u65b0\uff1f", (String)"FrontEndElementListPlugin_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private void updateLoginWords(Long userId, Long lanId, String lanNum, String path) {
        String url = path + "login/lang/" + lanNum + ".json";
        String result = "";
        try {
            result = HttpClientUtils.get((String)url, (int)60000, (int)60000);
        }
        catch (Exception e) {
            this.logger.info("\u66f4\u65b0\u7c7b\u578b\u4e3alogin\u7684\u524d\u7aef\u8bcd\u6761\u5931\u8d25", (Object)e);
        }
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> wordMap = new HashMap();
        try {
            wordMap = (Map)mapper.readValue(result, Map.class);
        }
        catch (JsonProcessingException e) {
            this.logger.info("json\u683c\u5f0f\u8f6c\u6362\u5931\u8d25", (Object)e);
        }
        this.updateAllWords(wordMap, userId, lanId, "login");
    }

    private void updateWebWords(Long userId, Long lanId, String lanNum, String path) {
        String result = "";
        String url = "zh_CN".equals(lanNum) ? path + "public/lang/zh_CN.json" : path + "languages/" + lanNum + ".json";
        try {
            result = HttpClientUtils.get((String)url, (int)60000, (int)60000);
        }
        catch (Exception e) {
            this.logger.info("\u66f4\u65b0\u7c7b\u578b\u4e3aweb\u7684\u524d\u7aef\u8bcd\u6761\u5931\u8d25", (Object)e);
        }
        if (StringUtils.isNotEmpty((String)result) && !"zh_CN".equals(lanNum)) {
            result = result.substring(result.indexOf(123), result.lastIndexOf(125) + 1);
        }
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> wordMap = new HashMap();
        try {
            wordMap = (Map)mapper.readValue(result, Map.class);
        }
        catch (JsonProcessingException e) {
            this.logger.info("json\u683c\u5f0f\u8f6c\u6362\u5931\u8d25", (Object)e);
        }
        this.updateAllWords(wordMap, userId, lanId, "web");
    }

    private void updateAllWords(Map<String, String> wordMap, Long userId, Long langId, String type) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        QFilter[] qFilters = new QFilter[]{new QFilter("langid", "=", (Object)langId), new QFilter("type", "=", (Object)type)};
        DynamicObject[] load = BusinessDataServiceHelper.load((String)CTS_FRONTEND_ENTRY, (String)"number,name, newname, modifytime, modifier", (QFilter[])qFilters);
        for (Map.Entry<String, String> entry : wordMap.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            List numberEQList = Arrays.stream(load).filter(e -> e.getString("number").equals(k)).collect(Collectors.toList());
            List nameEQList = Arrays.stream(load).filter(e -> e.getString("name").equals(v)).collect(Collectors.toList());
            if (numberEQList.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)numberEQList.get(0);
                if (dynamicObject.getString("name").equals(v)) continue;
                if (nameEQList.size() > 0 && StringUtils.isEmpty((String)dynamicObject.getString("newname")) && StringUtils.isNotEmpty((String)((DynamicObject)nameEQList.get(0)).getString("newname"))) {
                    dynamicObject.set("newname", (Object)((DynamicObject)nameEQList.get(0)).getString("newname"));
                }
                dynamicObject.set("name", (Object)v);
                dynamicObject.set("modifytime", (Object)new Date());
                dynamicObject.set("modifier", (Object)userId);
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                continue;
            }
            DynamicObject newDy = BusinessDataServiceHelper.newDynamicObject((String)CTS_FRONTEND_ENTRY);
            newDy.set("number", (Object)k);
            newDy.set("name", (Object)v);
            if (nameEQList.size() > 0) {
                newDy.set("newname", (Object)load[0].getString("newname"));
            }
            newDy.set("type", (Object)type);
            newDy.set("langid", (Object)langId);
            newDy.set("creator", (Object)userId);
            newDy.set("modifier", (Object)userId);
            newDy.set("createtime", (Object)new Date());
            newDy.set("modifytime", (Object)new Date());
            dynamicObjects.add(newDy);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        if (wordMap.size() > 0) {
            Arrays.stream(load).forEach(e -> {
                if (!wordMap.containsKey(e.getString("number"))) {
                    DeleteServiceHelper.delete((String)CTS_FRONTEND_ENTRY, (QFilter[])new QFilter("id", "=", e.get("id")).toArray());
                }
            });
        }
    }

    private void refreshPage() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>(2);
        RequestContext context = RequestContext.get();
        mpURL.put("url", context.getClientFullContextPath());
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
    }

    class FrontEndElementProvider
    extends ListDataProvider {
        FrontEndElementProvider() {
        }

        private String fetchGroupKey(DynamicObject object) {
            return object.getString("name") + object.getString("newname");
        }

        public int getRealCount() {
            return FrontEndEntryListPlugin.this.getPageCache().get("word_size") == null ? 0 : Integer.parseInt(FrontEndEntryListPlugin.this.getPageCache().get("word_size"));
        }

        public DynamicObjectCollection getData(int start, int limit) {
            List qFilters = this.getQFilters();
            Map map = BusinessDataServiceHelper.loadFromCache((String)FrontEndEntryListPlugin.CTS_FRONTEND_ENTRY, (String)"id,number,name,newname", (QFilter[])qFilters.toArray(new QFilter[0]));
            Collection elements = map.values();
            if (elements.size() == 0) {
                FrontEndEntryListPlugin.this.getPageCache().put("word_size", "0");
                return new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FrontEndEntryListPlugin.CTS_FRONTEND_ENTRY), null);
            }
            Map<String, List<DynamicObject>> listMap = elements.stream().collect(Collectors.groupingBy(this::fetchGroupKey));
            ArrayList<Object> ids = new ArrayList<Object>(16);
            for (Map.Entry<String, List<DynamicObject>> stringListEntry : listMap.entrySet()) {
                List<DynamicObject> dynamicObjects = stringListEntry.getValue();
                ids.add(dynamicObjects.get(0).getPkValue());
            }
            qFilters.add(new QFilter("id", "in", ids));
            FrontEndEntryListPlugin.this.getPageCache().put("word_size", String.valueOf(ids.size()));
            return super.getData(start, limit);
        }
    }
}

