/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.helper.CacheHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ImportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String BTNOK = "btnok";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String SUCCESSPANEL = "successpanel";
    private static final Log LOGGER = LogFactory.getLog(ImportProgressPlugin.class);
    private DistributeSessionlessCache cache = CacheHelper.getIntlTermCache();

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK, "btndetails", "buttonap"});
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"failpanel", SUCCESSPANEL, "btnclose", BTNOK});
        Label title = (Label)this.getControl("title");
        title.setText(ResManager.loadKDString((String)"HR\u672f\u8bed\u5e93", (String)"ImportProgressPlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        progress.start();
    }

    public void onProgress(ProgressEvent event) {
        int progress = 0;
        IFormView view = this.getView();
        String key = (String)view.getFormShowParameter().getCustomParam("key");
        String importInfo = (String)this.cache.get(key);
        Label title = (Label)this.getControl("title");
        title.setText(ResManager.loadKDString((String)"HR\u672f\u8bed\u5e93", (String)"ImportProgressPlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        if (StringUtils.isEmpty((CharSequence)importInfo)) {
            return;
        }
        JSONObject info = JSON.parseObject((String)importInfo);
        progress = info.getIntValue("importProgress");
        if (progress >= 0) {
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            Label handlecount = (Label)this.getControl("handlecount");
            int total = info.getIntValue("total");
            int curRow = info.getIntValue("curRow");
            int lastRow = info.getIntValue("lastRow");
            currRow.setText(curRow + "");
            rowCount.setText(lastRow + "");
            handlecount.setText(curRow + "");
            if (progress >= 100) {
                Label success;
                int failed = info.getIntValue("failed");
                if (failed > 0) {
                    success = (Label)this.getControl("success");
                    Label fail = (Label)this.getControl("failed");
                    success.setText(total - failed + "");
                    fail.setText(failed + "");
                    view.setVisible(Boolean.TRUE, new String[]{"failpanel", BTNOK});
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                    notHidden.put("gr", 1);
                    view.updateControlMetadata("failpanel", notHidden);
                    this.getPageCache().put("url", info.getString("url"));
                } else {
                    success = (Label)this.getControl("successall");
                    success.setText("" + total);
                    view.setVisible(Boolean.TRUE, new String[]{SUCCESSPANEL});
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                    notHidden.put("gr", 1);
                    view.updateControlMetadata(SUCCESSPANEL, notHidden);
                }
                view.setVisible(Boolean.FALSE, new String[]{"importpanel", "btncancel"});
                ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
                progressbar.stop();
                return;
            }
            if (lastRow > 0) {
                HashMap<String, Integer> meta = new HashMap<String, Integer>();
                meta.put("itime", 3000);
                view.updateControlMetadata(PROGRESSBARAP, meta);
            }
        } else {
            this.cache.remove(key);
            view.showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ImportProgressPlugin_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
            progressbar.stop();
            return;
        }
        event.setProgress(progress);
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        if ("btndetails".equals(controlKey)) {
            view.openUrl(this.getPageCache().get("url"));
        } else if (BTNOK.equals(controlKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cts_termwordimport");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack("kd.bos.formplugin.IntlTermWordPlugin", "import"));
            view.getParentView().showForm(showParameter);
            view.close();
        } else if ("buttonap".equals(controlKey)) {
            view.close();
        }
    }
}

