/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.common.builder.FilterAndSortBuilder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.enums.TermStatusEnum;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class IntlTermWordCompPlugin
extends AbstractListPlugin
implements CreateListColumnsListener {
    private static final String PK_IDS = "pkIds";
    private static final String COMP_SIZE = "compSize";
    private static final String MAX_COUNT = "maxCount";
    private static final String WORD_STATUS = "wordstatus";
    private static final String APPID = "appid";
    public static final String WORDID = "wordid";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl("billlistap1");
        billList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl("billlistap1");
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addHyperClickListener(args -> {
            Object pkId = ((BillListHyperLinkClickEvent)args).getCurrentRow().getPrimaryKeyValue();
            this.showCompForm(String.valueOf(pkId));
        });
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            listColumn.setBlankFieldCanOrderAndFilter(true);
            listColumn.setTextAlign("left");
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (StringUtils.equals((CharSequence)"cts_termwordcomp", (CharSequence)((BillList)evt.getSource()).getEntityId())) {
            evt.setCancel(true);
            return;
        }
        BillList billList1 = (BillList)this.getView().getControl("billlistap1");
        billList1.clearSelection();
        ListSelectedRowCollection selectedRowCollection = evt.getListSelectedRowCollection();
        if (selectedRowCollection != null && !selectedRowCollection.isEmpty()) {
            List pkIds = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            this.getPageCache().put(PK_IDS, SerializationUtils.toJsonString(pkIds));
            billList1.refresh();
        } else {
            this.getPageCache().remove(PK_IDS);
            billList1.clearData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("closeCompForm".equals(e.getActionId())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            BillList billList1 = (BillList)this.getView().getControl("billlistap1");
            billList.refresh();
            billList1.refresh();
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        BillList billList = (BillList)args.getSource();
        if ("cts_termwordcomp".equals(billList.getEntityId())) {
            args.setListDataProvider((IListDataProvider)new TermWordCompListProvider());
        }
    }

    private void updateTermWordComps(List<DynamicObject> data, Map<Long, String> idMap) {
        for (DynamicObject dynamicObject : data) {
            String wordStatus = idMap.get(dynamicObject.getLong("id"));
            dynamicObject.set(WORD_STATUS, (Object)(String.valueOf(TermStatusEnum.DEFAULT.getCode()).equals(wordStatus) ? "" : wordStatus));
        }
    }

    private Map<Long, String> mergeTermWordComps(List<DynamicObject> data) {
        HashMap<Long, String> idMap = new HashMap<Long, String>(16);
        Map<String, List<DynamicObject>> map = data.stream().collect(Collectors.groupingBy(e -> e.getString("wordcomp") + (e.getDynamicObject(APPID) == null ? "" : e.getDynamicObject(APPID).getString("name"))));
        HashMap partialMap = new HashMap();
        map.forEach((k, v) -> {
            DynamicObject dynamicObject;
            ArrayList<TermWordCompEntity> list = new ArrayList<TermWordCompEntity>(10);
            boolean hasReplacedStatus = false;
            boolean hasNotReplacedStatus = false;
            for (DynamicObject dy : v) {
                list.add(this.dyToEntity(dy));
                if (TermStatusEnum.REPLACED.getCode() == dy.getInt(WORD_STATUS)) {
                    hasReplacedStatus = true;
                    continue;
                }
                hasNotReplacedStatus = true;
            }
            if (hasReplacedStatus && hasNotReplacedStatus) {
                dynamicObject = v.stream().filter(e -> TermStatusEnum.REPLACED.getCode() == e.getInt(WORD_STATUS)).findFirst().orElseGet(() -> (DynamicObject)v.get(0));
                dynamicObject.set(WORD_STATUS, (Object)TermStatusEnum.PARTIAL_REPLACED.getCode());
                v.forEach(e -> {
                    if (StringUtils.isBlank((CharSequence)e.getString("wordcompcust"))) {
                        partialMap.put(e.getPkValue(), dynamicObject.getString("wordcompcust"));
                    }
                });
            } else {
                dynamicObject = v.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getString("wordcompcust"))).findFirst().orElseGet(() -> (DynamicObject)v.get(0));
            }
            idMap.put(dynamicObject.getLong("id"), dynamicObject.getString(WORD_STATUS));
            this.getPageCache().put(dynamicObject.getString("id"), SerializationUtils.toJsonString(list));
        });
        if (!partialMap.isEmpty()) {
            this.getPageCache().put("partial_replaced_id", SerializationUtils.toJsonString(partialMap));
        }
        return idMap;
    }

    private TermWordCompEntity dyToEntity(DynamicObject dynamicObject) {
        TermWordCompEntity entity = new TermWordCompEntity();
        entity.setId(dynamicObject.getLong("id"));
        entity.setLanid(dynamicObject.getString("lanid"));
        if (null != dynamicObject.getDynamicObject(APPID)) {
            entity.setAppid(dynamicObject.getDynamicObject(APPID).getString("id"));
        }
        entity.setWordstatus(dynamicObject.getString(WORD_STATUS));
        entity.setSubjectid(dynamicObject.getString("subjectid"));
        entity.setCategory(dynamicObject.getString("category"));
        entity.setKey(dynamicObject.getString("key"));
        entity.setWordid(dynamicObject.getDynamicObject(WORDID).getLong("id"));
        entity.setWordcomp(dynamicObject.getString("wordcomp"));
        entity.setWordcompcust(dynamicObject.getString("wordcompcust"));
        return entity;
    }

    private void showCompForm(String pkId) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("cts_termwordcomp_form");
        parameter.setPkId((Object)pkId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCompForm"));
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("entityType", (Object)"cts_termwordcomp");
        this.getView().showForm((FormShowParameter)parameter);
    }

    class TermWordCompListProvider
    extends ListDataProvider
    implements FilterAndSortBuilder {
        TermWordCompListProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            if (IntlTermWordCompPlugin.this.getPageCache().get(IntlTermWordCompPlugin.PK_IDS) == null) {
                return new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cts_termwordcomp"), null);
            }
            List wordids = (List)SerializationUtils.fromJsonString((String)IntlTermWordCompPlugin.this.getPageCache().get(IntlTermWordCompPlugin.PK_IDS), List.class);
            List qFilters = this.getQFilters();
            List status = null;
            for (QFilter qFilter : qFilters) {
                if (!IntlTermWordCompPlugin.WORD_STATUS.equals(qFilter.getProperty())) continue;
                status = (List)qFilter.getValue();
            }
            qFilters.removeIf(v -> IntlTermWordCompPlugin.WORD_STATUS.equals(v.getProperty()));
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(qFilters);
            filterList.add(new QFilter(IntlTermWordCompPlugin.WORDID, "in", (Object)wordids).and(new QFilter("enable", "=", (Object)Character.valueOf('1'))));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"cts_termwordcomp", (String)"id,lanid,appid, wordid, wordstatus, wordcomp, wordcompcust, key, category, subjectid", (QFilter[])filterList.toArray(new QFilter[0]));
            Map idMap = IntlTermWordCompPlugin.this.mergeTermWordComps(Arrays.asList(load));
            if (status != null && !status.isEmpty()) {
                Iterator iterator = idMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String value = (String)iterator.next().getValue();
                    if (status.contains(value)) continue;
                    iterator.remove();
                }
            }
            qFilters.add(new QFilter("id", "in", idMap.keySet()));
            DynamicObjectCollection data = super.getData(start, limit);
            IntlTermWordCompPlugin.this.updateTermWordComps((List)data, idMap);
            Map<String, List<DynamicObject>> map = data.stream().collect(Collectors.groupingBy(e -> e.getString(IntlTermWordCompPlugin.WORDID)));
            data.clear();
            AtomicBoolean isDesc = new AtomicBoolean(false);
            if (this.getOrderByExpr() != null && this.getOrderByExpr().contains("wordstatus desc")) {
                isDesc.set(true);
            }
            map.forEach((k, v) -> {
                v.sort(this.compStatusComparator(isDesc.get()));
                data.addAll((Collection)v);
            });
            return data;
        }
    }
}

