/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.enums.TermStatusEnum;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.BaseDataUtil;

public class IntlTermWordFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(IntlTermWordFormPlugin.class);
    private static final String ID = "id";
    private static final String LANID = "lanid";
    private static final String TERMWORD = "termword";
    private static final String TERMWORDCUST = "termwordcust";
    private static final String APPID = "appid";
    private static final String CLOUDID = "cloudid";
    private static final String WORDID = "wordid";
    private static final String CATEGORY = "category";
    private static final String WORDCOMP = "wordcomp";
    private static final String WORDSTATUS = "wordstatus";
    private static final String WORDCOMPCUST = "wordcompcust";
    private static final String MODIFIER = "modifier";
    private static final String MODIFYTIME = "modifytime";
    public static final String TERM_WORD_ENTITY = "cts_termword";
    private static final String CONFIRM_CALLBACK_ID = "confirmCallback";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit appid = (BasedataEdit)this.getControl(APPID);
        appid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cloudid = (BasedataEdit)this.getControl(CLOUDID);
        cloudid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit lanid = (BasedataEdit)this.getControl(LANID);
        lanid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            this.getModel().setValue(ID, parameter.getCustomParam(ID));
            this.getModel().setValue(TERMWORD, parameter.getCustomParam(TERMWORD));
            this.getModel().setValue(TERMWORDCUST, parameter.getCustomParam(TERMWORDCUST));
            this.getModel().setValue(APPID, parameter.getCustomParam(APPID));
            this.getModel().setValue(CLOUDID, parameter.getCustomParam(CLOUDID));
            this.getModel().setValue(LANID, parameter.getCustomParam(LANID));
            this.getModel().setValue(WORDSTATUS, parameter.getCustomParam(WORDSTATUS));
            this.getPageCache().put(TERMWORDCUST, (String)parameter.getCustomParam(TERMWORDCUST));
            this.getView().setEnable(Boolean.FALSE, new String[]{TERMWORD, APPID, CLOUDID, LANID});
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            this.getModel().setValue(LANID, (Object)BaseDataUtil.getLangIdByLanNum(Lang.get().name()));
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            String term = (String)this.getModel().getValue(TERMWORD);
            String termwordcust = (String)this.getModel().getValue(TERMWORDCUST);
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
                if (!this.checkTermEdit(term, termwordcust).booleanValue()) {
                    return;
                }
                DynamicObject termWord = this.getModel().getDataEntity();
                DynamicObject termword1 = null;
                String newTermWord = "";
                if (term != null) {
                    newTermWord = termWord.getString(1);
                    termword1 = BusinessDataServiceHelper.loadSingle((String)TERM_WORD_ENTITY, (String)"id, termword, termwordcust", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)termWord.getLong(ID))});
                }
                if (termword1 != null && newTermWord != null && newTermWord.equals(termword1.getString(TERMWORDCUST))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u201c\u65b0\u540d\u79f0\u201d\u4e0e\u539f\u6765\u7684\u201c\u65b0\u540d\u79f0\u201d\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordFormPlugin_6", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String fid = this.getModel().getValue(ID).toString();
                DynamicObject[] comps = IntlTermWordFormPlugin.getDynamicObjectArrayById(fid);
                if (comps == null || comps.length == 0) {
                    TermReplaceHelper.updateTermWordStatus(Long.valueOf(fid), null, termwordcust);
                    this.getView().close();
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_CALLBACK_ID, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u66f4\u65b0\u5305\u542b\u672f\u8bed\u7684\u8bcd\u6761\uff1f", (String)"IntlTermWordFormPlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
            }
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                String landid = ((DynamicObject)this.getModel().getValue(LANID)).getPkValue().toString();
                Object appid = this.getModel().getValue(APPID);
                String appidStr = "";
                if (appid != null) {
                    appidStr = ((DynamicObject)this.getModel().getValue(APPID)).getPkValue().toString();
                }
                Object cloudid = this.getModel().getValue(CLOUDID);
                String cloudidStr = null;
                if (cloudid != null) {
                    cloudidStr = ((DynamicObject)this.getModel().getValue(CLOUDID)).getPkValue().toString();
                }
                if (this.checkTermAdd(term, termwordcust, landid, appidStr, cloudidStr).booleanValue()) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TERM_WORD_ENTITY);
                    dynamicObject.set(TERMWORD, (Object)term);
                    dynamicObject.set(ENABLE, (Object)Character.valueOf('1'));
                    dynamicObject.set(STATUS, (Object)"C");
                    dynamicObject.set(TERMWORDCUST, (Object)termwordcust);
                    dynamicObject.set(LANID, (Object)Long.parseLong(landid));
                    dynamicObject.set(APPID, (Object)appidStr);
                    dynamicObject.set(CLOUDID, (Object)cloudidStr);
                    dynamicObject.set(WORDSTATUS, (Object)TermStatusEnum.DEFAULT.getCode());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    this.getView().close();
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (CONFIRM_CALLBACK_ID.equals(messageBoxClosedEvent.getCallBackId())) {
            String fid = this.getModel().getValue(ID).toString();
            String term = this.getModel().getValue(TERMWORD).toString();
            String termwordcust = this.getModel().getValue(TERMWORDCUST).toString().trim();
            DynamicObject[] comps = IntlTermWordFormPlugin.getDynamicObjectArrayById(fid);
            if (!MessageBoxResult.Cancel.name().equals(messageBoxClosedEvent.getResult().name())) {
                TermReplaceHelper.updateTermWordComp(comps, term, termwordcust);
                TermReplaceHelper.updateTermWordStatus(Long.valueOf(fid), TermStatusEnum.PENDING_REPLACE.getCode(), termwordcust);
            } else {
                TermReplaceHelper.updateTermWordStatus(Long.valueOf(fid), null, termwordcust);
            }
            this.getView().close();
        }
    }

    private Boolean checkTermEdit(String originalTerm, String newTerm) {
        if (StringUtils.isEmpty((CharSequence)newTerm)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b0\u540d\u79f0", (String)"IntlTermWordFormPlugin_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (StringUtils.equals((CharSequence)newTerm, (CharSequence)originalTerm)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u540d\u79f0\u4e0e\u539f\u540d\u79f0\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordFormPlugin_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (!StringUtils.isEmpty((CharSequence)newTerm) && newTerm.length() > 80) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u540d\u79f0\u957f\u5ea6\u8d85\u8fc780\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordFormPlugin_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkTermAdd(String originalTerm, String newTerm, String landid, String appid, String cloudid) {
        DynamicObject dynamicObject;
        if (StringUtils.equals((CharSequence)newTerm, (CharSequence)originalTerm)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u540d\u79f0\u4e0e\u539f\u540d\u79f0\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordFormPlugin_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (!StringUtils.isEmpty((CharSequence)newTerm) && newTerm.length() > 80) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u540d\u79f0\u957f\u5ea6\u8d85\u8fc780\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordFormPlugin_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        QFilter qFilter = new QFilter(LANID, "=", (Object)Long.parseLong(landid));
        qFilter.and(TERMWORD, "=", (Object)originalTerm);
        if (appid != null) {
            qFilter.and(APPID, "=", (Object)appid);
        }
        if (cloudid != null) {
            qFilter.and(CLOUDID, "=", (Object)cloudid);
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)TERM_WORD_ENTITY, (QFilter[])qFilter.toArray())) != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u672f\u8bed\u5df2\u5b58\u5728\u3002", (String)"IntlTermWordFormPlugin_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static DynamicObject[] getDynamicObjectArrayById(String fid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)fid, (String)TERM_WORD_ENTITY);
        QFilter[] qFilters = new QFilter[]{new QFilter(LANID, "=", dynamicObject.getDynamicObject(LANID).getPkValue()), new QFilter(WORDID, "=", (Object)Long.valueOf(fid)), new QFilter(WORDSTATUS, "not in", Arrays.asList("2", "3", "4"))};
        String selectProperties = "id, wordcomp, wordid, wordcompcust, wordstatus, modifier, modifytime";
        return BusinessDataServiceHelper.load((String)"cts_termwordcomp", (String)selectProperties, (QFilter[])qFilters);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        Object cloudId = this.getModel().getValue(CLOUDID);
        if (LANID.equals(name)) {
            Map<String, String> lanId2Name = BaseDataUtil.getEnabledLanguage();
            List filters = evt.getCustomQFilters();
            List collect = lanId2Name.keySet().stream().map(Long::parseLong).collect(Collectors.toList());
            QFilter qFilter = new QFilter(ID, "in", collect);
            filters.add(qFilter);
        }
        if (cloudId != null && APPID.equals(name)) {
            List filters = evt.getCustomQFilters();
            List<String> appIds = this.getBizIdsByCloudId(((DynamicObject)cloudId).getPkValue().toString());
            QFilter qFilter = new QFilter(ID, "in", appIds);
            filters.add(qFilter);
        }
    }

    private List<String> getBizIdsByCloudId(String bizCloudId) {
        QFilter qFilter = new QFilter("bizcloud", "=", (Object)bizCloudId);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])qFilter.toArray());
        return dynamicObjectMap.keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (CLOUDID.equals(e.getProperty().getName())) {
            Object oldCloudId = e.getChangeSet()[0].getOldValue();
            Object newCloudId = e.getChangeSet()[0].getNewValue();
            if (newCloudId == null || oldCloudId != null && !((DynamicObject)oldCloudId).getPkValue().equals(((DynamicObject)newCloudId).getPkValue())) {
                this.getModel().setValue(APPID, null);
            }
        }
    }
}

