/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.enums.TermStatusEnum;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.helper.CacheHelper;
import kd.bos.helper.ExcelImExportUtil;
import kd.bos.helper.ExcelUtil;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class IntlTermWordImportPlugin
extends AbstractFormPlugin
implements UploadListener,
RowClickEventListener {
    public static final String FLANID = "flanid";
    public static final String FAPPID = "fappid";
    public static final String FWORDCOMP = "fwordcomp";
    private Log logger = LogFactory.getLog(IntlTermWordImportPlugin.class);
    protected DistributeSessionlessCache fileHandleCache = CacheHelper.getIntlTermCache();
    private String entity = "t_cts_termword";
    private String importCTSTermwordProcessFlag = "importCTSTermwordProcessFlag";
    private Map<String, Object> progressMap;
    private List<List<String>> validData = new ArrayList<List<String>>(10);
    private static final String WORDCOMP = "wordcomp";
    private static final String WORDCOMPCUST = "wordcompcust";
    public static final String UPLOAD_URLS = "upload_urls";
    public static final String IMPORT_PROGRESS = "importProgress";
    public static final String FILE_LIST_ = "_file_list_";
    public static final String URLSFLEX = "urlsflex";
    public static final String ERROR_INFO = "errorInfo";
    public static final String IS_CORRECT = "isCorrect";

    public void initialize() {
        String cacheUrls = this.getPageCache().get(FILE_LIST_);
        if (StringUtils.isBlank((CharSequence)cacheUrls)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{URLSFLEX});
        }
        this.addClickListeners(new String[]{"btnok", "btndel", "btnupload", "btndownload"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                JSONObject importProgress;
                LocaleString ls = new LocaleString(ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"IntlTermWordImportPlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                this.getView().showLoading(ls);
                String cacheUrls = this.getPageCache().get(FILE_LIST_);
                if (StringUtils.isBlank((CharSequence)cacheUrls)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\uff0c\u6216\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"IntlTermWordImportPlugin_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    this.getView().hideLoading();
                    return;
                }
                String progress = (String)this.fileHandleCache.get(this.importCTSTermwordProcessFlag);
                if (progress != null && (progress = (importProgress = JSON.parseObject((String)progress)).getString(IMPORT_PROGRESS)) != null && !"100".equals(progress) && !"-1".equals(progress)) {
                    this.getView().hideLoading();
                    return;
                }
                try {
                    if (!this.checkTitle(cacheUrls)) {
                        this.getView().hideLoading();
                        return;
                    }
                }
                catch (Exception ex) {
                    this.logger.error(String.format("\u68c0\u67e5\u8868\u5934\u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u4e3a: %s", ex));
                }
                ThreadPools.executeOnceIncludeRequestContext((String)this.importCTSTermwordProcessFlag, this::importData);
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
                this.getView().hideLoading();
                break;
            }
            case "btndel": {
                IDataModel model = this.getModel();
                int i = model.getEntryCurrentRowIndex(UPLOAD_URLS);
                String cacheUrls = this.getPageCache().get(FILE_LIST_);
                List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
                String url = (String)model.getValue("url", i);
                filelist.removeIf(f -> f.get("url").equals(url));
                if (filelist.size() != 0) {
                    this.getPageCache().put(FILE_LIST_, SerializationUtils.serializeToBase64(filelist));
                    model.deleteEntryRow(UPLOAD_URLS, i);
                } else {
                    this.getPageCache().remove(FILE_LIST_);
                    model.deleteEntryRow(UPLOAD_URLS, i);
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{URLSFLEX});
                break;
            }
        }
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        this.showLoadingOnBeforeUpload();
    }

    private void showLoadingOnBeforeUpload() {
        Boolean canUpload = this.canContinueUploadFile();
        if (!canUpload.booleanValue()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u4e0a\u4f20\u4e00\u4e2a\u6587\u4ef6\u3002", (String)"IntlTermWordImportPlugin_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            LocaleString ls = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u4e0a\u4f20\u4e2d", (String)"IntlTermWordImportPlugin_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            this.getView().showLoading(ls);
        } else {
            LocaleString ls = new LocaleString(ResManager.loadKDString((String)"\u4e0a\u4f20\u4e2d", (String)"IntlTermWordImportPlugin_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            this.getView().showLoading(ls);
        }
    }

    public Boolean canContinueUploadFile() {
        ArrayList files = new ArrayList();
        String cacheUrls = this.getPageCache().get(FILE_LIST_);
        if (StringUtils.isNotBlank((CharSequence)cacheUrls)) {
            files.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)cacheUrls));
        }
        if (files.size() >= 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{URLSFLEX});
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList filelist = new ArrayList();
        String cacheUrls = this.getPageCache().get(FILE_LIST_);
        if (StringUtils.isNotBlank((CharSequence)cacheUrls)) {
            filelist.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)cacheUrls));
        }
        Arrays.stream(evt.getUrls()).forEach(fileUrlObj -> {
            HashMap<String, String> fileInfo = new HashMap<String, String>();
            fileInfo.put("url", (String)fileUrlObj);
            String fileUrl = (String)fileInfo.get("url");
            if (StringUtils.isNotBlank((CharSequence)fileUrl)) {
                filelist.add(fileInfo);
            }
            IDataModel model = this.getModel();
            int index = model.createNewEntryRow(UPLOAD_URLS);
            model.setValue("url", (Object)fileUrl, index);
            model.setValue("name", (Object)fileUrl.substring(fileUrl.lastIndexOf(47) + 1), index);
            this.getPageCache().put("currentrow", index + "");
        });
        this.getView().setVisible(Boolean.TRUE, new String[]{URLSFLEX});
        this.getPageCache().put(FILE_LIST_, SerializationUtils.serializeToBase64(filelist));
        this.getView().hideLoading();
    }

    public void upload(UploadEvent uploadEvent) {
        Boolean canUpload = this.canContinueUploadFile();
        if (!canUpload.booleanValue()) {
            uploadEvent.setCancel(true);
            this.getView().hideLoading();
        }
    }

    protected List<Workbook> getWorkbooks() throws IOException, InvalidFormatException {
        String cacheUrls = this.getPageCache().get(FILE_LIST_);
        if (StringUtils.isBlank((CharSequence)cacheUrls)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\uff0c\u6216\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"IntlTermWordImportPlugin_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return new ArrayList<Workbook>();
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        List filelist = (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        ArrayList<Workbook> workbooks = new ArrayList<Workbook>(10);
        for (Map fileInfo : filelist) {
            String fileUrl = (String)fileInfo.get("url");
            workbooks.add(WorkbookFactory.create((InputStream)fileService.getInputStream(fileUrl)));
        }
        return workbooks;
    }

    protected void importData() {
        try {
            List<Workbook> workbooks = this.getWorkbooks();
            for (Workbook workbook : workbooks) {
                this.handle(workbook, this.entity);
            }
        }
        catch (Exception e) {
            this.progressMap.put(IMPORT_PROGRESS, -1);
            this.logger.error(String.format("\u3010%s\u3011\u5f15\u5165\u6570\u636e\u5931\u8d25", this.importCTSTermwordProcessFlag), (Throwable)e);
        }
        this.fileHandleCache.put(this.importCTSTermwordProcessFlag, (Object)JSONObject.toJSONString(this.progressMap), 600);
    }

    private boolean checkRowData(Row row, Map<String, Object> existsMap) {
        boolean flag = true;
        String formatErrorInfo = ExcelImExportUtil.checkExcelLineFormat(row);
        Map<String, Object> resultMap = this.existsData(row);
        existsMap.putAll(resultMap);
        Boolean exists = (Boolean)existsMap.get(IS_CORRECT);
        if (formatErrorInfo != null || !exists.booleanValue()) {
            List<String> errordata = ExcelImExportUtil.buildErrorData(row);
            if (errordata.size() > 0) {
                ArrayList<String> error = new ArrayList<String>(10);
                this.validData.add(error);
                String element = ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u5230\u7cfb\u7edf\u5185\u5bb9\uff0c{\u5b57\u6bb51,\u5b57\u6bb52\uff0c\u5b57\u6bb5n}\u5e94\u4e0e\u7cfb\u7edf\u5185\u5b8c\u5168\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntlTermWordImportPlugin_5", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
                if (formatErrorInfo != null) {
                    element = formatErrorInfo;
                }
                if (!exists.booleanValue()) {
                    element = (String)existsMap.get(ERROR_INFO);
                }
                error.add(0, element);
                error.addAll(errordata);
            }
            flag = false;
        }
        return flag;
    }

    protected void handle(Workbook workbook, String entityName) throws Exception {
        Sheet sheet = workbook.getSheetAt(0);
        ArrayList<Object> titles = new ArrayList<Object>();
        titles.add(ResManager.loadKDString((String)"\u5f02\u5e38\u539f\u56e0", (String)"IntlTermWordImportPlugin_7", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        this.progressMap = new HashMap<String, Object>(16);
        int blankRowNum = 0;
        for (int rowNo = 1; rowNo <= sheet.getLastRowNum(); ++rowNo) {
            block6: {
                this.fileHandleCache.put(this.importCTSTermwordProcessFlag, (Object)JSONObject.toJSONString(this.progressMap), 600);
                this.progressMap.put("curRow", rowNo);
                this.progressMap.put(IMPORT_PROGRESS, rowNo * 100 / sheet.getLastRowNum());
                this.progressMap.put("lastRow", sheet.getLastRowNum());
                this.progressMap.put("total", sheet.getLastRowNum() - blankRowNum);
                Row row = sheet.getRow(rowNo);
                boolean flag = true;
                if (row == null) {
                    ++blankRowNum;
                    flag = false;
                }
                HashMap<String, Object> existsMap = new HashMap<String, Object>();
                if (flag) {
                    flag = this.checkRowData(row, existsMap);
                }
                if (flag) {
                    Long fid = (Long)existsMap.get("fid");
                    String type = (String)existsMap.get("type");
                    try {
                        this.handleData(row, fid, type);
                    }
                    catch (Exception e) {
                        List<String> errordata = ExcelImExportUtil.buildErrorData(row);
                        if (errordata.size() <= 0) break block6;
                        ArrayList<String> error = new ArrayList<String>(10);
                        this.validData.add(error);
                        error.add(0, ResManager.loadKDString((String)"HR\u672f\u8bed\u65b0\u540d\u79f0\u66f4\u65b0\u5931\u8d25\u3002", (String)"IntlTermWordImportPlugin_8", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                        error.addAll(errordata);
                    }
                }
            }
            if (rowNo != sheet.getLastRowNum()) continue;
            titles.addAll(Arrays.asList((Object[])ExcelImExportUtil.getExcelTitleLine().get(entityName)));
            ArrayList<List<String>> errorData = new ArrayList<List<String>>();
            errorData.add(titles);
            errorData.addAll(this.validData);
            this.progressMap.put("failed", errorData.size() - 1);
            this.progressMap.put(IMPORT_PROGRESS, 100);
            this.progressMap.put("url", ExcelUtil.createExcel(errorData, ExcelImExportUtil.getErrorTableName()));
        }
    }

    protected void handleData(Row row, Long fid, String type) throws Exception {
        String originalTermword = ExcelUtil.getCellValue(row.getCell(2));
        try {
            if ("TERM".equals(type)) {
                IntlTermWordImportPlugin.updateTerm(row, fid);
            } else if ("WORD".equals(type)) {
                IntlTermWordImportPlugin.updateWord(row, fid);
            }
        }
        catch (Exception exception) {
            this.logger.error("\u8bcd\u6761\u5f15\u5165\u5931\u8d25", (Throwable)exception);
            throw exception;
        }
    }

    private static void updateTerm(Row row, Long fid) {
        String termWordCustStr = ExcelUtil.getCellValue(row.getCell(3));
        if (termWordCustStr != null && !"".equals(termWordCustStr) && !" ".equals(termWordCustStr)) {
            String selectSql = "SELECT ftermword FROM t_cts_termword WHERE fid = ?";
            Object[] params = new Object[]{fid};
            String termword = (String)DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])params, rs -> {
                String ftermword = null;
                while (rs.next()) {
                    ftermword = rs.getString("ftermword");
                }
                return ftermword;
            });
            if (StringUtils.isBlank((CharSequence)termword)) {
                return;
            }
            TermReplaceHelper.updateTermWordStatus(fid, null, termWordCustStr);
        }
    }

    private static void updateWord(Row row, Long fid) throws Exception {
        String wordCompCustStr = ExcelUtil.getCellValue(row.getCell(3));
        String querySql = "SELECT termwordcomp.fwordcompcust as fwordcompcust,termwordcomp.flanid as flanid,termwordcomp.fid as fid,termwordcomp.fwordcomp as fwordcomp,termword.fappid as fappid FROM t_cts_termwordcomp termwordcomp INNER JOIN t_cts_termword termword ON termwordcomp.fwordid = termword.fid WHERE termwordcomp.fid = ?";
        Object[] queryParams = new Object[]{fid};
        HashMap result = new HashMap(16);
        DB.query((DBRoute)DBRoute.basedata, (String)querySql, (Object[])queryParams, rs -> {
            String wordComp = null;
            String wordCompCust = null;
            String appId = null;
            String lanId = null;
            while (rs.next()) {
                wordComp = rs.getString(FWORDCOMP);
                wordCompCust = rs.getString("fwordcompcust");
                appId = rs.getString(FAPPID);
                lanId = rs.getString(FLANID);
            }
            result.put(FWORDCOMP, wordComp);
            result.put("fwordcompcust", wordCompCust);
            result.put(FAPPID, appId);
            result.put(FLANID, lanId);
            return result;
        });
        if (wordCompCustStr != null && !"".equals(wordCompCustStr) && !" ".equals(wordCompCustStr)) {
            String wordComp = (String)result.get(FWORDCOMP);
            String appId = (String)result.get(FAPPID);
            long lanId = Long.parseLong((String)result.get(FLANID));
            if (wordComp == null || appId == null) {
                throw new Exception();
            }
            String queryWordIdList = "SELECT fid FROM t_cts_termword WHERE fappid = ? and fenable = '1' and flanid = ?";
            List wordIdList = (List)DB.query((DBRoute)DBRoute.basedata, (String)queryWordIdList, (Object[])new Object[]{appId, lanId}, rs -> {
                ArrayList<Long> idList = new ArrayList<Long>(10);
                while (rs.next()) {
                    idList.add(rs.getLong("fid"));
                }
                return idList;
            });
            if (wordIdList.size() > 0) {
                Object[] params = new Object[]{wordCompCustStr, TermStatusEnum.PENDING_REPLACE.getCode(), wordComp};
                StringBuilder updateSql = new StringBuilder();
                updateSql.append("UPDATE t_cts_termwordcomp SET fwordcompcust = ? , fwordstatus = ? ");
                updateSql.append("WHERE fwordcomp = ? AND fwordid IN (");
                for (Long wordId : wordIdList) {
                    updateSql.append(wordId).append(',');
                }
                updateSql.deleteCharAt(updateSql.length() - 1);
                updateSql.append(')');
                DB.update((DBRoute)DBRoute.basedata, (String)updateSql.toString(), (Object[])params);
                TermReplaceHelper.updateStatus(wordIdList.toArray(), null, TermStatusEnum.PENDING_REPLACE.getCode());
            }
        }
    }

    protected Map<String, Object> existsData(Row row) {
        HashMap<String, Object> existMap = new HashMap<String, Object>(16);
        String fidStr = ExcelUtil.getCellValue(row.getCell(0));
        String custName = ExcelUtil.getCellValue(row.getCell(3));
        String appid = ExcelUtil.getCellValue(row.getCell(5));
        if (fidStr.contains("T")) {
            Long fid = Long.valueOf(fidStr.replace("T", ""));
            boolean cts_termword = QueryServiceHelper.exists((String)"cts_termword", (Object)fid);
            if (cts_termword) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"cts_termword");
                DynamicObject dbAppid = dynamicObject.getDynamicObject("appid");
                String termwordcust = dynamicObject.getString("termwordcust");
                String wordstatus = dynamicObject.getString("wordstatus");
                if (dbAppid == null && StringUtils.isNotBlank((CharSequence)appid)) {
                    existMap.put(IS_CORRECT, Boolean.FALSE);
                    existMap.put(ERROR_INFO, ResManager.loadKDString((String)"\u8bf7\u5220\u9664\u8be5\u884c\u6570\u636e\u6240\u5c5e\u5e94\u7528\uff0c\u5e76\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"IntlTermWordImportPlugin_15", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                } else if (dbAppid != null && !dbAppid.getString("name").equals(appid)) {
                    existMap.put(IS_CORRECT, Boolean.FALSE);
                    existMap.put(ERROR_INFO, ResManager.loadKDString((String)"\u8bf7\u52ff\u4fee\u6539\u6570\u636e\u6240\u5c5e\u5e94\u7528\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"IntlTermWordImportPlugin_17", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                } else if (custName.equals(termwordcust)) {
                    existMap.put(IS_CORRECT, Boolean.TRUE);
                    existMap.put("type", "TERM");
                    existMap.put("fid", fid);
                } else if (String.valueOf(TermStatusEnum.REPLACED.getCode()).equals(wordstatus) || String.valueOf(TermStatusEnum.PARTIAL_REPLACED.getCode()).equals(wordstatus)) {
                    existMap.put(IS_CORRECT, Boolean.FALSE);
                    existMap.put(ERROR_INFO, ResManager.loadKDString((String)"\u201c\u5df2\u66ff\u6362\u201d\u6216\u201c\u90e8\u5206\u66ff\u6362\u201d\u72b6\u6001\u7684\u672f\u8bed\uff0c\u4e0d\u80fd\u5bfc\u5165\u65b0\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordImportPlugin_18", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                } else {
                    existMap.put(IS_CORRECT, Boolean.TRUE);
                    existMap.put("type", "TERM");
                    existMap.put("fid", fid);
                }
            } else {
                existMap.put(IS_CORRECT, Boolean.FALSE);
                existMap.put(ERROR_INFO, ResManager.loadKDString((String)"\u8be5\u884c\u6570\u636e\u4e0d\u5b58\u5728\u4e8e\u672f\u8bed\u5217\u8868\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordImportPlugin_9", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            }
        } else if (fidStr.contains("W")) {
            Long fid = Long.valueOf(fidStr.replace("W", ""));
            boolean exists = QueryServiceHelper.exists((String)"cts_termwordcomp", (Object)fid);
            if (exists) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"cts_termwordcomp");
                String wordstatus = dynamicObject.getString("wordstatus");
                String wordcompcust = dynamicObject.getString(WORDCOMPCUST);
                if (custName.equals(wordcompcust)) {
                    existMap.put(IS_CORRECT, Boolean.TRUE);
                    existMap.put("type", "WORD");
                    existMap.put("fid", fid);
                } else if (String.valueOf(TermStatusEnum.REPLACED.getCode()).equals(wordstatus)) {
                    existMap.put(IS_CORRECT, Boolean.FALSE);
                    existMap.put(ERROR_INFO, ResManager.loadKDString((String)"\u201c\u5df2\u66ff\u6362\u201d\u6216\u201c\u90e8\u5206\u66ff\u6362\u201d\u72b6\u6001\u7684\u8bcd\u6761\uff0c\u4e0d\u80fd\u5bfc\u5165\u65b0\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordImportPlugin_19", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                } else {
                    existMap.put(IS_CORRECT, Boolean.TRUE);
                    existMap.put("type", "WORD");
                    existMap.put("fid", fid);
                }
            } else {
                existMap.put(IS_CORRECT, Boolean.FALSE);
                existMap.put(ERROR_INFO, ResManager.loadKDString((String)"\u8be5\u884c\u6570\u636e\u4e0d\u5b58\u5728\u4e8e\u8bcd\u6761\u5217\u8868\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordImportPlugin_10", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            }
        } else {
            String numberName = ResManager.loadKDString((String)"\u7f16\u7801", (String)"IntlTermWordImportPlugin_16", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
            String errorInfo = String.format(ResManager.loadKDString((String)"\u8be5\u884c\u6570\u636e%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordImportPlugin_12", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), numberName);
            existMap.put(IS_CORRECT, Boolean.FALSE);
            existMap.put(ERROR_INFO, errorInfo);
        }
        return existMap;
    }

    private int getQuery(Long fid, String sql) {
        return (Integer)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{fid}, rs -> {
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            return count;
        });
    }

    private boolean checkTitle(String cacheUrls) throws IOException, InvalidFormatException {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        List files = (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        if (files.size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u4e0a\u4f20\u4e00\u4e2a\u6587\u4ef6\u3002", (String)"IntlTermWordImportPlugin_13", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String fileUrl = (String)((Map)files.get(0)).get("url");
        Workbook workbook = WorkbookFactory.create((InputStream)fileService.getInputStream(fileUrl));
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet == null || sheet.getLastRowNum() == 0 || !ExcelImExportUtil.checkExcelTitle(this.entity, sheet.getRow(0)).booleanValue()) {
            this.getPageCache().remove(FILE_LIST_);
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u4e0b\u8f7d\u6587\u4ef6\u5e76\u4fdd\u6301\u539f\u6709\u683c\u5f0f\u548c\u5b57\u6bb5\u3002", (String)"IntlTermWordImportPlugin_14", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{URLSFLEX});
            IDataModel model = this.getModel();
            model.deleteEntryRow(UPLOAD_URLS, Integer.parseInt(this.getPageCache().get("currentrow")));
            return false;
        }
        return true;
    }
}

