/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.enums.AppWordTypeEnum;
import kd.bos.enums.TermStatusEnum;
import kd.bos.enums.TermWordLogTypeEnum;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.helper.CacheHelper;
import kd.bos.helper.ExcelUtil;
import kd.bos.helper.JobFormInfoHelper;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.BaseDataUtil;
import kd.bos.util.PermitemVerifyUtil;

public class IntlTermWordPlugin
extends AbstractListPlugin
implements ClickListener,
RowClickEventListener {
    private static final String ID = "id";
    private static final String LANID = "lanid";
    private static final String WORDID = "wordid";
    private static final String CATEGORY = "category";
    private static final String PKIDS = "pkIds";
    private static final String LANG_ID = "lanId";
    private static final String TERMWORD = "termword";
    private static final String TERMWORDCUST = "termwordcust";
    private static final String APPID = "appid";
    private static final String CLOUDID = "cloudid";
    private static final String ENABLE = "enable";
    private static final String IS_SYSTEM = "issystem";
    private static final String CTS_TERM_PROMPTWORD = "cts_term_promptword";
    private static final String CTS_TERMWORD = "cts_termword";
    private static final String CTS_TERMWORDCOMP = "cts_termwordcomp";
    private static final String WORDCOMP = "wordcomp";
    public static final String BTN_PRESET = "btn_preset";
    private static final String WORDSTATUS = "wordstatus";
    private static final String WORDCOMPCUST = "wordcompcust";
    private static final String CUSTOM_ACTION_ID = "closeForm";
    private static final String FIELD_NAME = "FieldName";
    private static final String VALUE = "Value";
    private static final String TASK_CLOSE_CALL_BACK = "taskCloseBack";
    private static final String TERM_WORD_COMP_TASK = "termWordCompTask";
    private final DistributeSessionlessCache cache = CacheHelper.getIntlTermCache();
    private String importCTSTermwordProcessFlag = "importCTSTermwordProcessFlag";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap1");
        billList.clearData();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        BillList billList1 = (BillList)this.getView().getControl("billlistap1");
        ListSelectedRowCollection listSelectedRows1 = billList1.getSelectedRows();
        List<Long> termIds = listSelectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        List<Long> selectCompIds = listSelectedRows1.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        switch (evt.getItemKey()) {
            case "btn_new": {
                FormShowParameter newShowParameter = new FormShowParameter();
                newShowParameter.setFormId("cts_termwordform");
                newShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                newShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CUSTOM_ACTION_ID));
                this.getView().showForm(newShowParameter);
                break;
            }
            case "delete": {
                if (termIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"IntlTermWordPlugin_41", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.deleteTermwordCheck(termIds);
                break;
            }
            case "btn_check_log": {
                this.showCheckLogPage(termIds, selectCompIds);
                break;
            }
            case "btn_import_add": {
                this.importAdd();
                break;
            }
            case "btn_import": {
                String processCacheStr = (String)this.cache.get(this.importCTSTermwordProcessFlag);
                if (processCacheStr != null) {
                    if ("{}".equals(processCacheStr)) {
                        this.showProgressForm(this.importCTSTermwordProcessFlag);
                        return;
                    }
                    JSONObject importProgress = JSON.parseObject((String)processCacheStr);
                    Object progress = importProgress.get((Object)"importProgress");
                    if (progress != null && !progress.toString().equals("100") && !progress.toString().equals("-1")) {
                        this.showProgressForm(this.importCTSTermwordProcessFlag);
                        return;
                    }
                }
                this.cache.remove(this.importCTSTermwordProcessFlag);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cts_termwordimport");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import"));
                this.getView().showForm(showParameter);
                break;
            }
            case "btn_export": {
                String url = ExcelUtil.exportTermAndWord(this.getView(), this.getPageCache());
                this.getView().openUrl(url);
                break;
            }
            case "btn_fill": {
                DynamicObject[] terms;
                if (termIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u586b\u5145\u7684\u6570\u636e\u3002", (String)"IntlTermWordPlugin_35", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter termQFilter = new QFilter(ID, "in", termIds);
                for (DynamicObject term : terms = BusinessDataServiceHelper.load((String)CTS_TERMWORD, (String)"id,termwordcust", (QFilter[])termQFilter.toArray())) {
                    if (!StringUtils.isBlank((CharSequence)term.getString(TERMWORDCUST))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u586b\u5145\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u672f\u8bed\u65b0\u540d\u79f0\u540e\u91cd\u8bd5\u3002", (String)"IntlTermWordPlugin_28", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                StringJoiner joiner = new StringJoiner(",");
                termIds.forEach(id -> joiner.add(id.toString()));
                String fillTermIds = joiner.toString();
                evt.setCancel(true);
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                map.put(6, ResManager.loadKDString((String)"\u8986\u76d6", (String)"IntlTermWordPlugin_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                map.put(7, ResManager.loadKDString((String)"\u4e0d\u8986\u76d6", (String)"IntlTermWordPlugin_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("btn_fill", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8986\u76d6\u5df2\u6709\u201c\u65b0\u540d\u79f0\u201d\uff1f", (String)"IntlTermWordPlugin_36", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNoCancel, ConfirmTypes.Save, confirmCallBackListener, map, fillTermIds);
                break;
            }
            case "btn_matching": {
                if (this.cache.get(TERM_WORD_COMP_TASK) != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6b63\u5728\u8fdb\u884c\u7684\u672f\u8bed\u91cd\u547d\u540d\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TermWordPresetListPlugin_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (termIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"IntlTermWordPlugin_41", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.asyncExtractTermWordComp(termIds);
                break;
            }
            case "btn_replace": {
                this.asyncReplaceTerms(termIds, selectCompIds);
                break;
            }
            case "btn_revert": {
                List<Long> compIds = this.validReplaceOrRevertTerms(termIds, selectCompIds, true);
                if (compIds == null || compIds.isEmpty()) break;
                this.getPageCache().put("compIds", SerializationUtils.toJsonString(compIds));
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_revert", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u5c06\u4f1a\u6e05\u9664\u65b0\u540d\u79f0\u5e76\u6062\u590d\u81f3\u51fa\u5382\u540d\u79f0\uff0c\u786e\u5b9a\u6062\u590d\uff1f", (String)"IntlTermWordPlugin_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), selectCompIds.size()), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
            case "btn_preset": {
                ListShowParameter para = new ListShowParameter();
                para.setBillFormId("cts_termword_preset");
                para.setFormId("bos_list");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)para);
                break;
            }
            case "btn_refresh": {
                billList.refresh();
                billList.clearSelection();
                billList1.clearData();
                this.getPageCache().remove(PKIDS);
                break;
            }
        }
    }

    private void deleteTermwordCheck(List<Long> termIds) {
        if (!PermitemVerifyUtil.hasRight(this.getView().getFormShowParameter().getAppId(), "cts_termword_list", "4715e1f1000000ac")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5220\u9664\u672f\u8bed\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IntlTermWordPlugin_8", (String)"bos-intlterm-formplugin", (Object[])new Object[]{2000}));
            return;
        }
        QFilter isSystyemFilter = new QFilter(IS_SYSTEM, "=", (Object)Character.valueOf('1'));
        Set systemTermwordIdSet = QueryServiceHelper.query((String)CTS_TERMWORD, (String)ID, (QFilter[])new QFilter[]{isSystyemFilter}).stream().map(dy -> dy.getLong(ID)).collect(Collectors.toSet());
        for (Long termwordId : termIds) {
            if (systemTermwordIdSet.contains(termwordId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"IntlTermWordPlugin_10", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                return;
            }
            String msg = ResManager.loadKDString((String)"\u672f\u8bed\u8bcd\u6761\u5df2\u66ff\u6362\u6216\u66fe\u88ab\u66ff\u6362\u8fc7\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"IntlTermWordPlugin_11", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
            if (this.hasTermwordLog(termwordId)) {
                this.getView().showTipNotification(msg);
                return;
            }
            QFilter qFilter = new QFilter(WORDID, "=", (Object)termwordId).and(WORDSTATUS, "in", (Object)new String[]{"2", "3", "4"}).and(ENABLE, "=", (Object)Character.valueOf('1'));
            if (!QueryServiceHelper.exists((String)CTS_TERMWORDCOMP, (QFilter[])qFilter.toArray())) continue;
            this.getView().showTipNotification(msg);
            return;
        }
        StringJoiner joiner = new StringJoiner(",");
        termIds.forEach(id -> joiner.add(id.toString()));
        String deleteTermwordIds = joiner.toString();
        ConfirmCallBackListener deleteConfirmCallBack = new ConfirmCallBackListener("delete", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u672f\u8bed\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\uff1f", (String)"IntlTermWordPlugin_13", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, deleteConfirmCallBack, new HashMap(), deleteTermwordIds);
    }

    private void deleteTermword(List<Long> termwordIds) {
        try (TXHandle h = TX.required();){
            try {
                QFilter wordIdFilter = new QFilter(WORDID, "in", termwordIds);
                MainEntityType termwordEntityType = EntityMetadataCache.getDataEntityType((String)CTS_TERMWORD);
                DeleteServiceHelper.delete((IDataEntityType)termwordEntityType, (Object[])termwordIds.toArray());
                String[] compTypeArray = new String[]{AppWordTypeEnum.ENTITY.name(), AppWordTypeEnum.FORM.name(), AppWordTypeEnum.MENU.name()};
                QFilter compFilter = new QFilter(CATEGORY, "in", (Object)compTypeArray);
                DeleteServiceHelper.delete((String)CTS_TERMWORDCOMP, (QFilter[])new QFilter[]{compFilter, wordIdFilter});
                QFilter promptFilter = new QFilter(CATEGORY, "=", (Object)AppWordTypeEnum.PROMPT.name());
                DeleteServiceHelper.delete((String)CTS_TERM_PROMPTWORD, (QFilter[])new QFilter[]{promptFilter, wordIdFilter});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"IntlTermWordPlugin_14", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
        billList.clearSelection();
        BillList billList1 = (BillList)this.getView().getControl("billlistap1");
        billList1.clearData();
        this.getPageCache().remove(PKIDS);
    }

    private boolean hasTermwordLog(Long termwordId) {
        QFilter termwordFilter = new QFilter(WORDID, "=", (Object)termwordId);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(String.valueOf(TermWordLogTypeEnum.REPLACE.getCode()));
        typeList.add(String.valueOf(TermWordLogTypeEnum.REVERT.getCode()));
        QFilter typeFilter = new QFilter("type", "in", typeList);
        return QueryServiceHelper.exists((String)"cts_termwordlog", (QFilter[])new QFilter[]{termwordFilter, typeFilter});
    }

    private void importAdd() {
        this.getView().invokeOperation("importdata");
    }

    private void showCheckLogPage(List<Long> termIds, List<Long> compIds) {
        if (!PermitemVerifyUtil.hasRight(this.getView().getFormShowParameter().getAppId(), "cts_termword_list", "1=XP6K8S19OJ")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u65e5\u5fd7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IntlTermWordPlugin_15", (String)"bos-intlterm-formplugin", (Object[])new Object[]{2000}));
            return;
        }
        ListShowParameter logListShowParameter = new ListShowParameter();
        logListShowParameter.setBillFormId("cts_termwordlog");
        logListShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        logListShowParameter.setCustomParam("selectedTermwordIdList", termIds);
        this.getView().showForm((FormShowParameter)logListShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        boolean result = MessageBoxResult.Yes.equals((Object)evt.getResult());
        switch (evt.getCallBackId()) {
            case "btn_revert": {
                if (!result) break;
                this.asyncRevertTermWord();
                break;
            }
            case "delete": {
                if (!result) break;
                String deleteTermwordIds = evt.getCustomVaule();
                List<Long> termwordIds = Arrays.stream(deleteTermwordIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
                this.deleteTermword(termwordIds);
                break;
            }
            case "btn_fill": {
                String fillTermIds = evt.getCustomVaule();
                if (result) {
                    this.fillTerm(fillTermIds, Boolean.TRUE);
                    break;
                }
                if (!MessageBoxResult.No.equals((Object)evt.getResult())) break;
                this.fillTerm(fillTermIds, Boolean.FALSE);
                break;
            }
        }
    }

    private void fillTerm(String fillTermIds, Boolean isYes) {
        List fillTermIdList = Arrays.stream(fillTermIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        String lanId = this.getPageCache().get(LANG_ID) == null ? "328738425610159104" : this.getPageCache().get(LANG_ID);
        QFilter qFilter = new QFilter(ID, "in", fillTermIdList).and(LANID, "=", (Object)Long.parseLong(lanId)).and(TERMWORDCUST, "!=", (Object)"");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)CTS_TERMWORD, (String)"id, termword, termwordcust, appid, lanid,wordstatus", (QFilter[])qFilter.toArray());
        List termIds = Arrays.stream(objects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter qFilter1 = new QFilter(WORDID, "in", termIds).and(LANID, "=", (Object)Long.parseLong(lanId)).and(WORDSTATUS, "not in", Arrays.asList("2", "3", "4"));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)CTS_TERMWORDCOMP, (String)"id, wordid, wordcomp, wordcompcust, wordstatus", (QFilter[])qFilter1.toArray());
        Map<Object, List<DynamicObject>> map = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(v -> v.getDynamicObject(WORDID).getPkValue()));
        String partialMapString = this.getPageCache().get("partial_replaced_id");
        Map partialMap = partialMapString == null ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)partialMapString, HashMap.class);
        HashSet termIDs = new HashSet();
        ArrayList comps = new ArrayList();
        Arrays.stream(objects).forEach(term -> {
            String status = term.getString(WORDSTATUS);
            String termWord = term.getString(TERMWORD);
            String termWordCust = term.getString(TERMWORDCUST);
            List oldComps = (List)map.get(term.getPkValue());
            if (oldComps != null) {
                oldComps.forEach(dynamicObject -> {
                    String wordCompCust = dynamicObject.getString(WORDCOMPCUST);
                    String wordcompcust = (String)partialMap.get(dynamicObject.getPkValue());
                    if (wordcompcust != null) {
                        dynamicObject.set(WORDCOMPCUST, (Object)wordcompcust);
                        dynamicObject.set(WORDSTATUS, (Object)TermStatusEnum.PENDING_REPLACE.getCode());
                        comps.add(dynamicObject);
                        if (!Arrays.asList("2", "3", "4").contains(status)) {
                            termIDs.add(term.getPkValue());
                        }
                    } else if (isYes.booleanValue()) {
                        String wordComp = dynamicObject.getString(WORDCOMP);
                        dynamicObject.set(WORDCOMPCUST, (Object)wordComp.replace(termWord, termWordCust));
                        dynamicObject.set(WORDSTATUS, (Object)TermStatusEnum.PENDING_REPLACE.getCode());
                        comps.add(dynamicObject);
                        if (!Arrays.asList("2", "3", "4").contains(status)) {
                            termIDs.add(term.getPkValue());
                        }
                    } else if (StringUtils.isEmpty((CharSequence)wordCompCust)) {
                        String wordComp = dynamicObject.getString(WORDCOMP);
                        dynamicObject.set(WORDCOMPCUST, (Object)wordComp.replace(termWord, termWordCust));
                        dynamicObject.set(WORDSTATUS, (Object)TermStatusEnum.PENDING_REPLACE.getCode());
                        comps.add(dynamicObject);
                        if (!Arrays.asList("2", "3", "4").contains(status)) {
                            termIDs.add(term.getPkValue());
                        }
                    }
                });
            }
        });
        if (!comps.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])comps.toArray(new DynamicObject[0]));
            TermReplaceHelper.refreshTermWordStatus(termIDs.toArray());
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        BillList billList1 = (BillList)this.getView().getControl("billlistap1");
        billList.refresh();
        billList1.refresh();
    }

    private void asyncRevertTermWord() {
        String lanId = this.getPageCache().get(LANG_ID) == null ? "328738425610159104" : this.getPageCache().get(LANG_ID);
        String lanNum = BaseDataUtil.getLangNumByLanId(lanId);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        Set selectTermWordIds = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        String compIdsJson = this.getPageCache().get("compIds");
        List compIds = SerializationUtils.fromJsonStringToList((String)compIdsJson, Long.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("selectTermWordIds", selectTermWordIds);
        params.put("compIds", compIds);
        params.put("lanNum", lanNum);
        String taskClassName = "kd.bos.formplugin.task.RevertTermWordCompTask";
        JobFormInfoHelper.buildJobFormInfo(ResManager.loadKDString((String)"\u6062\u590d\u672f\u8bed\u8bcd\u6761", (String)"IntlTermWordPlugin_37", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), taskClassName, new CloseCallBack(this.getPluginName(), TASK_CLOSE_CALL_BACK), this.getView(), params);
    }

    public void showProgressForm(String key) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cts_importprogress");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "listRefresh"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", key);
        map.put("title", ResManager.loadKDString((String)"1_\u672f\u8bed\u5bfc\u5165\u8fdb\u5ea6", (String)"IntlTermWordPlugin_20", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        map.put("className", ((Object)((Object)this)).getClass().getName());
        parameter.setCustomParams(map);
        this.getView().showForm(parameter);
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter(ENABLE, "=", (Object)Character.valueOf('1')));
        super.setFilter(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            BillList billList1 = (BillList)this.getControl("billlistap1");
            billList1.clearData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        if (CUSTOM_ACTION_ID.equals(event.getActionId())) {
            this.getView().updateView("billlistap", 0);
        }
        if ("import".equals(event.getActionId()) && (returnData = event.getReturnData()) != null) {
            this.showProgressForm(this.importCTSTermwordProcessFlag);
        }
        if ("listRefresh".equals(event.getActionId())) {
            ((BillList)this.getView().getControl("billlistap")).refresh();
        }
        if (TASK_CLOSE_CALL_BACK.equals(event.getActionId())) {
            Map<String, Object> customData = JobFormInfoHelper.getFeedBackCustomData(event);
            if (!customData.isEmpty() && "false".equals(customData.get("success"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5f02\u5e38:%s\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"IntlTermWordPlugin_40", (String)"bos-intlterm-formplugin", (Object[])new Object[]{customData.get("error")}));
            }
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow selectedRowInfo = billList.getCurrentSelectedRowInfo();
        if (TERMWORD.equals(args.getHyperLinkClickEvent().getFieldName())) {
            String value;
            args.setCancel(true);
            String appId = this.getView().getFormShowParameter().getAppId();
            if (!PermitemVerifyUtil.hasRight(appId, "cts_termword_list", "0AQ3YJ2LET+U")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7f16\u8f91\u6743\u9650", (String)"IntlTermWordPlugin_21", (String)"bos-intlterm-formplugin", (Object[])new Object[]{2000}));
                return;
            }
            String fid = selectedRowInfo.getPrimaryKeyValue().toString();
            if (fid.equals(value = (String)this.cache.get((Object)((Object)TermStatusEnum.REPLACING) + fid))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672f\u8bed\u6b63\u5728\u5e94\u7528\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6d88\u606f\u4e2d\u5fc3\u63d0\u793a\u3002", (String)"IntlTermWordPlugin_22", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            this.showTermWordForm(fid);
        }
    }

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        super.filterContainerSetFlat(args);
        args.setNewFilter(false);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Map<String, String> lanId2Name = BaseDataUtil.getEnabledLanguage();
        List<ComboItem> combos = lanId2Name.keySet().stream().map(s -> new ComboItem(new LocaleString((String)lanId2Name.get(s)), s)).collect(Collectors.toList());
        String langIdByLanNum = BaseDataUtil.getLangIdByLanNum(Lang.get().name());
        CommonFilterColumn languageColumn = BaseDataUtil.customCommonFilterColumn(LANID, ResManager.loadKDString((String)"\u8bed\u8a00\u79cd\u7c7b", (String)"IntlTermWordPlugin_23", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), combos, langIdByLanNum, true, false);
        this.getPageCache().put(LANG_ID, langIdByLanNum);
        if (!commonFilterColumns.contains(languageColumn)) {
            commonFilterColumns.add(languageColumn);
        }
        Map<String, LocaleString> appId2AppName = this.getTermWordApp();
        List<ComboItem> appCombos = appId2AppName.keySet().stream().map(localeString -> new ComboItem((LocaleString)appId2AppName.get(localeString), localeString)).collect(Collectors.toList());
        CommonFilterColumn applicationColumn = BaseDataUtil.customCommonFilterColumn(APPID, ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528", (String)"IntlTermWordPlugin_24", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), appCombos, "", false, true);
        if (!commonFilterColumns.contains(applicationColumn)) {
            commonFilterColumns.add(applicationColumn);
        }
        ArrayList<ComboItem> sysCombos = new ArrayList<ComboItem>();
        sysCombos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"IntlTermWordPlugin_31", (String)"bos-intlterm-formplugin", (Object[])new Object[0])), ""));
        sysCombos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"IntlTermWordPlugin_32", (String)"bos-intlterm-formplugin", (Object[])new Object[0])), "1"));
        sysCombos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"IntlTermWordPlugin_33", (String)"bos-intlterm-formplugin", (Object[])new Object[0])), "0"));
        CommonFilterColumn sysColumn = BaseDataUtil.customCommonFilterColumn(IS_SYSTEM, ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e", (String)"IntlTermWordPlugin_34", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), sysCombos, "", false, true);
        if (!commonFilterColumns.contains(sysColumn)) {
            commonFilterColumns.add(sysColumn);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getPageCache().remove(APPID);
        List qFilters = args.getSearchClickEvent().getFilterParameter().getQFilters();
        for (Object qFilter : qFilters) {
            String property = qFilter.getProperty();
            Object value = qFilter.getValue();
            List<String> values = new ArrayList<String>(10);
            if (value instanceof List) {
                values = (List)value;
            } else {
                values.add(value.toString());
            }
            this.getPageCache().put(property, SerializationUtils.toJsonString(values));
        }
        String lanId = "328738425610159104";
        for (QFilter qFilter : qFilters) {
            if (!"lanid.id".equals(qFilter.getProperty()) || qFilter.getValue() == null) continue;
            lanId = qFilter.getValue().toString();
        }
        this.getPageCache().put(LANG_ID, lanId);
        List fastFilterValues = args.getFastFilterValues();
        if (CollectionUtils.isEmpty((Collection)fastFilterValues)) {
            this.getPageCache().remove(FIELD_NAME);
            this.getPageCache().remove(VALUE);
        }
        for (Map map : fastFilterValues) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)map.get(FIELD_NAME)))) {
                this.getPageCache().put(FIELD_NAME, SerializationUtils.toJsonString(map.get(FIELD_NAME)));
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)map.get(VALUE)))) continue;
            this.getPageCache().put(VALUE, SerializationUtils.toJsonString(map.get(VALUE)));
        }
        ExcelUtil.filterInfoAddToCache(this.getPageCache(), args);
    }

    private void asyncExtractTermWordComp(List<Long> termIds) {
        String lanId = this.getPageCache().get(LANG_ID) == null ? "328738425610159104" : this.getPageCache().get(LANG_ID);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("termIds", termIds);
        params.put(LANG_ID, lanId);
        String taskClassName = "kd.bos.formplugin.task.ExtractTermWordCompTask";
        JobFormInfoHelper.buildJobFormInfo(ResManager.loadKDString((String)"\u68c0\u7d22\u5305\u542b\u672f\u8bed\u7684\u8bcd\u6761", (String)"IntlTermWordPlugin_38", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), taskClassName, new CloseCallBack(this.getPluginName(), TASK_CLOSE_CALL_BACK), this.getView(), params);
    }

    private void showTermWordForm(String fid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)fid, (String)CTS_TERMWORD, (String)" termword, termwordcust,cloudid, lanid, appid, wordstatus ");
        if (dynamicObject == null) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cts_termwordform");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CUSTOM_ACTION_ID));
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(ID, fid);
        map.put(TERMWORD, dynamicObject.get(TERMWORD));
        map.put(TERMWORDCUST, dynamicObject.get(TERMWORDCUST));
        map.put(WORDSTATUS, dynamicObject.get(WORDSTATUS));
        if (dynamicObject.get(APPID) != null) {
            map.put(APPID, ((DynamicObject)dynamicObject.get(APPID)).getPkValue());
        }
        if (dynamicObject.get(CLOUDID) != null) {
            map.put(CLOUDID, ((DynamicObject)dynamicObject.get(CLOUDID)).getPkValue());
        }
        if (dynamicObject.get(LANID) != null) {
            map.put(LANID, ((DynamicObject)dynamicObject.get(LANID)).getPkValue());
        }
        parameter.setCustomParams(map);
        parameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(parameter);
    }

    private List<Long> validReplaceOrRevertTerms(List<Long> termIds, List<Long> selectCompIds, boolean isRevert) {
        if (this.cache.get(TERM_WORD_COMP_TASK) != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6b63\u5728\u8fdb\u884c\u7684\u672f\u8bed\u91cd\u547d\u540d\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TermWordPresetListPlugin_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (termIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"IntlTermWordPlugin_41", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (selectCompIds.isEmpty()) {
            if (isRevert) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6062\u590d\u7684\u8bcd\u6761\u3002", (String)"IntlTermWordPlugin_30", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u66ff\u6362\u7684\u8bcd\u6761\u3002", (String)"IntlTermWordPlugin_29", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            return null;
        }
        ArrayList<Long> compIds = new ArrayList<Long>(10);
        for (Long pkId : selectCompIds) {
            List compList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(((Object)pkId).toString()), TermWordCompEntity.class);
            int wordStatus = isRevert ? TermStatusEnum.REPLACED.getCode() : TermStatusEnum.PENDING_REPLACE.getCode();
            boolean noneMatch = compList.stream().noneMatch(e -> String.valueOf(wordStatus).equals(e.getWordstatus()));
            if (noneMatch) {
                if (isRevert) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5df2\u66ff\u6362\u201d\u6216\u201c\u90e8\u5206\u66ff\u6362\u201d\u72b6\u6001\u7684\u8bcd\u6761\u3002", (String)"IntlTermWordPlugin_19", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f85\u66ff\u6362\u6216\u90e8\u5206\u66ff\u6362\u201d\u72b6\u6001\u7684\u8bcd\u6761\u3002", (String)"IntlTermWordPlugin_27", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                }
                return null;
            }
            compIds.addAll(compList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getWordcompcust()) && String.valueOf(wordStatus).equals(e.getWordstatus())).map(TermWordCompEntity::getId).collect(Collectors.toList()));
        }
        this.getPageCache().remove(PKIDS);
        return compIds;
    }

    private void asyncReplaceTerms(List<Long> termIds, List<Long> selectCompIds) {
        List<Long> compIds = this.validReplaceOrRevertTerms(termIds, selectCompIds, false);
        if (compIds == null || compIds.isEmpty()) {
            return;
        }
        String lanId = this.getPageCache().get(LANG_ID) == null ? "328738425610159104" : this.getPageCache().get(LANG_ID);
        String lanNumber = BaseDataUtil.getLangNumByLanId(lanId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lanNumber", lanNumber);
        params.put("termIds", termIds);
        params.put("compIds", compIds);
        String taskClassName = "kd.bos.formplugin.task.ReplaceTermWordCompTask";
        JobFormInfoHelper.buildJobFormInfo(ResManager.loadKDString((String)"\u66ff\u6362\u672f\u8bed\u8bcd\u6761", (String)"IntlTermWordPlugin_39", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), taskClassName, new CloseCallBack((IFormPlugin)this, TASK_CLOSE_CALL_BACK), this.getView(), params);
    }

    private Map<String, LocaleString> getTermWordApp() {
        String sql = "SELECT fappid FROM t_cts_termword WHERE fenable = '1' GROUP BY fappid";
        HashMap<String, LocaleString> appId2AppName = new HashMap<String, LocaleString>(16);
        ArrayList appIds = new ArrayList();
        DB.query((DBRoute)DBRoute.basedata, (String)sql, rs -> {
            while (rs.next()) {
                appIds.add(rs.getString(1));
            }
            return appIds;
        });
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"name", (QFilter[])new QFilter[]{new QFilter(ID, "in", appIds)});
        for (Map.Entry entry : map.entrySet()) {
            appId2AppName.put(entry.getKey().toString(), new LocaleString(((DynamicObject)entry.getValue()).getString("name")));
        }
        return appId2AppName;
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        if (pageData != null) {
            pageData.forEach(row -> {
                String wordStatus = row.getString(WORDSTATUS);
                if (String.valueOf(TermStatusEnum.DEFAULT.getCode()).equals(wordStatus)) {
                    row.set(WORDSTATUS, (Object)"");
                }
            });
        }
        super.beforePackageData(e);
    }
}

