/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class IntlTermWordStandardImportPlugin
extends BatchImportPlugin {
    private static final String APP_TYPE = "0";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String IMPORT_PROP = "importprop";
    private static final String LAN_ID = "lanid";
    private static final String APP_ID = "appid";
    private static final String CLOUD_ID = "cloudid";
    private static final String BIZ_CLOUD = "bizcloud";
    private static final String TERMWORD = "termword";
    private static final String BOS_INTLTERM_FORMPLUGIN = "bos-intlterm-formplugin";
    private static final String TERMWORDCUST = "termwordcust";
    private static final String WORDSTATUS = "wordstatus";
    private static final String ID = "id";

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add("radiofield1");
        lockKeys.add("radiofield2");
        return lockKeys;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map<String, String> lanName2Lan = this.getLan();
        Map<String, String> name2cloudNumber = this.getCloud(rowdatas);
        HashSet<String> cloudNumberSet = new HashSet<String>(name2cloudNumber.values());
        Map<String, Map<String, String>> cloudName2AppName2AppNumber = this.getApp(cloudNumberSet);
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData rowData = iterator.next();
            JSONObject rowJson = rowData.getData();
            if (rowJson == null) continue;
            String termWordCust = rowJson.getString(TERMWORDCUST);
            String termWord = rowJson.getString(TERMWORD);
            if (this.isOldNameEqualsNewName(termWord, termWordCust)) {
                logger.log(Integer.valueOf(rowData.getStartIndex()), ResManager.loadKDString((String)"\u65b0\u540d\u79f0\u4e0e\u539f\u540d\u79f0\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordStandardImportPlugin_0", (String)BOS_INTLTERM_FORMPLUGIN, (Object[])new Object[0])).fail();
                iterator.remove();
                continue;
            }
            JSONObject cloudId = rowJson.getJSONObject(CLOUD_ID);
            String cloudName = Optional.ofNullable(cloudId).map(v -> v.getString(NAME)).orElse(null);
            String cloudNumber = this.ifAbsentByNameComputed(Optional.ofNullable(cloudId).orElseGet(JSONObject::new), name2cloudNumber.get(cloudName));
            if (cloudNumber == null) {
                logger.log(Integer.valueOf(rowData.getStartIndex()), ResManager.loadKDString((String)"\u6240\u5c5e\u4e91\u4e0d\u5b58\u5728\u3002", (String)"IntlTermWordStandardImportPlugin_1", (String)BOS_INTLTERM_FORMPLUGIN, (Object[])new Object[0])).fail();
                iterator.remove();
                continue;
            }
            this.handleCloudIdField(cloudId, cloudNumber);
            JSONObject appId = rowJson.getJSONObject(APP_ID);
            if (appId != null) {
                String appNumber = this.ifAbsentByNameComputed(appId, Optional.of(cloudName2AppName2AppNumber).map(item -> (Map)item.get(cloudName)).map(appName2AppNumber -> (String)appName2AppNumber.get(appId.getString(NAME))).orElse(null));
                if (appNumber != null) {
                    this.handleAppIdField(appId, appNumber);
                } else {
                    logger.log(Integer.valueOf(rowData.getStartIndex()), ResManager.loadKDString((String)"\u672a\u5728\u201c\u6240\u5c5e\u4e91\u201d\u4e2d\u627e\u5230\u201c\u6240\u5c5e\u5e94\u7528\u201d\u3002", (String)"IntlTermWordStandardImportPlugin_2", (String)BOS_INTLTERM_FORMPLUGIN, (Object[])new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
            }
            JSONObject lanId = rowJson.getJSONObject(LAN_ID);
            String lanName = Optional.ofNullable(lanId).map(lanIdItem -> lanIdItem.getString(NAME)).orElse(null);
            String lanNumber = this.ifAbsentByNameComputed(Optional.ofNullable(lanId).orElseGet(JSONObject::new), Optional.ofNullable(lanName2Lan).map(item -> (String)item.get(lanName)).orElse(null));
            if (lanNumber != null) {
                this.handleLanIdField(lanId, lanNumber);
                continue;
            }
            logger.log(Integer.valueOf(rowData.getStartIndex()), ResManager.loadKDString((String)"\u8bed\u8a00\u79cd\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"IntlTermWordStandardImportPlugin_3", (String)BOS_INTLTERM_FORMPLUGIN, (Object[])new Object[0])).fail();
            iterator.remove();
        }
        ApiResult apiResult = super.save(rowdatas, logger);
        this.updateStatus(apiResult);
        return apiResult;
    }

    private String ifAbsentByNameComputed(JSONObject jsonObject, String cloudNumber) {
        String number = jsonObject.getString(NUMBER);
        if (StringUtils.isEmpty((CharSequence)number)) {
            return cloudNumber;
        }
        return number;
    }

    private void updateStatus(ApiResult apiResult) {
        if (apiResult != null && null != apiResult.getData()) {
            List resultDataList = (List)apiResult.getData();
            QFilter qFilter = new QFilter(ID, "in", (Object)resultDataList.stream().filter(map -> map.get("success") instanceof Boolean && (Boolean)map.get("success") != false).map(map -> map.get(ID)).distinct().toArray());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"cts_termword", (String)"termwordcust,wordstatus", (QFilter[])qFilter.toArray());
            Arrays.stream(dynamicObjects).forEach(v -> v.set(WORDSTATUS, (Object)APP_TYPE));
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    private void handleCloudIdField(JSONObject cloudId, String number) {
        cloudId.put(IMPORT_PROP, (Object)NUMBER);
        cloudId.put(NUMBER, (Object)number);
    }

    private void handleAppIdField(JSONObject appId, String number) {
        appId.put(IMPORT_PROP, (Object)NUMBER);
        appId.put(NUMBER, (Object)number);
    }

    private void handleLanIdField(JSONObject lanId, String number) {
        lanId.put(IMPORT_PROP, (Object)NUMBER);
        lanId.put(NUMBER, (Object)number);
    }

    private boolean isOldNameEqualsNewName(String oldName, String newName) {
        return StringUtils.equals((CharSequence)oldName, (CharSequence)newName);
    }

    private Map<String, Map<String, String>> getApp(Set<String> cloudNumberSet) {
        QFilter cloudNumberFilter = new QFilter("bizcloud.number", "in", (Object)cloudNumberSet.toArray());
        cloudNumberFilter.and("type", "=", (Object)APP_TYPE);
        Map appMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"number,name,type,bizcloud.name", (QFilter[])cloudNumberFilter.toArray());
        Map<String, List<DynamicObject>> cloudName2App = appMap.values().stream().collect(Collectors.groupingBy(app -> app.getString("bizcloud.name")));
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        cloudName2App.forEach((cloudName, appList) -> {
            HashMap appName2AppNubmer = new HashMap();
            appList.forEach(item -> {
                String number = item.getString(NUMBER);
                String name = item.getString(NAME);
                appName2AppNubmer.put(name, number);
            });
            result.put((String)cloudName, appName2AppNubmer);
        });
        return result;
    }

    private Map<String, String> getCloud(List<ImportBillData> rowdatas) {
        QFilter cloudNameFilter = new QFilter(NAME, "in", (Object)rowdatas.stream().map(row -> row.getData().getJSONObject(CLOUD_ID) != null ? row.getData().getJSONObject(CLOUD_ID).getString(NAME) : null).distinct().toArray());
        Map cloudMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"number,name", (QFilter[])cloudNameFilter.toArray());
        HashMap<String, String> name2CloudNumber = new HashMap<String, String>();
        cloudMap.values().forEach(item -> {
            String number = item.getString(NUMBER);
            String name = item.getString(NAME);
            name2CloudNumber.put(name, number);
        });
        return name2CloudNumber;
    }

    private Map<String, String> getLan() {
        String sql = "select fname,fnumber from t_int_language where fenable = '1'";
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, rs -> {
            HashMap<String, String> name2Number = new HashMap<String, String>(16);
            while (rs.next()) {
                String name = rs.getString("fname");
                String number = rs.getString("fnumber");
                name2Number.put(name, number);
            }
            return name2Number;
        });
    }
}

