/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.enums.AppWordTypeEnum;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.inte.api.EnabledLang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.MetadataUtil;
import kd.bos.util.StringUtils;

public class IntlWordEntryModifyPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String FORMID = "formId";
    private static final String CTS_WORDENTRY = "cts_wordentry";
    private static final String BILL_NUMBER = "billnumber";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String FORM_ITEM_TYPE = "formitemtype";
    private static final String SHOW_NAME = "showname";
    private static final String NEW_NAME = "newname";
    private static final String UUID = "uuid";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String FIELD_AP = "FieldAp";
    private static final String ENTRY_FIELD_AP = "EntryFieldAp";
    private static final String LIST_COLUMN_AP = "ListColumnAp";
    private static final String CARD_LIST_COLUMN_AP = "CardListColumnAp";
    private static final String OTHERS = "Others";
    private static final String URL = "url";
    private static final String OPEN_STYLE = "openStyle";
    private static final String OPEN_URL = "openUrl";
    private static final String ENABLE = "enable";
    private static final String CTS_WORD_ITEMTYPE = "cts_word_itemtype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        MetadataUtil.extractMetadata(formId);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        QFilter billFilter = new QFilter(BILL_NUMBER, "=", (Object)formId);
        DynamicObject[] dyArray = BusinessDataServiceHelper.load((String)CTS_WORDENTRY, (String)"id,name,newname,formitemtype", (QFilter[])new QFilter[]{billFilter, enableFilter});
        if (dyArray.length == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, dyArray.length);
        String fieldApName = this.getItemTypeNameByNumber(FIELD_AP);
        String entryFieldApName = this.getItemTypeNameByNumber(ENTRY_FIELD_AP);
        String listColumnApName = this.getItemTypeNameByNumber(LIST_COLUMN_AP);
        String cardListColumnApName = this.getItemTypeNameByNumber(CARD_LIST_COLUMN_AP);
        Map<String, List<DynamicObject>> dyGroupMap = Arrays.stream(dyArray).collect(Collectors.groupingBy(dy -> {
            String name = dy.getDynamicObject(FORM_ITEM_TYPE).getString(NAME);
            if (!(fieldApName.equals(name) || entryFieldApName.equals(name) || listColumnApName.equals(name) || cardListColumnApName.equals(name))) {
                return OTHERS;
            }
            return name;
        }));
        boolean isList = false;
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView) {
            isList = true;
        }
        ArrayList dyList = new ArrayList();
        if (isList) {
            if (dyGroupMap.get(listColumnApName) != null) {
                dyList.addAll(dyGroupMap.get(listColumnApName));
            }
            if (dyGroupMap.get(cardListColumnApName) != null) {
                dyList.addAll(dyGroupMap.get(cardListColumnApName));
            }
            if (dyGroupMap.get(fieldApName) != null) {
                dyList.addAll(dyGroupMap.get(fieldApName));
            }
            if (dyGroupMap.get(entryFieldApName) != null) {
                dyList.addAll(dyGroupMap.get(entryFieldApName));
            }
            if (dyGroupMap.get(OTHERS) != null) {
                dyList.addAll(dyGroupMap.get(OTHERS));
            }
        } else {
            if (dyGroupMap.get(fieldApName) != null) {
                dyList.addAll(dyGroupMap.get(fieldApName));
            }
            if (dyGroupMap.get(entryFieldApName) != null) {
                dyList.addAll(dyGroupMap.get(entryFieldApName));
            }
            if (dyGroupMap.get(listColumnApName) != null) {
                dyList.addAll(dyGroupMap.get(listColumnApName));
            }
            if (dyGroupMap.get(cardListColumnApName) != null) {
                dyList.addAll(dyGroupMap.get(cardListColumnApName));
            }
            if (dyGroupMap.get(OTHERS) != null) {
                dyList.addAll(dyGroupMap.get(OTHERS));
            }
        }
        for (int i = 0; i < dyList.size(); ++i) {
            DynamicObject dy2 = (DynamicObject)dyList.get(i);
            this.getModel().setValue(NAME, (Object)dy2.getLocaleString(NAME), i);
            this.getModel().setValue(TYPE, (Object)dy2.getDynamicObject(FORM_ITEM_TYPE), i);
            this.getModel().setValue(SHOW_NAME, (Object)dy2.getLocaleString(NEW_NAME), i);
            this.getModel().setValue(UUID, dy2.getPkValue(), i);
        }
    }

    private String getItemTypeNameByNumber(String number) {
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)CTS_WORD_ITEMTYPE, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
        if (dy != null) {
            return dy.getString(NAME);
        }
        return StringUtils.getEmpty();
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (((Control)evt.getSource()).getKey().equals(BTN_OK)) {
            DynamicObject[] dyArray;
            DynamicObjectCollection coll = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            List idList = coll.stream().map(dy -> dy.getString(UUID)).collect(Collectors.toList());
            HashMap map = new HashMap();
            coll.forEach(dy -> map.put(dy.getString(UUID), dy));
            for (DynamicObject dy2 : dyArray = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CTS_WORDENTRY))) {
                DynamicObject dyInfo = (DynamicObject)map.get(dy2.getString(ID));
                if (dyInfo == null) continue;
                dy2.set(NEW_NAME, (Object)dyInfo.getLocaleString(SHOW_NAME));
            }
            SaveServiceHelper.save((DynamicObject[])dyArray);
            QFilter idFilter = new QFilter(ID, "in", idList);
            QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
            List langList = InteServiceHelper.getMultiLangEnabledLang();
            DynamicObject[] dyArray1 = BusinessDataServiceHelper.load((String)CTS_WORDENTRY, (String)"id,newname", (QFilter[])new QFilter[]{idFilter, enableFilter});
            String id = MetadataDao.getIdByNumber((String)((String)this.getView().getFormShowParameter().getCustomParam(FORMID)), (MetaCategory)MetaCategory.Form);
            for (EnabledLang lang : langList) {
                HashMap<String, String> entryMap = new HashMap<String, String>();
                for (DynamicObject dy3 : dyArray1) {
                    String name = (String)dy3.getLocaleString(NAME).get((Object)lang.number);
                    String newname = (String)dy3.getLocaleString(NEW_NAME).get((Object)lang.number);
                    if (name == null || name.equals(newname)) continue;
                    entryMap.put(dy3.getString(ID).split("\\.", 2)[1], newname);
                }
                if (entryMap.size() <= 0) continue;
                TermReplaceHelper.applyTerms(AppWordTypeEnum.FORM, null, Collections.singletonMap(id, entryMap), lang.number, null);
            }
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("reload", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002\u662f\u5426\u5237\u65b0\u5f53\u524d\u9875\u9762\uff1f", (String)"IntlWordEntryModifyPlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, String> mpURL = new HashMap<String, String>(2);
            RequestContext context = RequestContext.get();
            mpURL.put(URL, context.getClientFullContextPath());
            mpURL.put(OPEN_STYLE, "0");
            proxy.addAction(OPEN_URL, mpURL);
        } else if (MessageBoxResult.No == messageBoxClosedEvent.getResult()) {
            this.getView().close();
        }
    }
}

