/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.enums.AppWordTypeEnum;
import kd.bos.enums.TermStatusEnum;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.helper.CacheHelper;
import kd.bos.helper.JobFormInfoHelper;
import kd.bos.helper.PromptWordReplaceHelper;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.BaseDataUtil;

@Deprecated
public class PromptWordPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(PromptWordPlugin.class);
    private final DistributeSessionlessCache cache = CacheHelper.getIntlTermCache();
    private static final String PROMPT_PROGRESS = "promptProgress";
    private static final String PROMPT_WORD_TASK = "promptWordTask";
    private static final String REVERT_PROMPT_WORD = "revertPromptWord";
    private static final String EXTRACT_PROMPT_WORD = "extractPromptWord";
    private static final String LIST_REFRESH = "listRefresh";
    private static final String TASK_CLOSE_CALL_BACK = "taskCloseBack";
    private static final String BTN_EXTRACT = "btn_extract";
    private static final String BTN_REPLACE = "btn_replace";
    private static final String BTN_REVERT = "btn_revert";
    private static final String BTN_FILL = "btn_fill";
    private static final String APPID = "appid";
    private static final String WORD_COMP = "wordcomp";
    private static final String LAN_ID = "lanid";
    private static final String TERM_WORD = "termword";
    private static final String WORD_STATUS = "wordstatus";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListSelectedRow row = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        if ("fseq".equals(args.getFieldName())) {
            args.setCancel(true);
            this.showCompForm(row.getPrimaryKeyValue());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        switch (e.getActionId()) {
            case "listRefresh": {
                billList.refresh();
                break;
            }
            case "extractPromptWord": {
                Set appIds = (Set)e.getReturnData();
                if (appIds == null || appIds.isEmpty()) break;
                this.extractPromptWord(appIds);
                break;
            }
            case "taskCloseBack": {
                Map<String, Object> customData = JobFormInfoHelper.getFeedBackCustomData(e);
                if (!customData.isEmpty() && "false".equals(customData.get("success"))) {
                    this.getView().showErrMessage((String)customData.get("errMsg"), ResManager.loadKDString((String)"\u63d0\u793a\u8bed\u91cd\u547d\u540d", (String)"PromptWordPlugin_18", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                }
                billList.refresh();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (REVERT_PROMPT_WORD.equals(event.getCallBackId()) && MessageBoxResult.Yes == event.getResult()) {
            List<Object> pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            List<TermWordCompEntity> entityList = this.getPromptWordEntityList(pkIds);
            this.executeReplace(true, entityList);
        }
    }

    private void extractPromptWord(Set<String> appIds) {
        String lanId = this.getPageCache().get(LAN_ID) != null ? this.getPageCache().get(LAN_ID) : "328738425610159104";
        DynamicObjectCollection promptProjects = QueryServiceHelper.query((String)"cts_termproject", (String)"id, number, appid", (QFilter[])new QFilter[]{new QFilter(APPID, "in", appIds)});
        if (promptProjects == null || promptProjects.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u9884\u7f6e\u5e94\u7528\u4e0b\u5de5\u7a0b\u4fe1\u606f\u3002", (String)"PromptWordPlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showProgressForm();
        this.extractPromptWord(lanId, promptProjects, appIds);
    }

    private void extractPromptWord(String lanId, DynamicObjectCollection promptProjects, Set<String> appIds) {
        ThreadPools.executeOnce((String)EXTRACT_PROMPT_WORD, () -> {
            try (TXHandle tx = TX.required();){
                try {
                    this.extractPromptWord(promptProjects, lanId, appIds);
                }
                catch (Exception e) {
                    this.cache.remove(PROMPT_PROGRESS);
                    logger.error("extractPromptWord failed, e: ", (Throwable)e);
                    tx.markRollback();
                    throw e;
                }
            }
        });
    }

    private void extractPromptWord(DynamicObjectCollection promptProjects, String lanId, Set<String> appIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(LAN_ID, "=", (Object)Long.parseLong(lanId)));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cts_termword", (String)"id, termword, appid, cloudid", (QFilter[])qFilters.toArray(new QFilter[0]));
        String lanNum = BaseDataUtil.getLangNumByLanId(lanId);
        Map<String, String> cloudId2AppIds = BaseDataUtil.getCloudIdByAppIds(appIds);
        int count = promptProjects.size();
        for (int i = 0; i < count; ++i) {
            this.cache.put(PROMPT_PROGRESS, (Object)(i + 1 + "_" + count), 1000);
            String appId = ((DynamicObject)promptProjects.get(i)).getString(APPID);
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp");
            String appNumber = object != null ? object.getString("number") : "";
            String number = ((DynamicObject)promptProjects.get(i)).getString("number");
            for (DynamicObject termObject : load) {
                String s;
                DynamicObject appid = termObject.getDynamicObject(APPID);
                DynamicObject cloudid = termObject.getDynamicObject("cloudid");
                if (appid != null && !(s = appid.getPkValue().toString()).equals(appId) || cloudid != null && !(s = cloudid.getPkValue().toString()).equals(cloudId2AppIds.get(appId))) continue;
                String id = termObject.getString("id");
                String termWord = termObject.getString(TERM_WORD);
                Map promptWords = (Map)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"GetPromptWordService", (String)"getPromptWordByTerm", (Object[])new Object[]{number, termWord, lanNum});
                if (promptWords == null || promptWords.size() <= 0) continue;
                PromptWordReplaceHelper.savePromptWords(promptWords, id, lanId, number, appId);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new PromptWordProvider());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        List<Object> pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (evt.getItemKey()) {
            case "btn_extract": {
                if (this.cache.get(PROMPT_PROGRESS) != null) {
                    this.showProgressForm();
                    return;
                }
                this.showTreeForm();
                break;
            }
            case "btn_fill": {
                this.fillPromptWord(pkIds);
                break;
            }
            case "btn_replace": {
                if (this.cache.get(PROMPT_WORD_TASK) != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6b63\u5728\u8fdb\u884c\u7684\u63d0\u793a\u8bed\u91cd\u547d\u540d\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TermWordPresetListPlugin_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.applyPromptWordTerm(pkIds, false);
                break;
            }
            case "btn_revert": {
                if (this.cache.get(PROMPT_WORD_TASK) != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6b63\u5728\u8fdb\u884c\u7684\u63d0\u793a\u8bed\u91cd\u547d\u540d\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TermWordPresetListPlugin_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.applyPromptWordTerm(pkIds, true);
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String lanId = BaseDataUtil.getLangIdByLanNum(Lang.get().name());
        args.getFilterColumn("lanid.name").setDefaultValue(lanId);
        this.getPageCache().put(LAN_ID, lanId);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        if (null != args.getSearchClickEvent().getFilterValue("lanid.id")) {
            this.getPageCache().put(LAN_ID, args.getSearchClickEvent().getFilterValue("lanid.id").toString());
        }
    }

    private void fillPromptWord(List<Object> pkIds) {
        DynamicObject[] dynamicObjects;
        if (pkIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u586b\u5145\u7684\u6570\u636e\u3002", (String)"PromptWordPlugin_6", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        List<TermWordCompEntity> entityList = this.getPromptWordEntityList(pkIds);
        List mergePkIds = entityList.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getWordcompcust())).map(TermWordCompEntity::getId).collect(Collectors.toList());
        if (mergePkIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b0\u63d0\u793a\u8bed\u4e3a\u7a7a\u7684\u8bcd\u6761\u3002", (String)"PromptWordPlugin_19", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cts_term_promptword", (String)"id, wordid, wordcomp, wordcompcust, wordstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", mergePkIds)})) {
            String originalComp = dynamicObject.getString("wordid.termword");
            String newCompCust = dynamicObject.getString("wordid.termwordcust");
            if (!StringUtils.isNotBlank((CharSequence)newCompCust)) continue;
            dynamicObject.set("wordcompcust", (Object)dynamicObject.getString(WORD_COMP).replace(originalComp, newCompCust));
            dynamicObject.set(WORD_STATUS, (Object)TermStatusEnum.PENDING_REPLACE.getCode());
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u586b\u5145\u672f\u8bed\u6210\u529f\u3002", (String)"PromptWordPlugin_9", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void applyPromptWordTerm(List<Object> pkIds, boolean isRevert) {
        if (pkIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"PromptWordPlugin_20", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cts_termwordcomp", (String)"id, wordstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
        if (isRevert) {
            if (this.anyMatch(TermStatusEnum.REPLACED.getCode(), dynamicObjects)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5df2\u66ff\u6362\u201d\u72b6\u6001\u7684\u63d0\u793a\u8bed\u3002", (String)"PromptWordPlugin_11", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REVERT_PROMPT_WORD, (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u5c06\u4f1a\u6e05\u9664\u65b0\u540d\u79f0\u5e76\u6062\u590d\u81f3\u51fa\u5382\u540d\u79f0\uff0c\u786e\u5b9a\u6062\u590d\uff1f", (String)"PromptWordPlugin_12", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), pkIds.size()), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        if (this.anyMatch(TermStatusEnum.PENDING_REPLACE.getCode(), dynamicObjects)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f85\u66ff\u6362\u201d\u72b6\u6001\u7684\u63d0\u793a\u8bed\u3002", (String)"PromptWordPlugin_14", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<TermWordCompEntity> entityList = this.getPromptWordEntityList(pkIds);
        this.executeReplace(false, entityList);
    }

    private boolean anyMatch(int statusCode, DynamicObjectCollection dynamicObjects) {
        return dynamicObjects.stream().anyMatch(e -> statusCode != e.getInt(WORD_STATUS));
    }

    private void executeReplace(boolean isRevert, List<TermWordCompEntity> entityList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isRevert", isRevert);
        params.put("entityList", entityList);
        JobFormInfoHelper.buildJobFormInfo(ResManager.loadKDString((String)"\u63d0\u793a\u8bed\u91cd\u547d\u540d", (String)"PromptWordPlugin_18", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), "kd.bos.formplugin.task.ReplacePromptWordTask", new CloseCallBack(this.getPluginName(), TASK_CLOSE_CALL_BACK), this.getView(), params);
    }

    private List<TermWordCompEntity> getPromptWordEntityList(List<Object> pkIds) {
        ArrayList<TermWordCompEntity> entityList = new ArrayList<TermWordCompEntity>();
        for (Object pkId : pkIds) {
            String s = this.getPageCache().get(pkId.toString());
            if (s == null) continue;
            List objectList = SerializationUtils.fromJsonStringToList((String)s, TermWordCompEntity.class);
            entityList.addAll(objectList);
        }
        return entityList;
    }

    private void showCompForm(Object pkId) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("cts_termwordcomp_form");
        parameter.setPkId(pkId);
        parameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u63d0\u793a\u8bed", (String)"PromptWordPlugin_16", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LIST_REFRESH));
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("entityType", (Object)"cts_term_promptword");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showTreeForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cts_term_choosetree");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap map = new HashMap();
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXTRACT_PROMPT_WORD));
        parameter.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0\u63d0\u793a\u8bed\u8303\u56f4", (String)"PromptWordPlugin_17", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void showProgressForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cts_promptprogress");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LIST_REFRESH));
        this.getView().showForm(parameter);
    }

    class PromptWordProvider
    extends ListDataProvider {
        PromptWordProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            List qFilters = this.getQFilters();
            qFilters.add(new QFilter("category", "=", (Object)AppWordTypeEnum.PROMPT));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"cts_term_promptword", (String)"id, lanid, wordid, wordstatus, wordcomp, wordcompcust, key, category, appid, subjectid", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (dynamicObjects.length == 0) {
                return new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cts_term_promptword"), null);
            }
            qFilters.add(new QFilter("id", "in", this.groupPromptWordComps(dynamicObjects)));
            DynamicObjectCollection data = super.getData(start, limit);
            for (DynamicObject object : data) {
                if (TermStatusEnum.DEFAULT.getCode() != object.getInt(PromptWordPlugin.WORD_STATUS)) continue;
                object.set(PromptWordPlugin.WORD_STATUS, (Object)"");
            }
            return data;
        }

        private List<Object> groupPromptWordComps(DynamicObject[] data) {
            Map<String, List<DynamicObject>> app2Object = Arrays.stream(data).filter(e -> !StringUtils.isEmpty((CharSequence)e.getString(PromptWordPlugin.APPID))).collect(Collectors.groupingBy(e -> e.getString(PromptWordPlugin.APPID)));
            ArrayList<Object> ids = new ArrayList<Object>();
            for (Map.Entry<String, List<DynamicObject>> objectListEntry : app2Object.entrySet()) {
                List<DynamicObject> dynamicObjects = objectListEntry.getValue();
                Map<String, List<DynamicObject>> promptWord = dynamicObjects.stream().collect(Collectors.groupingBy(e -> e.getString(PromptWordPlugin.WORD_COMP)));
                for (Map.Entry<String, List<DynamicObject>> listEntry : promptWord.entrySet()) {
                    List<DynamicObject> entryValue = listEntry.getValue();
                    ids.add(entryValue.get(0).getPkValue());
                    ArrayList entityList = new ArrayList();
                    entryValue.forEach(v -> entityList.add(this.createPromptWordEntity((DynamicObject)v)));
                    PromptWordPlugin.this.getPageCache().put(entryValue.get(0).getPkValue().toString(), SerializationUtils.toJsonString(entityList));
                }
            }
            return ids;
        }

        private TermWordCompEntity createPromptWordEntity(DynamicObject dynamicObject) {
            TermWordCompEntity entity = new TermWordCompEntity();
            entity.setId(dynamicObject.getLong("id"));
            entity.setLanid(dynamicObject.getString("lanid.id"));
            entity.setAppid(dynamicObject.getString("appid.id"));
            entity.setWordcomp(dynamicObject.getString(PromptWordPlugin.WORD_COMP));
            entity.setWordid(dynamicObject.getLong("wordid.id"));
            entity.setWordcompcust(dynamicObject.getString("wordcompcust"));
            return entity;
        }
    }
}

