/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.enums.TermStatusEnum;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.helper.TermReplaceHelper;

public class TermWordCompFormPlugin
extends AbstractFormPlugin {
    private static final String OPERATE_KEY = "save";
    private static final String WORD_COMP_CUST = "wordcompcust";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!this.getModel().getDirty()) {
            args.setCancel(true);
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult().isSuccess() && OPERATE_KEY.equals(args.getOperateKey())) {
            Object pkId = args.getOperationResult().getSuccessPkIds().get(0);
            String wordCompCust = (String)this.getModel().getValue(WORD_COMP_CUST);
            String compList = this.getView().getParentView().getPageCache().get(pkId.toString());
            List objectList = SerializationUtils.fromJsonStringToList((String)compList, TermWordCompEntity.class);
            List<Long> collect = objectList.stream().map(TermWordCompEntity::getId).collect(Collectors.toList());
            TermReplaceHelper.updateTermWordComp(collect, TermStatusEnum.PENDING_REPLACE.getCode(), wordCompCust);
            TermReplaceHelper.updateTermWordStatus(((TermWordCompEntity)objectList.get(0)).getWordid(), TermStatusEnum.PENDING_REPLACE.getCode(), null);
            this.getView().close();
        }
    }
}

