/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.common.builder.FilterAndSortBuilder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.enums.TermWordLogTypeEnum;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TermWordLogListPlugin
extends AbstractListPlugin {
    private static final String ID = "id";
    private static final String CTS_TERMWORDLOG = "cts_termwordlog";
    private static final String CTS_TERMWORDAPPLYLOG = "cts_termwordapplylog";
    private static final String TERM_WORD_LOG_ID = "termwordlogid";
    private static final String TYPE = "type";
    private static final String WORD_ID = "wordid";
    private static final String TERM_WORD_COMP = "termwordcomp";
    private static final String SELECTED_TERMWORD_ID_LIST = "selectedTermwordIdList";
    private static final String TYPE_HYPERLINK = "typehyperlink";
    private static final String CTS_TERMWORD = "cts_termword";
    private static final List<String> typeList = new ArrayList<String>();

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long termWordLogId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        QFilter idFilter = new QFilter(ID, "=", (Object)termWordLogId);
        DynamicObject termWordLogDy = QueryServiceHelper.queryOne((String)CTS_TERMWORDLOG, (String)"id, type", (QFilter[])idFilter.toArray());
        int type = termWordLogDy.getInt(TYPE);
        if (TermWordLogTypeEnum.REPLACE.getCode() == type || TermWordLogTypeEnum.REVERT.getCode() == type) {
            ListShowParameter logListShowParameter = new ListShowParameter();
            logListShowParameter.setBillFormId(CTS_TERMWORDAPPLYLOG);
            logListShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("580px");
            styleCss.setWidth("960px");
            logListShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            logListShowParameter.setCustomParam(TERM_WORD_LOG_ID, (Object)termWordLogId);
            this.getView().showForm((FormShowParameter)logListShowParameter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List selectedTermwordIdList = (List)showParameter.getCustomParam(SELECTED_TERMWORD_ID_LIST);
        if (selectedTermwordIdList != null && !selectedTermwordIdList.isEmpty()) {
            QFilter wordInfoFilter = new QFilter(WORD_ID, "in", (Object)selectedTermwordIdList);
            e.addCustomQFilter(wordInfoFilter);
        } else {
            QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            Set ids = QueryServiceHelper.query((String)CTS_TERMWORD, (String)ID, (QFilter[])qFilter.toArray()).stream().map(dy -> dy.getLong(ID)).collect(Collectors.toSet());
            QFilter wordInfoFilter = new QFilter(WORD_ID, "in", ids);
            e.addCustomQFilter(wordInfoFilter);
        }
        QFilter typeFilter = new QFilter(TYPE, "in", typeList);
        e.addCustomQFilter(typeFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new TermWordLogProvider());
    }

    static {
        typeList.add("3");
        typeList.add("4");
    }

    static class TermWordLogProvider
    extends ListDataProvider
    implements FilterAndSortBuilder {
        TermWordLogProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection collection;
            if (this.getOrderByExpr() == null) {
                this.setOrderByExpr("id DESC");
            }
            if (!(collection = super.getData(start, limit)).isEmpty()) {
                DynamicObjectType dOtype = ((DynamicObject)collection.get(0)).getDynamicObjectType();
                dOtype.addProperty((DynamicProperty)new DynamicSimpleProperty(TermWordLogListPlugin.TYPE_HYPERLINK, String.class, (Object)""));
            }
            for (DynamicObject dy : collection) {
                int type = Integer.parseInt(dy.getString(TermWordLogListPlugin.TYPE));
                if (TermWordLogTypeEnum.REPLACE.getCode() != type && TermWordLogTypeEnum.REVERT.getCode() != type) continue;
                dy.set(TermWordLogListPlugin.TYPE_HYPERLINK, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"TermWordLogListPlugin_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            }
            return collection;
        }
    }
}

