/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.formplugin.task.AbstractTermWordTask;
import kd.bos.helper.CacheHelper;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ExtractTermWordCompTask
extends AbstractTermWordTask {
    private static final Log logger = LogFactory.getLog(ExtractTermWordCompTask.class);
    private static final String ID = "id";
    private static final String ENABLE = "enable";
    private static final String LANID = "lanid";
    private static final String WORDSTATUS = "wordstatus";
    private static final String TERM_WORD_COMP_TASK = "termWordCompTask";
    private static final String TERM_MATCH = "term_match";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private final DistributeSessionlessCache cache = CacheHelper.getIntlTermCache();
    private long currentCount = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.cache.put(TERM_WORD_COMP_TASK, (Object)TERM_MATCH, 2000);
            List termIds = (List)map.get("termIds");
            String lanId = (String)map.get("lanId");
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u68c0\u7d22\u8bcd\u6761\u3002", (String)"ExtractTermWordCompTask_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), null);
            QFilter qFilter = new QFilter(ID, "in", (Object)termIds).and(WORDSTATUS, "!=", (Object)"2").and(ENABLE, "=", (Object)Character.valueOf('1')).and(LANID, "=", (Object)Long.parseLong(lanId));
            Map words = BusinessDataServiceHelper.loadFromCache((String)"cts_termword", (String)"id, termword, termwordcust,cloudid, appid, lanid", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isEmpty((Map)words)) {
                result.put("success", FALSE);
                result.put("error", ResManager.loadKDString((String)"\u5f53\u524d\u8bed\u8a00\u73af\u5883\u6ca1\u6709\u672f\u8bed\u3002", (String)"ExtractTermWordCompTask_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            } else {
                TermReplaceHelper.extractCompAndPrompt(words, lanId, 90, false, this);
                result.put("success", TRUE);
                result.put("error", "");
            }
        }
        catch (Exception e) {
            logger.error("MatchTermWordComp failed", (Throwable)e);
            if (e instanceof KDException && "TASK_STOPED_BY_USER".equals(((KDException)e).getErrorCode().getCode())) {
                result.put("success", FALSE);
                result.put("error", ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ec8\u6b62\u3002", (String)"ExtractTermWordCompTask_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            } else {
                result.put("success", FALSE);
                result.put("error", ResManager.loadKDString((String)"\u68c0\u7d22\u8bcd\u6761\u5931\u8d25\u3002", (String)"ExtractTermWordCompTask_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            this.feedbackCustomdata(result);
            this.cache.remove(TERM_WORD_COMP_TASK);
        }
    }

    @Override
    public void feedbackTermResProgress(int index, int allCount, int weight) {
        int progress = index * weight / allCount;
        if (this.currentCount != (long)index) {
            this.currentCount = index;
            String desc = String.format(ResManager.loadKDString((String)"\u5df2\u68c0\u7d22\uff08%1$s/%2$s\uff09\u5e94\u7528\u3002", (String)"TermReplaceHelper_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), index, allCount);
            try {
                this.feedbackTaskProgress(progress, desc, null);
            }
            catch (Exception e) {
                logger.error("feedbackTaskProgressException", (Throwable)e);
            }
            this.checkIsStop();
        }
    }
}

