/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.exception.KDException;
import kd.bos.formplugin.task.AbstractTermWordTask;
import kd.bos.helper.CacheHelper;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ReplaceTermWordCompTask
extends AbstractTermWordTask {
    private static final Log logger = LogFactory.getLog(ReplaceTermWordCompTask.class);
    private final DistributeSessionlessCache cache = CacheHelper.getIntlTermCache();
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String TERM_REPLACE = "term_replace";
    private static final String TERM_WORD_COMP_TASK = "termWordCompTask";
    private long compCount = 1L;
    private long currentCount = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String lanNumber = (String)map.get("lanNumber");
        List termIds = (List)map.get("termIds");
        List compIds = (List)map.get("compIds");
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.cache.put(TERM_WORD_COMP_TASK, (Object)TERM_REPLACE, 1000);
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u66ff\u6362\u8bcd\u6761\u3002", (String)"ReplaceTermWordCompTask_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), null);
            QFilter compQFilter = new QFilter("id", "in", (Object)compIds).and("enable", "=", (Object)Character.valueOf('1'));
            List<TermWordCompEntity> compDynamicObjects = TermReplaceHelper.getWordCompsByTermId(compQFilter.toArray());
            if (compDynamicObjects.isEmpty()) {
                return;
            }
            Map appMap = BusinessDataServiceHelper.loadFromCache((Object[])compDynamicObjects.stream().map(TermWordCompEntity::getAppid).filter(Objects::nonNull).distinct().toArray(), (String)"bos_devportal_bizapp");
            this.compCount = compDynamicObjects.stream().map(e -> e.getWordcomp() + (e.getAppid() == null ? "" : (appMap.get(e.getAppid()) == null ? "" : ((DynamicObject)appMap.get(e.getAppid())).getString("name")))).distinct().count();
            TermReplaceHelper.applyCompAndPrompt(compDynamicObjects, lanNumber, termIds.toArray(), this, false);
            result.put("success", TRUE);
            result.put("error", "");
        }
        catch (Exception e2) {
            logger.error("Term replace failed, e:", (Throwable)e2);
            if (e2 instanceof KDException && "TASK_STOPED_BY_USER".equals(((KDException)e2).getErrorCode().getCode())) {
                result.put("success", FALSE);
                result.put("error", ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ec8\u6b62\u3002", (String)"ReplaceTermWordCompTask_5", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            } else {
                result.put("success", FALSE);
                result.put("error", ResManager.loadKDString((String)"\u66ff\u6362\u8bcd\u6761\u5931\u8d25\u3002", (String)"ReplaceTermWordCompTask_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            this.feedbackCustomdata(result);
            this.cache.remove(TERM_WORD_COMP_TASK);
        }
    }

    @Override
    public void feedbackApplyTermResProgress(int index, int allCount) {
        int progress = index * 90 / allCount;
        long i = (long)index * this.compCount / (long)allCount;
        if (this.currentCount != i) {
            this.currentCount = i;
            String msg = ResManager.loadKDString((String)"\u5df2\u66ff\u6362\uff08%1$s/%2$s\uff09\u5305\u542b\u672f\u8bed\u7684\u8bcd\u6761\u3002", (String)"ReplaceTermWordCompTask_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
            String desc = String.format(msg, this.currentCount, this.compCount);
            try {
                this.feedbackTaskProgress(progress, desc, null);
            }
            catch (Exception e) {
                logger.error("feedbackTaskProgressException", (Throwable)e);
            }
            this.checkIsStop();
        }
    }
}

