/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formplugin.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.exception.KDException;
import kd.bos.formplugin.task.AbstractTermWordTask;
import kd.bos.helper.CacheHelper;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.helper.TermWordPresetHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TermWordPresetTask
extends AbstractTermWordTask {
    private static final Log logger = LogFactory.getLog(TermWordPresetTask.class);
    public static final String PRESETDETAILID_TERMPRESETID_ID = "presetdetailid.termpresetid.id";
    private static final String CTS_TERMWORD_PRESET = "cts_termword_preset";
    private static final String ENABLE = "enable";
    private static final String LANID = "lanid";
    private static long compCount = 1L;
    private long currentCount = 0L;
    private final DistributeSessionlessCache cache = CacheHelper.getIntlTermCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object presetId = map.get("presetId");
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.cache.put("termWordCompTask", (Object)"preset_replace", 3000);
            this.cache.put("revertPromptWord", (Object)"preset_replace", 3000);
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u9884\u7f6e\u66ff\u6362\u4efb\u52a1\u3002", (String)"TermWordPresetTask_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), null);
            DynamicObject preset = BusinessDataServiceHelper.loadSingleFromCache((Object)presetId, (String)CTS_TERMWORD_PRESET);
            TermWordPresetHelper.updateIndustryTerm(preset);
            QFilter qFilter = new QFilter(PRESETDETAILID_TERMPRESETID_ID, "=", preset.getPkValue()).and(ENABLE, "=", (Object)Character.valueOf('1'));
            DynamicObject lan = preset.getDynamicObject(LANID);
            Map terms = BusinessDataServiceHelper.loadFromCache((String)"cts_termword", (String)"id, termword, termwordcust, cloudid, appid, lanid", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isEmpty((Map)terms)) {
                return;
            }
            Object lanId = lan.getPkValue();
            String lanNum = lan.getString("number");
            TermReplaceHelper.extractCompAndPrompt(terms, lanId.toString(), 40, true, this);
            Object[] termIds = terms.keySet().toArray(new Object[0]);
            QFilter compQFilter = new QFilter("wordid", "in", (Object)termIds).and(LANID, "=", lanId).and("wordstatus", "=", (Object)Character.valueOf('1')).and(ENABLE, "=", (Object)Character.valueOf('1'));
            List<TermWordCompEntity> compDynamicObjects = TermReplaceHelper.getWordCompsByTermId(compQFilter.toArray());
            if (compDynamicObjects.isEmpty()) {
                return;
            }
            Map appMap = BusinessDataServiceHelper.loadFromCache((Object[])compDynamicObjects.stream().map(TermWordCompEntity::getAppid).filter(Objects::nonNull).distinct().toArray(), (String)"bos_devportal_bizapp");
            compCount = compDynamicObjects.stream().map(e -> e.getWordcomp() + (e.getAppid() == null ? "" : (appMap.get(e.getAppid()) == null ? "" : ((DynamicObject)appMap.get(e.getAppid())).getString("name")))).distinct().count();
            TermReplaceHelper.applyCompAndPrompt(compDynamicObjects, lanNum, termIds, this, false);
            result.put("success", "true");
            result.put("error", "");
        }
        catch (Exception e2) {
            logger.error("TermWordPreset failed:", (Throwable)e2);
            result.put("success", "false");
            if (e2 instanceof KDException && "TASK_STOPED_BY_USER".equals(((KDException)e2).getErrorCode().getCode())) {
                result.put("error", ResManager.loadKDString((String)"\u9884\u7f6e\u66ff\u6362\u4efb\u52a1\u88ab\u7ec8\u6b62\u3002", (String)"TermWordPresetTask_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            } else {
                result.put("error", ResManager.loadKDString((String)"\u9884\u7f6e\u66ff\u6362\u4efb\u52a1\u5931\u8d25\u3002", (String)"TermWordPresetTask_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            this.feedbackCustomdata(result);
            this.cache.remove("termWordCompTask");
            this.cache.remove("revertPromptWord");
        }
    }

    @Override
    public void feedbackApplyTermResProgress(int index, int allCount) {
        int progress = index * 40 / allCount + 40;
        long i = (long)index * compCount / (long)allCount;
        if (this.currentCount != i) {
            this.currentCount = i;
            String msg = ResManager.loadKDString((String)"\u5df2\u66ff\u6362\uff08%1$s/%2$s\uff09\u5305\u542b\u672f\u8bed\u7684\u8bcd\u6761\u3002", (String)"ReplaceTermWordCompTask_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
            String desc = String.format(msg, this.currentCount, compCount);
            try {
                this.feedbackTaskProgress(progress, desc, null);
            }
            catch (Exception e) {
                logger.error("feedbackTaskProgressException", (Throwable)e);
            }
            this.checkIsStop();
        }
    }
}

