/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.helper.ExcelUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ExcelImExportUtil {
    public static final int COLUMN_FID_INDEX = 0;
    public static final int COLUMN_TYPE_INDEX = 1;
    public static final int COLUMN_NAME_INDEX = 2;
    public static final int COLUMN_CUST_NAME_INDEX = 3;
    public static final int COLUMN_CLOUD_INDEX = 4;
    public static final int COLUMN_APP_INDEX = 5;
    public static final int COLUMN_SIZE = 6;
    public static final int CUST_NAME_LENGTH_LIMIT = 80;

    public static Boolean checkExcelTitle(String entity, Row title) {
        if (title == null) {
            return Boolean.FALSE;
        }
        short fisrt = title.getFirstCellNum();
        short last = title.getLastCellNum();
        HashMap<String, String[]> excelTitleLine = new HashMap<String, String[]>();
        excelTitleLine.put("t_cts_termword", new String[]{ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExcelImExportUtil_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ExcelImExportUtil_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u539f\u540d\u79f0", (String)"ExcelImExportUtil_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65b0\u540d\u79f0", (String)"ExcelImExportUtil_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6240\u5c5e\u4e91", (String)"ExcelImExportUtil_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528", (String)"ExcelImExportUtil_5", (String)"bos-intlterm-formplugin", (Object[])new Object[0])});
        String[] firstLine = (String[])excelTitleLine.get(entity);
        if (fisrt != 0 || last != firstLine.length) {
            return Boolean.FALSE;
        }
        for (int i = 0; i <= last - 1; ++i) {
            Cell cell = title.getCell(i);
            if (cell == null) {
                return Boolean.FALSE;
            }
            if (firstLine[i].equals(cell.getStringCellValue())) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Map<String, String[]> getExcelTitleLine() {
        HashMap<String, String[]> excelTitleLine = new HashMap<String, String[]>();
        excelTitleLine.put("t_cts_termword", new String[]{ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExcelImExportUtil_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ExcelImExportUtil_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u539f\u540d\u79f0", (String)"ExcelImExportUtil_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65b0\u540d\u79f0", (String)"ExcelImExportUtil_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6240\u5c5e\u4e91", (String)"ExcelImExportUtil_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528", (String)"ExcelImExportUtil_5", (String)"bos-intlterm-formplugin", (Object[])new Object[0])});
        return excelTitleLine;
    }

    public static String checkExcelLineFormat(Row line) {
        String formatErrorInfo = null;
        if (ExcelImExportUtil.isCellNotNull(line, 0)) {
            formatErrorInfo = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExcelImExportUtil_6", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
        }
        if (ExcelImExportUtil.isCellNotNull(line, 1)) {
            formatErrorInfo = ResManager.loadKDString((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExcelImExportUtil_7", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
        }
        if (ExcelImExportUtil.isCellNotNull(line, 2)) {
            formatErrorInfo = ResManager.loadKDString((String)"\u539f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExcelImExportUtil_8", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
        }
        if (ExcelImExportUtil.isCellNotNull(line, 3)) {
            formatErrorInfo = ResManager.loadKDString((String)"\u65b0\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"ExcelImExportUtil_9", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
        }
        if (ExcelImExportUtil.isCellNotNull(line, 4)) {
            formatErrorInfo = ResManager.loadKDString((String)"\u6240\u5c5e\u4e91\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExcelImExportUtil_10", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
        }
        if (ExcelImExportUtil.isCellNotEqual(line)) {
            formatErrorInfo = ResManager.loadKDString((String)"\u65b0\u540d\u79f0\u4e0e\u539f\u540d\u79f0\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IntlTermWordFormPlugin_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]);
        }
        return formatErrorInfo;
    }

    private static boolean isCellNotNull(Row line, int index) {
        Cell cell = line.getCell(index);
        String cellValue = ExcelUtil.getCellValue(cell);
        return cell == null || "".equals(cellValue.trim());
    }

    private static boolean isCellNotEqual(Row line) {
        Cell orgCell = line.getCell(2);
        String orgValue = ExcelUtil.getCellValue(orgCell);
        Cell tarCell = line.getCell(3);
        String tarValue = ExcelUtil.getCellValue(tarCell);
        return orgValue != null && orgValue.equals(tarValue);
    }

    public static Boolean checkExcelLineLength(Row line) {
        if (line == null) {
            return Boolean.FALSE;
        }
        String cellvalue = ExcelUtil.getCellValue(line.getCell(3));
        if (StringUtils.isNotEmpty((CharSequence)cellvalue) && cellvalue.length() > 80) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static List<String> buildErrorData(Row line) {
        ArrayList<String> values = new ArrayList<String>(10);
        if (line != null) {
            for (int i = 0; i < 6; ++i) {
                if (line.getCell(i) != null) {
                    values.add(ExcelUtil.getCellValue(line.getCell(i)));
                    continue;
                }
                values.add("");
            }
        }
        return values;
    }

    public static String getErrorTableName() {
        String locale = Locale.getDefault().toString();
        String date = DateTimeFormatter.ofPattern("MMdd").format(LocalDateTime.now());
        if ("zh_CN".equals(locale)) {
            return String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5217\u8868_\u9519\u8bef\u62a5\u544a%s", (String)"ExcelImExportUtil_12", (String)"bos-intlterm-formplugin", (Object[])new Object[0]), date);
        }
        return "Import_List_Error_Report_" + date;
    }
}

