/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static Log logger = LogFactory.getLog(ExcelUtil.class);
    private static final String FILTER_IS_EXEC = "FILTER_IS_EXEC";
    private static final String FILTER_LANID_VAL = "lanid_val";
    private static final String FILTER_APPID_VAL = "appid_val";
    private static final String FILTER_FAST_KEY = "fast_key";
    private static final String FILTER_FAST_VAL = "fast_val";
    private static final String FIELD_NAME = "FieldName";
    private static final String VALUE = "Value";

    public static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue() == null ? "" : cell.getStringCellValue();
            }
            case NUMERIC: {
                double d = cell.getNumericCellValue();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date cal = DateUtil.getJavaDate((double)d);
                    return ExcelUtil.getStringByDate(cal);
                }
                BigDecimal bd = new BigDecimal(Double.toString(d));
                String s = bd.toString();
                if (s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                return s;
            }
            case FORMULA: {
                String valueStr = null;
                valueStr = cell.getStringCellValue();
                if (valueStr != null && valueStr.trim().length() > 0) {
                    return valueStr.trim();
                }
                double value = cell.getNumericCellValue();
                BigDecimal bd = new BigDecimal(Double.toString(value));
                valueStr = bd.toString();
                if (valueStr.endsWith(".0")) {
                    valueStr = valueStr.substring(0, valueStr.length() - 2);
                }
                return valueStr;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return "";
            }
        }
        return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
    }

    private static String getCellValueToString(double numericCellValue) {
        String cellValue = String.valueOf(numericCellValue);
        if (cellValue.endsWith(".0")) {
            cellValue = cellValue.substring(0, cellValue.length() - 2);
        }
        return cellValue;
    }

    private static String getStringByDate(Date d) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        StringBuilder dateStr = new StringBuilder();
        dateStr.append(cl.get(1));
        dateStr.append('-');
        int month = cl.get(2) + 1;
        if (month < 10) {
            dateStr.append('0');
        }
        dateStr.append(month);
        dateStr.append('-');
        int day = cl.get(5);
        if (day < 10) {
            dateStr.append('0');
        }
        dateStr.append(day);
        return dateStr.toString();
    }

    public static String createExcel(List<List<String>> excelData, String fileName) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        XSSFDataFormat format = workbook.createDataFormat();
        XSSFCellStyle commonStyle = workbook.createCellStyle();
        commonStyle.setDataFormat(format.getFormat("@"));
        for (int i = 0; i < excelData.size(); ++i) {
            List<String> cellInfo = excelData.get(i);
            XSSFRow row = sheet.createRow(i);
            for (int j = 0; j < cellInfo.size(); ++j) {
                XSSFCell cell = row.createCell(j);
                cell.setCellStyle((CellStyle)commonStyle);
                cell.setCellValue(cellInfo.get(j));
            }
        }
        fileName = fileName + ".xlsx";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
    }

    public static void filterInfoAddToCache(IPageCache pageCache, FilterContainerSearchClickArgs args) {
        pageCache.put(FILTER_IS_EXEC, "true");
        List customfilter = (List)args.getSearchClickEvent().getFilterValues().get("customfilter");
        List fastfilter = (List)args.getSearchClickEvent().getFilterValues().get("fastfilter");
        customfilter.forEach(item -> {
            if ("lanid".equals(((List)item.get(FIELD_NAME)).get(0))) {
                if ("".equals(((List)item.get(VALUE)).get(0))) {
                    pageCache.remove(FILTER_LANID_VAL);
                } else {
                    pageCache.put(FILTER_LANID_VAL, SerializationUtils.toJsonString(item.get(VALUE)));
                }
            }
            if ("app".equals(((List)item.get(FIELD_NAME)).get(0))) {
                if ("".equals(((List)item.get(VALUE)).get(0))) {
                    pageCache.remove(FILTER_APPID_VAL);
                } else {
                    pageCache.put(FILTER_APPID_VAL, SerializationUtils.toJsonString(item.get(VALUE)));
                }
            }
        });
        if (fastfilter.size() == 0) {
            pageCache.remove(FILTER_FAST_KEY);
            pageCache.remove(FILTER_FAST_VAL);
        } else {
            fastfilter.forEach(item -> {
                List key = (List)item.get(FIELD_NAME);
                List val = (List)item.get(VALUE);
                pageCache.put(FILTER_FAST_KEY, SerializationUtils.toJsonString((Object)key));
                pageCache.put(FILTER_FAST_VAL, SerializationUtils.toJsonString((Object)val));
            });
        }
    }

    private static Map<String, List<Object>> getSelectRows(IFormView view) {
        HashMap<String, List<Object>> resultMap = new HashMap<String, List<Object>>();
        BillList billList = (BillList)view.getControl("billlistap");
        BillList billList1 = (BillList)view.getControl("billlistap1");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        ListSelectedRowCollection listSelectedRows1 = billList1.getSelectedRows();
        ArrayList<Object> termPkList = new ArrayList<Object>();
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            termPkList.add(listSelectedRow.getPrimaryKeyValue());
        }
        resultMap.put("termPkList", termPkList);
        ArrayList<Object> wordPkList = new ArrayList<Object>();
        for (ListSelectedRow listSelectedRow : listSelectedRows1) {
            wordPkList.add(listSelectedRow.getPrimaryKeyValue());
        }
        resultMap.put("wordPkList", wordPkList);
        return resultMap;
    }

    private static List<Map<String, String>> getWordDataList(List<Object> wordPkList) {
        QFilter qFilter = new QFilter("id", "in", wordPkList).and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cts_termwordcomp", (String)"id,lanid,appid, wordid, wordcomp, wordcompcust", (QFilter[])qFilter.toArray());
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(10);
        for (DynamicObject dynamicObject : load) {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            rowMap.put("fid", dynamicObject.getLong("id") + "W");
            rowMap.put("desc", ResManager.loadKDString((String)"\u5305\u542b\u672f\u8bed\u7684\u8bcd\u6761", (String)"ExcelUtil_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
            rowMap.put("fwordcomp", dynamicObject.getString("wordcomp"));
            rowMap.put("fwordcompcust", dynamicObject.getString("wordcompcust"));
            DynamicObject word = dynamicObject.getDynamicObject("wordid");
            DynamicObject app = dynamicObject.getDynamicObject("appid");
            String wordid = word.getString("id");
            DynamicObject cloud = word.getDynamicObject("cloudid");
            rowMap.put("fwordid", wordid);
            rowMap.put("fwordid_l", wordid + "L");
            rowMap.put("cloudid", cloud == null ? "" : cloud.getString("name"));
            rowMap.put("appid", app == null ? "" : app.getString("name"));
            dataList.add(rowMap);
        }
        return dataList;
    }

    private static List<List<String>> getTermDataList(String sql) {
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[0], rs -> {
            ArrayList dataList = new ArrayList(10);
            while (rs.next()) {
                DynamicObject appObject = BusinessDataServiceHelper.loadSingleFromCache((Object)rs.getString("fappid"), (String)"bos_devportal_bizapp");
                DynamicObject cloudObject = BusinessDataServiceHelper.loadSingleFromCache((Object)rs.getString("fcloudid"), (String)"bos_devportal_bizcloud");
                if (null == cloudObject) continue;
                ArrayList<String> row = new ArrayList<String>();
                row.add(rs.getLong("FID") + "T");
                row.add(ResManager.loadKDString((String)"\u672f\u8bed", (String)"ExcelUtil_1", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
                row.add(rs.getString("ftermword"));
                row.add(rs.getString("ftermwordcust"));
                String cloudName = cloudObject.getString("name");
                String appName = appObject != null ? appObject.getString("name") : "";
                row.add(cloudName);
                row.add(appName);
                dataList.add(row);
            }
            return dataList;
        });
    }

    private static List<List<String>> getSelectRowsExpordResult(IFormView view, IPageCache pageCache) {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>(16);
        Map<String, List<Object>> selectRows = ExcelUtil.getSelectRows(view);
        List<Object> termPkList = selectRows.get("termPkList");
        List<Object> wordPkList = selectRows.get("wordPkList");
        if (termPkList.isEmpty() && wordPkList.isEmpty()) {
            return resultList;
        }
        List<Object> termDataList = new ArrayList();
        if (termPkList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT FID,FTERMWORD,FTERMWORDCUST,FAPPID,FCLOUDID ");
            sb.append("FROM T_CTS_TERMWORD ");
            sb.append("WHERE FENABLE = '1' AND FID IN (");
            for (Object id : termPkList) {
                sb.append(id).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(')');
            termDataList = ExcelUtil.getTermDataList(sb.toString());
        }
        List<Object> wordDataList = new ArrayList();
        if (wordPkList.size() > 0) {
            wordDataList = ExcelUtil.getWordDataList(wordPkList);
        }
        for (List termData : termDataList) {
            resultList.add(termData);
            for (Map map : wordDataList) {
                String replace = ((String)map.get("fwordid_l")).replace('L', 'T');
                if (!replace.equals(termData.get(0))) continue;
                ArrayList rowData = new ArrayList();
                rowData.add(map.get("fid"));
                rowData.add(map.get("desc"));
                rowData.add(map.get("fwordcomp"));
                rowData.add(map.get("fwordcompcust"));
                rowData.add(map.get("cloudid"));
                rowData.add(map.get("appid"));
                resultList.add(rowData);
            }
        }
        return resultList;
    }

    private static List<List<String>> getFilterExportData(IPageCache pageCache) {
        boolean isFilterExec = pageCache.get(FILTER_IS_EXEC) != null;
        boolean isFilterLan = false;
        Object filterLanId = null;
        if (pageCache.get(FILTER_LANID_VAL) != null) {
            List lanidVal = SerializationUtils.fromJsonStringToList((String)pageCache.get(FILTER_LANID_VAL), Object.class);
            isFilterLan = !"".equals(lanidVal.get(0));
            filterLanId = lanidVal.get(0);
        }
        boolean isFilterApp = false;
        List filterAppIdList = null;
        if (pageCache.get(FILTER_APPID_VAL) != null) {
            List appidVal = SerializationUtils.fromJsonStringToList((String)pageCache.get(FILTER_APPID_VAL), Object.class);
            isFilterApp = !"".equals(appidVal.get(0));
            filterAppIdList = appidVal;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT TW.FID AS FID,TW.FCLOUDID, TW.FTERMWORD AS FTERMWORD, TW.FTERMWORDCUST AS FTERMWORDCUST, ELAG.FNAME AS FLANGNAME, TW.FAPPID AS FAPPID, TW.FWORDSTATUS AS FWORDSTATUS ");
        sql.append("FROM T_CTS_TERMWORD TW ");
        sql.append("INNER JOIN T_INT_ENABLEDLANGUAGE ELAG ");
        sql.append("ON ELAG.FID = TW.FLANID ");
        sql.append("WHERE TW.FENABLE = '1' AND ELAG.fenabledlang = '1' ");
        if (!isFilterExec) {
            sql.append("AND TW.FLANID = ").append(Long.parseLong("328738425610159104")).append(' ');
        }
        if (isFilterLan && isFilterExec) {
            sql.append("AND TW.FLANID = ").append((Object)filterLanId).append(' ');
        }
        if (isFilterApp && isFilterExec) {
            sql.append("AND TW.FAPPID IN(");
            for (int i = 0; i < filterAppIdList.size(); ++i) {
                if (i == 0) {
                    sql.append('\'').append(filterAppIdList.get(i)).append('\'');
                    continue;
                }
                sql.append(",'").append(filterAppIdList.get(i)).append('\'');
            }
            sql.append(") ");
        }
        ExcelUtil.appendFastFilterSql(sql, pageCache, isFilterExec);
        return ExcelUtil.getTermDataList(sql.toString());
    }

    private static void appendFastFilterSql(StringBuilder sql, IPageCache pageCache, boolean isFilterExec) {
        boolean isFilterFast = false;
        List fastKey = null;
        List fastVal = null;
        if (pageCache.get(FILTER_FAST_KEY) != null) {
            isFilterFast = true;
            fastKey = SerializationUtils.fromJsonStringToList((String)pageCache.get(FILTER_FAST_KEY), Object.class);
            fastVal = SerializationUtils.fromJsonStringToList((String)pageCache.get(FILTER_FAST_VAL), Object.class);
        }
        if (isFilterFast && isFilterExec) {
            sql.append(" AND (");
            for (int i = 0; i < fastKey.size(); ++i) {
                if (i == 0) {
                    sql.append('f').append(fastKey.get(i)).append(" LIKE '%").append(fastVal.get(0)).append("%'");
                    continue;
                }
                sql.append(" OR ").append('f').append(fastKey.get(i)).append(" LIKE '%").append(fastVal.get(0)).append("%'");
            }
            sql.append(')');
        }
    }

    public static String exportTermAndWord(IFormView view, IPageCache pageCache) {
        List<List<String>> dataList = ExcelUtil.getSelectRowsExpordResult(view, pageCache);
        if (dataList.size() == 0) {
            dataList = ExcelUtil.getFilterExportData(pageCache);
        }
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> titleList = new ArrayList<String>();
        titleList.add(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExcelUtil_2", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        titleList.add(ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ExcelUtil_3", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        titleList.add(ResManager.loadKDString((String)"\u539f\u540d\u79f0", (String)"ExcelUtil_4", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        titleList.add(ResManager.loadKDString((String)"\u65b0\u540d\u79f0", (String)"ExcelUtil_5", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        titleList.add(ResManager.loadKDString((String)"\u6240\u5c5e\u4e91", (String)"ExcelUtil_6", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        titleList.add(ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528", (String)"ExcelUtil_7", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        resultList.add(titleList);
        resultList.addAll(dataList);
        return ExcelUtil.createExcel(resultList, ResManager.loadKDString((String)"\u672f\u8bed\u5bfc\u51fa", (String)"ExcelUtil_8", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
    }
}

