/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.BaseDataUtil;
import kd.bos.util.ExceptionUtils;

public class IntlServiceHelper {
    private static final Log logger = LogFactory.getLog(IntlServiceHelper.class);

    public static Map<String, String> getPromptWordByTerm(String number, String term, String lanNum) {
        HashMap<String, String> result = new HashMap<String, String>();
        String fileName = BaseDataUtil.getResourceFileName(number);
        try {
            if (Lang.zh_CN.name().equals(lanNum)) {
                return IntlServiceHelper.getPrompWordCh(term, result, fileName);
            }
            return IntlServiceHelper.getPromptWordTran(number, term, lanNum, result);
        }
        catch (IOException e) {
            logger.error("getPromptWordByTerm.e:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getPrompWordCh(String term, Map<String, String> result, String fileName) throws IOException {
        Properties properties = new Properties();
        InputStream is = IntlServiceHelper.class.getResourceAsStream("/resources/" + fileName);
        if (is == null) {
            return result;
        }
        try {
            BufferedReader bf = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            properties.load(bf);
            Enumeration<Object> enu = properties.keys();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                String value = (String)properties.get(key);
                if (!value.contains(term)) continue;
                result.put(key, value);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("getPrompWordCh.e:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        return result;
    }

    private static Map<String, String> getPromptWordTran(String number, String term, String lanNum, Map<String, String> result) {
        String sql = "SELECT fresid, ftranslation FROM t_int_promptwordtran_l WHERE fprojectnumber = ? AND flocaleid = ?";
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{number, lanNum}, rs -> {
            while (rs.next()) {
                String trans = rs.getString(2);
                if (!trans.contains(term)) continue;
                result.put(rs.getString(1), trans);
            }
            return result;
        });
    }
}

