/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.util.Collections;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;

public class JobFormInfoHelper {
    public static void buildJobFormInfo(String name, String taskClassName, CloseCallBack callBack, IFormView view, Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(params);
        jobInfo.setName(name);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        if (callBack != null) {
            jobFormInfo.setCloseCallBack(callBack);
        }
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName("kd.bos.formplugin.task.TaskProgressPanelClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)view);
    }

    public static Map<String, Object> getFeedBackCustomData(ClosedCallBackEvent event) {
        Map maps;
        Object returnData = event.getReturnData();
        if (returnData instanceof Map && "true".equals((maps = (Map)returnData).get("taskend"))) {
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)((String)maps.get("taskinfo")), TaskInfo.class);
            return (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
        }
        return Collections.emptyMap();
    }
}

