/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;

public class MetadataReaderHelper {
    public static Set<String> getMetaIdsByNumbersAndWords(Map<String, String> result, Map<String, Set<String>> parentIdMap, List<String> numbers) {
        HashSet<String> set = new HashSet<String>();
        result.forEach((k, v) -> {
            if (numbers.contains(v)) {
                set.add((String)k);
            }
        });
        HashSet child = new HashSet();
        parentIdMap.forEach((k, v) -> {
            if (set.contains(k)) {
                child.addAll(v);
            }
        });
        set.addAll(child);
        return set;
    }

    public static Map<String, String> getAllFormMeta(String lanNum, Set<String> termWords, List<String> numbers) {
        String sql1 = "select FID,FNUMBER,FDATA,FPARENTID from T_META_FORMDESIGN where FNUMBER in (%s)";
        String sql2 = "select FID,FNUMBER,FDATA from T_META_FORMDESIGN_L where FNUMBER in (%s) and FLOCALEID = ?";
        return MetadataReaderHelper.getAllMeta(lanNum, sql1, sql2, termWords, numbers);
    }

    public static Map<String, String> getAllEntityMeta(String lanNum, Set<String> termWords, List<String> numbers) {
        String sql1 = "select FID,FNUMBER,FDATA,FPARENTID from T_META_ENTITYDESIGN where FNUMBER in (%s)";
        String sql2 = "select FID,FNUMBER,FDATA from T_META_ENTITYDESIGN_L where FNUMBER in (%s) and FLOCALEID = ?";
        return MetadataReaderHelper.getAllMeta(lanNum, sql1, sql2, termWords, numbers);
    }

    private static Set<String> getChildRen(Map<String, Set<String>> parentIdMap, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        if (set == null) {
            parentIdMap.forEach((a, bf) -> bf.addAll(MetadataReaderHelper.getChildRen(parentIdMap, bf)));
        } else {
            set.forEach(v -> {
                Set set1 = (Set)parentIdMap.get(v);
                if (set1 != null) {
                    set1.addAll(MetadataReaderHelper.getChildRen(parentIdMap, set1));
                    hashSet.addAll(set1);
                }
            });
        }
        return hashSet;
    }

    private static Map<String, String> getAllMeta(String lanNum, String sql1, String sql2, Set<String> termWords, List<String> numbers) {
        String param1 = String.join((CharSequence)",", Collections.nCopies(numbers.size(), "?"));
        sql1 = String.format(sql1, param1);
        sql2 = String.format(sql2, param1);
        HashMap<String, String> result = new HashMap<String, String>();
        ResultSetHandler action1 = rs -> {
            while (rs.next()) {
                String fid = rs.getString(1);
                String fnumber = rs.getString(2);
                String fdata = rs.getString(3);
                if (fdata != null && !"zh_CN".equals(lanNum)) {
                    fdata = fdata.toUpperCase(Locale.ROOT);
                }
                for (String term : termWords) {
                    if (!"zh_CN".equals(lanNum)) {
                        term = term.toUpperCase(Locale.ROOT);
                    }
                    if (fdata == null || !fdata.contains(term)) continue;
                    result.put(fid, fnumber);
                }
            }
            return null;
        };
        DB.query((DBRoute)DBRoute.meta, (String)sql1, (Object[])numbers.toArray(), (ResultSetHandler)action1);
        numbers.add(lanNum);
        DB.query((DBRoute)DBRoute.meta, (String)sql2, (Object[])numbers.toArray(), (ResultSetHandler)action1);
        return result;
    }

    public static Map<String, Set<String>> getFormParentIdMap() {
        String sql = "select FID,FPARENTID from T_META_FORMDESIGN ";
        return MetadataReaderHelper.getParentIdMap(sql);
    }

    public static Map<String, Set<String>> getEntityParentIdMap() {
        String sql = "select FID,FPARENTID from T_META_ENTITYDESIGN";
        return MetadataReaderHelper.getParentIdMap(sql);
    }

    private static Map<String, Set<String>> getParentIdMap(String sql) {
        HashMap<String, Set<String>> parentIdMap = new HashMap<String, Set<String>>();
        ResultSetHandler action1 = rs -> {
            while (rs.next()) {
                String fid = rs.getString(1);
                String parentId = rs.getString(2);
                if (!StringUtils.isNotBlank((CharSequence)parentId)) continue;
                HashSet<String> set = (HashSet<String>)parentIdMap.get(parentId);
                if (set == null) {
                    set = new HashSet<String>();
                }
                set.add(fid);
                parentIdMap.put(parentId, set);
            }
            return null;
        };
        DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[0], (ResultSetHandler)action1);
        if (!parentIdMap.isEmpty()) {
            MetadataReaderHelper.getChildRen(parentIdMap, null);
        }
        return parentIdMap;
    }
}

