/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.helper.CacheHelper;

public final class OPTProgressHelper {
    public static void circleProgressHeader(String optKey, int present, int total, Map<String, String> params) {
        if (present < 0 || total < 0) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38", (String)"OPTProgressHelper_0", (String)"bos-intlterm-formplugin", (Object[])new Object[0]));
        }
        String progress = String.format("%s_%s", present, total);
        if (params != null && params.size() != 0) {
            String param = SerializationUtils.toJsonString(params);
            progress = String.format("%s_%s", progress, param);
        }
        CacheHelper.getIntlTermCache().put(optKey, (Object)progress, 3600);
    }

    public static void circleProgressTail(String optKey) {
        String progress;
        Boolean finished = OPTProgressHelper.isFinished(optKey);
        if (!finished.booleanValue() && StringUtils.isNotBlank((CharSequence)(progress = (String)CacheHelper.getIntlTermCache().get(optKey)))) {
            String[] progresses = progress.split("_");
            String value = String.format("%s_%s", Integer.parseInt(progresses[0]) + 1, progresses[1]);
            if (progresses.length == 3) {
                value = value + String.format("%s_%s", value, progresses[3]);
            }
            CacheHelper.getIntlTermCache().put(optKey, (Object)value, 3600);
        }
    }

    public static int presentProgress(String optKey) {
        String progress = (String)CacheHelper.getIntlTermCache().get(optKey);
        if (StringUtils.isNotBlank((CharSequence)progress)) {
            String[] progresses = progress.split("_");
            return Integer.parseInt(progresses[0]) * 100 / Integer.parseInt(progresses[1]);
        }
        return Integer.parseInt("100");
    }

    public static Boolean isFinished(String optKey) {
        int i = OPTProgressHelper.presentProgress(optKey);
        if (i >= 100 || i == -1) {
            CacheHelper.getIntlTermCache().remove(optKey);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void remove(String optKey) {
        CacheHelper.getIntlTermCache().remove(optKey);
    }
}

