/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.enums.AppWordTypeEnum;
import kd.bos.enums.TermStatusEnum;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PromptWordHelper {
    private static final Log logger = LogFactory.getLog(PromptWordHelper.class);
    private static final String APPID = "appid";
    private static final String CLOUD_ID = "cloudid";
    private static final String APP_ID = "appid";
    private static final String WORD_COMP = "wordcomp";

    private static void savePromptWord(List<DynamicObject> saveList, List<Object> deleteList) {
        try (TXHandle tx = TX.required();){
            try {
                if (!deleteList.isEmpty()) {
                    MainEntityType iDataEntityType = EntityMetadataCache.getDataEntityType((String)"cts_term_promptword");
                    DeleteServiceHelper.delete((IDataEntityType)iDataEntityType, (Object[])deleteList.toArray());
                }
                if (!saveList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                logger.error("extractPromptWord failed,", (Throwable)e);
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void extractPromptWord(Map<Object, DynamicObject> terms, String lanId, String lanNum, boolean isFill) {
        List cloudIds = terms.values().stream().map(v -> v.getDynamicObject(CLOUD_ID).getPkValue().toString()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("bizcloud", "in", cloudIds);
        Map appMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])qFilter.toArray());
        Map<String, String> collect = appMap.values().stream().collect(Collectors.toMap(v -> v.getString("id"), v -> v.getDynamicObject("bizcloud").getPkValue().toString()));
        DynamicObjectCollection promptProjects = QueryServiceHelper.query((String)"cts_termproject", (String)"id, number, appid", (QFilter[])new QFilter[]{new QFilter("appid", "in", collect.keySet())});
        Map<String, List<DynamicObject>> appProjects = promptProjects.stream().collect(Collectors.groupingBy(v -> v.getString("appid")));
        Map<String, List<DynamicObject>> cloudProjects = promptProjects.stream().collect(Collectors.groupingBy(v -> (String)collect.get(v.getString("appid"))));
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        QFilter filter = new QFilter("lanid", "=", (Object)Long.parseLong(lanId)).and("wordid", "in", terms.keySet()).and("category", "=", (Object)AppWordTypeEnum.PROMPT.name());
        Map prompts = BusinessDataServiceHelper.loadFromCache((String)"cts_term_promptword", (QFilter[])filter.toArray());
        HashMap<String, DynamicObject> promptKeyMap = new HashMap<String, DynamicObject>(16);
        ArrayList<Object> deleteList = new ArrayList<Object>(10);
        prompts.forEach((k, v) -> {
            if (v.getDynamicObject("wordid") == null || v.getDynamicObject("appid") == null) {
                deleteList.add(k);
            } else {
                promptKeyMap.put(TermReplaceHelper.buildCompKey(v), (DynamicObject)v);
            }
        });
        for (DynamicObject term : terms.values()) {
            String projectNumber;
            String appNumber;
            String cloudId = term.getDynamicObject(CLOUD_ID).getPkValue().toString();
            DynamicObject app = term.getDynamicObject("appid");
            if (app != null) {
                String appId = app.getPkValue().toString();
                List<DynamicObject> projects = appProjects.get(appId);
                if (projects == null) continue;
                for (DynamicObject promptProject : projects) {
                    appNumber = appMap.get(appId) != null ? ((DynamicObject)appMap.get(appId)).getString("number") : "bos";
                    projectNumber = promptProject.getString("number");
                    saveList.addAll(PromptWordHelper.generatePromptWords(lanId, lanNum, appId, appNumber, projectNumber, term, isFill, promptKeyMap));
                }
                continue;
            }
            List<DynamicObject> projects = cloudProjects.get(cloudId);
            if (projects == null) continue;
            for (DynamicObject promptProject : projects) {
                String appId = promptProject.getString("appid");
                appNumber = appMap.get(appId) != null ? ((DynamicObject)appMap.get(appId)).getString("number") : "bos";
                projectNumber = promptProject.getString("number");
                saveList.addAll(PromptWordHelper.generatePromptWords(lanId, lanNum, appId, appNumber, projectNumber, term, isFill, promptKeyMap));
            }
        }
        deleteList.addAll(promptKeyMap.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        PromptWordHelper.savePromptWord(saveList, deleteList);
    }

    private static List<DynamicObject> generatePromptWords(String lanId, String lanNum, String appId, String appNumber, String projectNumber, DynamicObject termObject, boolean isFill, Map<String, DynamicObject> promptKeyMap) {
        Map promptWords;
        ArrayList<DynamicObject> lists = new ArrayList<DynamicObject>(16);
        String termId = termObject.getString("id");
        String termWord = termObject.getString("termword");
        String termwordcust = termObject.getString("termwordcust");
        try {
            promptWords = (Map)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"GetPromptWordService", (String)"getPromptWordByTerm", (Object[])new Object[]{projectNumber, termWord, lanNum});
        }
        catch (Exception e) {
            logger.error("GetPromptWordService error", (Throwable)e);
            return lists;
        }
        if (promptWords == null || promptWords.isEmpty()) {
            return lists;
        }
        Set entrySet = promptWords.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String index = appId + termId + (Object)((Object)AppWordTypeEnum.PROMPT) + projectNumber + key;
            DynamicObject object = promptKeyMap.get(index);
            if (object != null) {
                promptKeyMap.remove(index);
            } else {
                object = BusinessDataServiceHelper.newDynamicObject((String)"cts_term_promptword");
                object.set("wordid", (Object)Long.parseLong(termId));
                object.set("lanid", (Object)Long.parseLong(lanId));
                object.set("key", (Object)key);
                object.set("category", (Object)AppWordTypeEnum.PROMPT);
                object.set("subjectid", (Object)projectNumber);
                object.set("appid", (Object)appId);
                object.set("enable", (Object)"1");
                object.set("status", (Object)"C");
            }
            object.set(WORD_COMP, (Object)value);
            if (isFill && StringUtils.isNotBlank((CharSequence)termwordcust)) {
                object.set("wordcompcust", (Object)object.getString(WORD_COMP).replace(termWord, termwordcust));
                object.set("wordstatus", (Object)TermStatusEnum.PENDING_REPLACE.getCode());
            }
            lists.add(object);
        }
        return lists;
    }
}

