/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.common.builder.FilterConditionBuilder;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.enums.AppWordTypeEnum;
import kd.bos.enums.TermStatusEnum;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.inte.service.helper.ApplyPromptWordService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PromptWordReplaceHelper {
    private static final Log logger = LogFactory.getLog(PromptWordReplaceHelper.class);
    private static final String WORD_COMP = "wordcomp";

    public static List<Long> applyPromptWord(List<Long> ids, boolean isRevert) {
        ArrayList<Long> failIds = new ArrayList<Long>();
        if (ids.isEmpty()) {
            return failIds;
        }
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        Map<String, Map<String, List<Object[]>>> resTermMaps = PromptWordReplaceHelper.getResTermMaps(ids, map);
        if (resTermMaps.isEmpty()) {
            return failIds;
        }
        logger.info(String.format("PromptWordReplaceHelper.applyPromptWord resTermMaps: %s", resTermMaps));
        TermReplaceHelper.updateTermWordCompStatus(ids, TermStatusEnum.REPLACING.getCode());
        ApplyPromptWordService applyPromptWordService = new ApplyPromptWordService();
        for (Map.Entry<String, Map<String, List<Object[]>>> next : resTermMaps.entrySet()) {
            String appId = next.getKey();
            try {
                if (isRevert) {
                    applyPromptWordService.revertPromptWord(next.getValue());
                    continue;
                }
                applyPromptWordService.replacePromptWord(next.getValue());
            }
            catch (Exception e) {
                failIds.addAll((Collection)map.get(appId));
            }
        }
        ids.removeAll(failIds);
        TermReplaceHelper.updateTermWordCompStatus(ids, isRevert ? TermStatusEnum.DEFAULT.getCode() : TermStatusEnum.REPLACED.getCode());
        if (!failIds.isEmpty()) {
            TermReplaceHelper.updateTermWordCompStatus(failIds, isRevert ? TermStatusEnum.REPLACED.getCode() : TermStatusEnum.PENDING_REPLACE.getCode());
        }
        return failIds;
    }

    public static Map<String, Map<String, List<Object[]>>> getResTermMaps(List<Long> ids, Map<String, List<Long>> map) {
        HashMap<String, Map<String, List<Object[]>>> resTermMaps = new HashMap<String, Map<String, List<Object[]>>>(16);
        Object[] params = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT c.fkey resId, c.FWORDCOMPCUST wordcompcust, l.FNUMBER langNum, c.FSUBJECTID projectNum, c.fappid appid, c.fid ");
        sql.append(" FROM t_cts_termwordcomp c ");
        sql.append(" LEFT JOIN t_int_language l ON l.fid = c.flanid WHERE c.FCATEGORY='PROMPT' ");
        if (ids != null && !ids.isEmpty()) {
            sql.append(FilterConditionBuilder.in("c.fid", ids.size()));
            params = ids.toArray();
        }
        DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), params, rs -> {
            while (rs.next()) {
                if (StringUtils.isBlank((CharSequence)rs.getString(2))) continue;
                HashMap maps = (HashMap)resTermMaps.get(rs.getString(5));
                if (maps == null) {
                    maps = new HashMap(16);
                    ArrayList<Object[]> deleteParams = new ArrayList<Object[]>();
                    ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
                    deleteParams.add(new Object[]{rs.getString(4), rs.getString(1), rs.getString(3)});
                    insertParams.add(new Object[]{Uuid16.create().toString(), rs.getString(1), rs.getString(3), rs.getString(2), rs.getString(4)});
                    maps.put("deleteParams", deleteParams);
                    maps.put("insertParams", insertParams);
                    resTermMaps.put(rs.getString(5), maps);
                    if (map == null) continue;
                    ArrayList<Long> longs = (ArrayList<Long>)map.get(rs.getString(5));
                    if (longs == null) {
                        longs = new ArrayList<Long>();
                    }
                    longs.add(rs.getLong(6));
                    map.put(rs.getString(5), longs);
                    continue;
                }
                List deleteParams1 = (List)maps.get("deleteParams");
                deleteParams1.add(new Object[]{rs.getString(4), rs.getString(1), rs.getString(3)});
                List insertParams1 = (List)maps.get("insertParams");
                insertParams1.add(new Object[]{Uuid16.create().toString(), rs.getString(1), rs.getString(3), rs.getString(2), rs.getString(4)});
            }
            return resTermMaps;
        });
        return resTermMaps;
    }

    public static void savePromptWords(Map<String, String> promptWords, String termId, String lanId, String projectNum, String appId) {
        DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cts_term_promptword"), null);
        ArrayList<DynamicObject> lists = new ArrayList<DynamicObject>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("lanid", "=", (Object)Long.parseLong(lanId)));
        qFilters.add(new QFilter("wordid", "=", (Object)Long.parseLong(termId)));
        qFilters.add(new QFilter("subjectid", "=", (Object)projectNum));
        qFilters.add(new QFilter("appid", "=", (Object)appId));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cts_term_promptword", (String)"id, key, wordcomp, wordcompcust, wordstatus, modifier, modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        Map<String, DynamicObject> map = Arrays.stream(load).collect(Collectors.toMap(e -> e.getString("key"), e -> e));
        Set<String> keys = map.keySet();
        Set<Map.Entry<String, String>> entrySet = promptWords.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (keys.contains(key)) {
                DynamicObject object = map.get(key);
                if (value.equals(object.getString(WORD_COMP))) continue;
                object.set("wordcompcust", (Object)"");
                object.set(WORD_COMP, (Object)value);
                object.set("wordstatus", (Object)"0");
                object.set("modifier", (Object)RequestContext.get().getCurrUserId());
                object.set("modifytime", (Object)TimeServiceHelper.now());
                lists.add(object);
                continue;
            }
            DynamicObject oj = BusinessDataServiceHelper.newDynamicObject((String)"cts_term_promptword");
            oj.set("wordid", (Object)Long.parseLong(termId));
            oj.set("lanid", (Object)Long.parseLong(lanId));
            oj.set(WORD_COMP, (Object)value);
            oj.set("key", (Object)key);
            oj.set("category", (Object)AppWordTypeEnum.PROMPT);
            oj.set("subjectid", (Object)projectNum);
            oj.set("appid", (Object)appId);
            oj.set("enable", (Object)"1");
            oj.set("status", (Object)"C");
            oj.set("creatorid", (Object)RequestContext.get().getCurrUserId());
            oj.set("createtime", (Object)TimeServiceHelper.now());
            collection.add((Object)oj);
        }
        keys.removeAll(promptWords.keySet());
        if (!keys.isEmpty()) {
            qFilters.add(new QFilter("key", "in", keys));
            DeleteServiceHelper.delete((String)"cts_term_promptword", (QFilter[])qFilters.toArray(new QFilter[0]));
        }
        SaveServiceHelper.update((DynamicObject[])lists.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])collection.toArray((Object[])new DynamicObject[0])));
    }
}

