/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.enums.AppWordTypeEnum;
import kd.bos.enums.TermStatusEnum;
import kd.bos.enums.TermWordLogTypeEnum;
import kd.bos.formplugin.task.AbstractTermWordTask;
import kd.bos.helper.MetadataReaderHelper;
import kd.bos.helper.PromptWordHelper;
import kd.bos.helper.PromptWordReplaceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.mulilang.LocaleMetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.thread.MatchLocaleMetaFunction;
import kd.bos.thread.Worker;
import kd.bos.threads.ThreadPools;
import kd.bos.util.BaseDataUtil;
import kd.bos.util.LogUtil;

public class TermReplaceHelper {
    private static final Log logger = LogFactory.getLog(TermReplaceHelper.class);
    private static final String CLOUD_ID = "cloudid";
    private static final String APP_ID = "appid";
    private static final String LAN_ID = "lanid";
    private static final String WORD_ID = "wordid";
    private static final String WORD_COMP = "wordcomp";
    public static final String DELIMITER = "__";
    private static final String WORDCOMP = "wordcomp";
    private static final String WORDSTATUS = "wordstatus";
    private static final String WORDCOMPCUST = "wordcompcust";
    private static final String MODIFIER = "modifier";
    private static final String MODIFYTIME = "modifytime";

    public static Set<String> getBizIdsByCloudId(String bizCloudId) {
        QFilter qFilter = new QFilter("bizcloud", "=", (Object)bizCloudId);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])qFilter.toArray());
        return dynamicObjectMap.keySet().stream().map(Object::toString).collect(Collectors.toSet());
    }

    public static void extractCompAndPrompt(Map<Object, DynamicObject> words, String lanId, int weight, boolean isFill, AbstractTermWordTask task) {
        try (TXHandle h = TX.required();){
            try {
                long start = System.currentTimeMillis();
                logger.info("TermReplaceHelper extractCompAndPrompt execute start:" + start);
                String lanNum = BaseDataUtil.getLangNumByLanId(lanId);
                TermReplaceHelper.extractTermWordComp(words, lanId, lanNum, weight, isFill, task);
                long mid = System.currentTimeMillis();
                logger.info("TermReplaceHelper extractCompAndPrompt execute,\u62bd\u53d6\u8bcd\u6761\u8017\u65f6\uff08\u79d2\uff09 = " + new BigDecimal(mid - start).divide(new BigDecimal(1000), 4, RoundingMode.DOWN));
                PromptWordHelper.extractPromptWord(words, lanId, lanNum, isFill);
                TermReplaceHelper.refreshTermWordStatus(words.keySet().toArray(new Object[0]));
                long end = System.currentTimeMillis();
                logger.info("TermReplaceHelper extractCompAndPrompt execute end,\u62bd\u53d6\u603b\u8017\u65f6\uff08\u79d2\uff09 = " + new BigDecimal(end - start).divide(new BigDecimal(1000), 4, RoundingMode.DOWN));
            }
            catch (Exception e) {
                logger.error("MatchTermWordComp failed", (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
    }

    private static void extractTermWordComp(Map<Object, DynamicObject> words, String lanId, String lanNum, int weight, boolean isFill, AbstractTermWordTask task) {
        Map<String, List<DynamicObject>> objectMap = words.values().stream().collect(Collectors.groupingBy(e -> e.getDynamicObject(CLOUD_ID).getPkValue().toString() + DELIMITER + (e.getDynamicObject(APP_ID) == null ? "" : e.getDynamicObject(APP_ID).getPkValue().toString())));
        QFilter qFilter = new QFilter(LAN_ID, "=", (Object)Long.parseLong(lanId)).and(WORD_ID, "in", words.keySet()).and("category", "in", Arrays.asList(AppWordTypeEnum.FORM.name(), AppWordTypeEnum.ENTITY.name(), AppWordTypeEnum.MENU.name()));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"cts_termwordcomp", (QFilter[])qFilter.toArray());
        HashMap<String, DynamicObject> oldKeyMap = new HashMap<String, DynamicObject>(16);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(10);
        ArrayList deleteList = new ArrayList(10);
        map.forEach((k, v) -> {
            if (v.getDynamicObject(WORD_ID) == null || v.getDynamicObject(APP_ID) == null) {
                deleteList.add(k);
            } else {
                oldKeyMap.put(TermReplaceHelper.buildCompKey(v), (DynamicObject)v);
            }
        });
        int appCount = 0;
        for (Map.Entry<String, List<DynamicObject>> entry : objectMap.entrySet()) {
            String appIdStr = entry.getKey();
            String[] split = appIdStr.split(DELIMITER);
            Set<String> appIds = new HashSet();
            if (split.length > 1) {
                appIds.add(split[1]);
            } else {
                appIds = TermReplaceHelper.getBizIdsByCloudId(split[0]);
            }
            appCount += appIds.size();
        }
        int index = 0;
        Set<Object> appIds = new HashSet<String>(10);
        Map<String, Set<String>> formParentIdMap = MetadataReaderHelper.getFormParentIdMap();
        Map<String, Set<String>> entityParentIdMap = MetadataReaderHelper.getEntityParentIdMap();
        for (Map.Entry entry : objectMap.entrySet()) {
            String appIdStr = (String)entry.getKey();
            List entries = (List)entry.getValue();
            String[] split = appIdStr.split(DELIMITER);
            if (split.length > 1) {
                appIds.add(split[1]);
            } else {
                appIds = TermReplaceHelper.getBizIdsByCloudId(split[0]);
            }
            HashMap metaNumbersMap = new HashMap();
            ArrayList<String> cloudMetaNumbers = new ArrayList<String>();
            appIds.forEach(v -> {
                List<String> metaNumbersByAppId = TermReplaceHelper.getMetaIdsByAppId(v);
                metaNumbersMap.put(v, metaNumbersByAppId);
                cloudMetaNumbers.addAll(metaNumbersByAppId);
            });
            if (cloudMetaNumbers.isEmpty()) continue;
            Set<String> termWords = entries.stream().map(v -> v.getString("termword")).collect(Collectors.toSet());
            Map<String, String> allFormMeta = MetadataReaderHelper.getAllFormMeta(lanNum, termWords, cloudMetaNumbers);
            Map<String, String> allEntityMeta = MetadataReaderHelper.getAllEntityMeta(lanNum, termWords, cloudMetaNumbers);
            for (String string : appIds) {
                List metaNumbers = (List)metaNumbersMap.get(string);
                if (!metaNumbers.isEmpty()) {
                    Set<String> formIds = MetadataReaderHelper.getMetaIdsByNumbersAndWords(allFormMeta, formParentIdMap, metaNumbers);
                    Set<String> entityIds = MetadataReaderHelper.getMetaIdsByNumbersAndWords(allEntityMeta, entityParentIdMap, metaNumbers);
                    Map<String, DynamicObject> matchKeyMap = TermReplaceHelper.getResourceWithTerms(entries, string, formIds, entityIds, lanNum, isFill);
                    dynamicObjects.addAll(TermReplaceHelper.buildTermWordCompObject(oldKeyMap, matchKeyMap));
                }
                ++index;
                if (task == null) continue;
                task.feedbackTermResProgress(index, appCount, weight);
            }
            appIds.clear();
        }
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(deleteList)) {
            deleteList.addAll(oldKeyMap.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            MainEntityType iDataEntityType = EntityMetadataCache.getDataEntityType((String)"cts_termwordcomp");
            DeleteServiceHelper.delete((IDataEntityType)iDataEntityType, (Object[])deleteList.toArray());
        }
    }

    public static void applyTerms(AppWordTypeEnum type, Object termId, Map<String, Map<String, String>> resTermMap, String lanNumber, Map<String, Object> taskInfoMap) {
        IDataEntityType metaType;
        if (StringUtils.isBlank((CharSequence)lanNumber) || resTermMap == null || resTermMap.size() == 0) {
            logger.info(String.format("\u53c2\u6570\u4e3a\u7a7a,\u3010restermmap: %s\u3011,\u3010lannumber: %s\u3011", resTermMap, lanNumber));
            return;
        }
        AbstractTermWordTask task = null;
        int initCount = 0;
        int allCount = 0;
        if (taskInfoMap != null) {
            task = (AbstractTermWordTask)((Object)taskInfoMap.get("task"));
            initCount = (Integer)taskInfoMap.get("initCount");
            allCount = (Integer)taskInfoMap.get("allCount");
        }
        if ((metaType = TermReplaceHelper.getDataEntityType(type)) != null) {
            int index = initCount;
            for (Map.Entry<String, Map<String, String>> entry : resTermMap.entrySet()) {
                try {
                    LocaleMetadataServiceHelper.applyTermRes((IDataEntityType)metaType, (String)entry.getKey(), (String)lanNumber, entry.getValue());
                }
                catch (Exception e) {
                    logger.error(String.format("\u672f\u8bed\u5e94\u7528\u5931\u8d25,\u3010type:%1s\u3011,\u3010type:%2s\u3011,\u3010masterid:%3s\u3011,\u3010keymap:%4s\u3011,\u3010termId:%5s\u3011", new Object[]{lanNumber, type, entry.getKey(), entry.getValue(), termId}), (Throwable)e);
                }
                ++index;
                if (task == null) continue;
                task.feedbackApplyTermResProgress(index, allCount);
            }
        }
    }

    public static void applyCompAndPrompt(List<TermWordCompEntity> compDynamicObjects, String lanNum, Object[] termIds, AbstractTermWordTask task, boolean isRevert) throws Exception {
        try (TXHandle h = TX.required();){
            try {
                ArrayList<Long> promptIds = new ArrayList<Long>();
                ArrayList<TermWordCompEntity> comps = new ArrayList<TermWordCompEntity>();
                compDynamicObjects.forEach(v -> {
                    if (isRevert) {
                        v.setWordcompcust(null);
                    }
                    if ("PROMPT".equals(v.getCategory())) {
                        promptIds.add(v.getId());
                    } else {
                        comps.add((TermWordCompEntity)v);
                    }
                });
                long start = System.currentTimeMillis();
                logger.info("TermReplaceHelper applyCompAndPrompt execute start:" + start);
                TermReplaceHelper.updateStatus(termIds, null, TermStatusEnum.REPLACING.getCode());
                List<Long> failIds = TermReplaceHelper.applyTermsAsync(task, comps, lanNum, compDynamicObjects.size(), isRevert);
                long mid = System.currentTimeMillis();
                logger.info("TermReplaceHelper applyCompAndPrompt execute,\u66ff\u6362/\u6062\u590d\u8bcd\u6761\u8017\u65f6\uff08\u79d2\uff09 = " + new BigDecimal(mid - start).divide(new BigDecimal(1000), 4, RoundingMode.DOWN));
                failIds.addAll(PromptWordReplaceHelper.applyPromptWord(promptIds, isRevert));
                long end = System.currentTimeMillis();
                logger.info("TermReplaceHelper applyCompAndPrompt execute end,\u66ff\u6362/\u6062\u590d\u603b\u8017\u65f6\uff08\u79d2\uff09 = " + new BigDecimal(end - start).divide(new BigDecimal(1000), 4, RoundingMode.DOWN));
                TermReplaceHelper.refreshTermWordStatus(termIds);
                List<TermWordCompEntity> successList = compDynamicObjects.stream().filter(v -> !failIds.contains(v.getId())).collect(Collectors.toList());
                LogUtil.saveTermWordLogForReplaceOrRevert(successList, isRevert ? TermWordLogTypeEnum.REVERT : TermWordLogTypeEnum.REPLACE);
            }
            catch (Exception e) {
                logger.error("applyCompAndPrompt failed", (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
    }

    private static Map<String, Map<String, Map<String, String>>> applyTermsAsyncSubmit(Map<String, Map<String, Map<String, String>>> resTermMap, String lanNumber, int allCount, AtomicInteger index, AbstractTermWordTask task) throws ExecutionException, InterruptedException {
        HashMap<String, Map<String, Map<String, String>>> failMap = new HashMap<String, Map<String, Map<String, String>>>();
        HashMap failFutureMap = new HashMap();
        resTermMap.forEach((category, categoryValue) -> categoryValue.forEach((key, value) -> {
            AppWordTypeEnum typeEnum = AppWordTypeEnum.valueOf(category);
            IDataEntityType metaType = TermReplaceHelper.getDataEntityType(typeEnum);
            if (metaType != null) {
                Future<Map> future = MatchTermWordCompThreadPool.executorService.submit(() -> {
                    try {
                        LocaleMetadataServiceHelper.applyTermRes((IDataEntityType)metaType, (String)key, (String)lanNumber, (Map)value);
                    }
                    catch (Exception e) {
                        logger.error(String.format("\u672f\u8bed\u5e94\u7528\u5931\u8d25,\u3010metaType:%1s\u3011,\u3010fsubjectid:%2s\u3011,\u3010lanNumber:%3s\u3011,\u3010keymap:%4s\u3011", typeEnum.name(), key, lanNumber, value), (Throwable)e);
                        return value;
                    }
                    index.getAndIncrement();
                    if (task != null) {
                        task.feedbackApplyTermResProgress(index.get(), allCount);
                    }
                    return null;
                });
                HashMap<String, Future<Map>> map = (HashMap<String, Future<Map>>)failFutureMap.get(category);
                if (map == null) {
                    map = new HashMap<String, Future<Map>>();
                }
                map.put((String)key, future);
                failFutureMap.put(category, map);
            }
        }));
        for (Map.Entry futureEntry : failFutureMap.entrySet()) {
            String category2 = (String)futureEntry.getKey();
            for (Map.Entry futureMap : ((Map)futureEntry.getValue()).entrySet()) {
                String key = (String)futureMap.getKey();
                Map value = (Map)((Future)futureMap.getValue()).get();
                if (value == null) continue;
                HashMap<String, Map> mapMap = (HashMap<String, Map>)failMap.get(category2);
                if (mapMap == null) {
                    mapMap = new HashMap<String, Map>();
                }
                mapMap.put(key, value);
                failMap.put(category2, mapMap);
            }
        }
        return failMap;
    }

    private static List<Long> applyTermsAsync(AbstractTermWordTask task, List<TermWordCompEntity> comps, String lanNumber, int allCount, boolean isRevert) throws Exception {
        ArrayList<Long> failIds = new ArrayList<Long>();
        if (comps.isEmpty()) {
            return failIds;
        }
        Map<String, Map<String, Map<String, String>>> resTermMap = TermReplaceHelper.doResTermComps(comps);
        List<Long> wordCompIds = comps.stream().map(TermWordCompEntity::getId).collect(Collectors.toList());
        Map collect = comps.stream().collect(Collectors.groupingBy(v -> v.getCategory() + v.getSubjectid(), Collectors.mapping(TermWordCompEntity::getId, Collectors.toList())));
        TermReplaceHelper.updateTermWordCompStatus(wordCompIds, TermStatusEnum.REPLACING.getCode());
        int realCount = collect.size() * allCount / comps.size();
        AtomicInteger index = new AtomicInteger();
        resTermMap = TermReplaceHelper.applyTermsAsyncSubmit(resTermMap, lanNumber, realCount, index, task);
        resTermMap = TermReplaceHelper.applyTermsAsyncSubmit(resTermMap, lanNumber, realCount, index, task);
        resTermMap.forEach((category, categoryValue) -> categoryValue.forEach((key, value) -> failIds.addAll((Collection)collect.get(category + key))));
        wordCompIds.removeAll(failIds);
        TermReplaceHelper.updateTermWordCompStatus(wordCompIds, isRevert ? TermStatusEnum.DEFAULT.getCode() : TermStatusEnum.REPLACED.getCode());
        TermReplaceHelper.updateTermWordCompStatus(failIds, isRevert ? TermStatusEnum.REPLACED.getCode() : TermStatusEnum.PENDING_REPLACE.getCode());
        return failIds;
    }

    private static IDataEntityType getDataEntityType(AppWordTypeEnum type) {
        switch (type) {
            case FORM: {
                return OrmUtils.getDataEntityType(DesignFormMeta.class);
            }
            case ENTITY: {
                return OrmUtils.getDataEntityType(DesignEntityMeta.class);
            }
            case MENU: {
                return OrmUtils.getDataEntityType(DesignAppMeta.class);
            }
        }
        return null;
    }

    private static List<String> getMetaIdsByAppId(String appId) {
        ArrayList<String> formNumbers = new ArrayList();
        try {
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            formNumbers = bizAppService.getDesigntimeAllFormIdsByAppId(appId);
        }
        catch (Exception e) {
            logger.error(String.format("getMetaIdsByAppId failed, appId = %s,", appId), (Throwable)e);
        }
        return formNumbers;
    }

    private static Map<String, DynamicObject> getResourceWithTerms(List<DynamicObject> wordList, String appId, Set<String> formIds, Set<String> entityIds, String lanNum, boolean isFill) {
        IDataEntityType formType = OrmUtils.getDataEntityType(DesignFormMeta.class);
        IDataEntityType entityType = OrmUtils.getDataEntityType(DesignEntityMeta.class);
        IDataEntityType menuType = OrmUtils.getDataEntityType(DesignAppMeta.class);
        HashMap<String, DynamicObject> matchKeyMap = new HashMap<String, DynamicObject>(64);
        if (!CollectionUtils.isEmpty(wordList)) {
            HashSet wordIds = new HashSet(16);
            HashSet<String> appIds = new HashSet<String>(16);
            appIds.add(appId);
            HashMap indexMap = new HashMap(64);
            HashMap indexWordMap = new HashMap(64);
            HashMap indexTypeMap = new HashMap(64);
            HashMap indexSubjectMap = new HashMap(64);
            try {
                wordList.forEach(v -> {
                    Long wordId = v.getLong("id");
                    wordIds.add(wordId);
                    String term = v.getString("termword");
                    Map<String, Future<Map<String, String>>> formMap = TermReplaceHelper.getResourceWithTerms(formIds, formType, term, lanNum);
                    Map<String, Future<Map<String, String>>> entityMap = TermReplaceHelper.getResourceWithTerms(entityIds, entityType, term, lanNum);
                    Map<String, Future<Map<String, String>>> appMap = TermReplaceHelper.getResourceWithTerms(appIds, menuType, term, lanNum);
                    formMap.forEach((subjectId, future) -> {
                        indexWordMap.put(wordId + AppWordTypeEnum.FORM.name() + subjectId, v);
                        indexTypeMap.put(wordId + AppWordTypeEnum.FORM.name() + subjectId, AppWordTypeEnum.FORM.name());
                        indexSubjectMap.put(wordId + AppWordTypeEnum.FORM.name() + subjectId, subjectId);
                        indexMap.put(wordId + AppWordTypeEnum.FORM.name() + subjectId, future);
                    });
                    entityMap.forEach((subjectId, future) -> {
                        indexWordMap.put(wordId + AppWordTypeEnum.ENTITY.name() + subjectId, v);
                        indexTypeMap.put(wordId + AppWordTypeEnum.ENTITY.name() + subjectId, AppWordTypeEnum.ENTITY.name());
                        indexSubjectMap.put(wordId + AppWordTypeEnum.ENTITY.name() + subjectId, subjectId);
                        indexMap.put(wordId + AppWordTypeEnum.ENTITY.name() + subjectId, future);
                    });
                    appMap.forEach((subjectId, future) -> {
                        indexWordMap.put(wordId + AppWordTypeEnum.MENU.name() + subjectId, v);
                        indexTypeMap.put(wordId + AppWordTypeEnum.MENU.name() + subjectId, AppWordTypeEnum.MENU.name());
                        indexSubjectMap.put(wordId + AppWordTypeEnum.MENU.name() + subjectId, subjectId);
                        indexMap.put(wordId + AppWordTypeEnum.MENU.name() + subjectId, future);
                    });
                });
                for (Map.Entry entry : indexMap.entrySet()) {
                    Map m = (Map)((Future)entry.getValue()).get();
                    if (CollectionUtils.isEmpty((Map)m)) continue;
                    DynamicObject wordObj = (DynamicObject)indexWordMap.get(entry.getKey());
                    String type = (String)indexTypeMap.get(entry.getKey());
                    String subjectId = (String)indexSubjectMap.get(entry.getKey());
                    m.forEach((key, wordComp) -> {
                        DynamicObject termWordComp = TermReplaceHelper.newTermWord(wordObj, appId, type, subjectId, key, wordComp, isFill);
                        matchKeyMap.put(appId + (String)entry.getKey() + key, termWordComp);
                    });
                }
                logger.info(String.format("wordIds = %s, matchKeyMap = %s", wordIds, matchKeyMap.keySet()));
            }
            catch (Exception e) {
                logger.error("getResourceWithTerms failed,", (Throwable)e);
            }
        }
        return matchKeyMap;
    }

    private static DynamicObject newTermWord(DynamicObject word, String appId, String type, String subjectId, String key, String wordComp, boolean isFill) {
        long fid = word.getLong("id");
        Object lanId = word.getDynamicObject(LAN_ID).getPkValue();
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"cts_termwordcomp");
        object.set(WORD_ID, (Object)fid);
        object.set(LAN_ID, lanId);
        object.set("wordcomp", (Object)wordComp);
        String termword = word.getString("termword");
        String termwordcust = word.getString("termwordcust");
        if (isFill && StringUtils.isNotBlank((CharSequence)termwordcust)) {
            object.set(WORDCOMPCUST, (Object)wordComp.replace(termword, termwordcust));
            object.set(WORDSTATUS, (Object)TermStatusEnum.PENDING_REPLACE.getCode());
        }
        object.set(APP_ID, (Object)appId);
        object.set("key", (Object)key);
        object.set("category", (Object)type);
        object.set("subjectid", (Object)subjectId);
        object.set("subjectcategory", (Object)"");
        object.set("enable", (Object)"1");
        object.set("status", (Object)"C");
        object.set("creatorid", (Object)RequestContext.get().getCurrUserId());
        object.set("createtime", (Object)TimeServiceHelper.now());
        return object;
    }

    private static Map<String, Future<Map<String, String>>> getResourceWithTerms(Set<String> ids, IDataEntityType iDataEntityType, String term, String lanNum) {
        HashMap<String, Future<Map<String, String>>> formIdMap = new HashMap<String, Future<Map<String, String>>>(64);
        if (!CollectionUtils.isEmpty(ids)) {
            ids.forEach(formId -> {
                if (StringUtils.isNotBlank((CharSequence)formId)) {
                    HashMap<String, String> map = new HashMap<String, String>(64);
                    map.put("masterId", (String)formId);
                    map.put("term", term);
                    map.put("lanNumber", lanNum);
                    formIdMap.put((String)formId, MatchTermWordCompThreadPool.executorService.submit(new Worker(new MatchLocaleMetaFunction(), iDataEntityType, map)));
                }
            });
        }
        return formIdMap;
    }

    public static Map<String, Map<String, Map<String, String>>> doResTermComps(List<TermWordCompEntity> dynamicObjects) {
        HashMap<String, Map<String, Map<String, String>>> resTermComps = new HashMap<String, Map<String, Map<String, String>>>(64);
        HashMap resTermCompsMaps = null;
        HashMap<String, String> termCompsMaps = null;
        for (TermWordCompEntity dynamicObject : dynamicObjects) {
            String category = dynamicObject.getCategory();
            String subjectid = dynamicObject.getSubjectid();
            String key = dynamicObject.getKey();
            String wordcompcust = dynamicObject.getWordcompcust();
            Map stringMapMap = (Map)resTermComps.get(category);
            if (stringMapMap != null) {
                Map stringStringMap = (Map)stringMapMap.get(subjectid);
                if (stringStringMap != null) {
                    stringStringMap.put(key, wordcompcust);
                    continue;
                }
                termCompsMaps = new HashMap(16);
                termCompsMaps.put(key, wordcompcust);
                stringMapMap.put(subjectid, termCompsMaps);
                continue;
            }
            resTermCompsMaps = new HashMap(16);
            termCompsMaps = new HashMap<String, String>(16);
            termCompsMaps.put(key, wordcompcust);
            resTermCompsMaps.put(subjectid, termCompsMaps);
            resTermComps.put(category, resTermCompsMaps);
        }
        return resTermComps;
    }

    public static List<DynamicObject> buildTermWordCompObject(Map<String, DynamicObject> oldKeyMap, Map<String, DynamicObject> matchKeyMap) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        if (CollectionUtils.isEmpty(matchKeyMap)) {
            return dynamicObjects;
        }
        matchKeyMap.forEach((index, newWordComp) -> {
            DynamicObject dynamicObject;
            DynamicObject dynamicObject1 = (DynamicObject)oldKeyMap.get(index);
            if (dynamicObject1 != null) {
                oldKeyMap.remove(index);
            }
            if ((dynamicObject = TermReplaceHelper.generateTermWordCompObject(newWordComp, dynamicObject1)) != null) {
                dynamicObjects.add(dynamicObject);
            }
        });
        return dynamicObjects;
    }

    private static DynamicObject generateTermWordCompObject(DynamicObject newWordComp, DynamicObject oldWordComp) {
        String wordcomp = newWordComp.getString("wordcomp");
        String wordcompcust = newWordComp.getString(WORDCOMPCUST);
        if (oldWordComp != null) {
            if (wordcomp.equals(oldWordComp.get("wordcomp")) && wordcompcust.equals(oldWordComp.get(WORDCOMPCUST))) {
                return null;
            }
            if (!StringUtils.isBlank((CharSequence)wordcompcust) && !wordcompcust.equals(oldWordComp.get(WORDCOMPCUST))) {
                oldWordComp.set("wordcomp", (Object)wordcomp);
                oldWordComp.set(WORDCOMPCUST, (Object)wordcompcust);
                oldWordComp.set(WORDSTATUS, (Object)TermStatusEnum.PENDING_REPLACE.getCode());
            }
            return oldWordComp;
        }
        return newWordComp;
    }

    public static List<TermWordCompEntity> getWordCompsByTermId(QFilter[] qFilters) {
        String selectFields = "id,wordid,appid,lanid, wordcomp, wordcompcust, key, category, subjectid, wordstatus";
        DynamicObjectCollection wordComps = QueryServiceHelper.query((String)"cts_termwordcomp", (String)selectFields, (QFilter[])qFilters);
        wordComps = wordComps.stream().filter(dy -> StringUtils.isNotBlank((CharSequence)dy.getString(WORDCOMPCUST))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        String toJsonString = SerializationUtils.toJsonString((Object)wordComps);
        return SerializationUtils.fromJsonStringToList((String)toJsonString, TermWordCompEntity.class);
    }

    public static void updateStatus(Object[] termIds, List<Long> pkIds, int code) {
        if (termIds != null && termIds.length > 0) {
            ArrayList list = new ArrayList();
            Map termword = BusinessDataServiceHelper.loadFromCache((Object[])termIds, (String)"cts_termword");
            termword.forEach((k, v) -> {
                if (code != v.getInt(WORDSTATUS)) {
                    if (code == 0) {
                        v.set("termwordcust", (Object)"");
                    }
                    v.set(WORDSTATUS, (Object)code);
                    list.add(v);
                }
            });
            if (!list.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
        }
        if (pkIds != null && !pkIds.isEmpty()) {
            TermReplaceHelper.updateTermWordCompStatus(pkIds, code);
        }
    }

    public static void updateTermWordCompStatus(List<Long> pkIds, int code) {
        if (pkIds == null || pkIds.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList();
        Map comp = BusinessDataServiceHelper.loadFromCache((Object[])pkIds.toArray(), (String)"cts_termwordcomp");
        comp.forEach((k, v) -> {
            if (code != v.getInt(WORDSTATUS)) {
                if (code == 0) {
                    v.set(WORDCOMPCUST, (Object)"");
                }
                v.set(WORDSTATUS, (Object)code);
                list.add(v);
            }
        });
        if (!list.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    public static void updateTermWordComp(DynamicObject[] objectList, String term, String newTerm) {
        for (DynamicObject obj : objectList) {
            String comp = obj.getString("wordcomp");
            obj.set(WORDCOMPCUST, (Object)comp.replace(term, newTerm));
            obj.set(WORDSTATUS, (Object)TermStatusEnum.PENDING_REPLACE.getCode());
        }
        SaveServiceHelper.update((DynamicObject[])objectList);
    }

    public static void updateTermWordComp(List<Long> pkIds, int code, String newComp) {
        if (pkIds == null || pkIds.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList();
        Map comp = BusinessDataServiceHelper.loadFromCache((Object[])pkIds.toArray(), (String)"cts_termwordcomp");
        comp.forEach((k, v) -> {
            v.set(WORDSTATUS, (Object)code);
            v.set(WORDCOMPCUST, (Object)newComp);
            list.add(v);
        });
        if (!list.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    public static void updateTermWordStatus(Long termId, Integer status, String termwordcust) {
        String selectProperties = "wordstatus, termwordcust";
        DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)termId, (String)"cts_termword", (String)selectProperties);
        if (termwordcust != null) {
            dataEntity.set("termwordcust", (Object)termwordcust);
        }
        if (status != null) {
            dataEntity.set(WORDSTATUS, (Object)status);
        }
        SaveServiceHelper.update((DynamicObject)dataEntity);
    }

    public static void refreshTermWordStatus(Object[] termIds) {
        QFilter compQFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        if (termIds != null && termIds.length > 0) {
            compQFilter.and(WORD_ID, "in", (Object)termIds);
        }
        DynamicObject[] comps = BusinessDataServiceHelper.load((String)"cts_termwordcomp", (String)"id,wordstatus,wordid,wordcomp,appid,wordcompcust", (QFilter[])compQFilter.toArray());
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        HashMap updateMap = new HashMap();
        Arrays.stream(comps).forEach(v -> {
            DynamicObject wordid = v.getDynamicObject(WORD_ID);
            if (wordid != null) {
                long termId = wordid.getLong("id");
                HashSet<String> wordStatus = (HashSet<String>)map.get(termId);
                if (wordStatus == null) {
                    wordStatus = new HashSet<String>();
                }
                wordStatus.add(v.getString(WORDSTATUS));
                map.put(termId, wordStatus);
            }
        });
        String replacedCode = String.valueOf(TermStatusEnum.REPLACED.getCode());
        String partialReplacedCode = String.valueOf(TermStatusEnum.PARTIAL_REPLACED.getCode());
        String pendingReplaceCode = String.valueOf(TermStatusEnum.PENDING_REPLACE.getCode());
        String defaultCode = String.valueOf(TermStatusEnum.DEFAULT.getCode());
        map.forEach((k, v) -> {
            if (v.remove(replacedCode)) {
                if (!v.isEmpty()) {
                    updateMap.put(k, partialReplacedCode);
                } else {
                    updateMap.put(k, replacedCode);
                }
            } else if (v.contains(pendingReplaceCode)) {
                updateMap.put(k, pendingReplaceCode);
            } else {
                updateMap.put(k, defaultCode);
            }
        });
        if (!updateMap.isEmpty() || termIds != null) {
            DynamicObject[] terms;
            QFilter termQFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            termQFilter.and("id", "in", termIds != null ? termIds : updateMap.keySet());
            DynamicObject[] dynamicObjectArray = terms = BusinessDataServiceHelper.load((String)"cts_termword", (String)"id,wordstatus", (QFilter[])termQFilter.toArray());
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject term;
                String code = (String)updateMap.get((term = dynamicObjectArray[i]).getLong("id"));
                term.set(WORDSTATUS, (Object)(code == null ? defaultCode : code));
            }
            SaveServiceHelper.save((DynamicObject[])terms);
        }
        TermReplaceHelper.updatePartialTermWordComps(comps);
    }

    private static void updatePartialTermWordComps(DynamicObject[] comps) {
        Map<String, List<DynamicObject>> map = Arrays.stream(comps).collect(Collectors.groupingBy(e -> e.getString("wordcomp") + (e.getDynamicObject(APP_ID) == null ? "" : e.getDynamicObject(APP_ID).getString("name"))));
        ArrayList partialList = new ArrayList();
        map.forEach((k, v) -> {
            boolean hasReplacedStatus = false;
            boolean hasNotReplacedStatus = false;
            for (DynamicObject dy : v) {
                if (TermStatusEnum.REPLACED.getCode() == dy.getInt(WORDSTATUS)) {
                    hasReplacedStatus = true;
                    continue;
                }
                hasNotReplacedStatus = true;
            }
            if (hasReplacedStatus && hasNotReplacedStatus) {
                DynamicObject dynamicObject = v.stream().filter(e -> TermStatusEnum.REPLACED.getCode() == e.getInt(WORDSTATUS)).findFirst().orElseGet(() -> (DynamicObject)v.get(0));
                v.forEach(e -> {
                    if (StringUtils.isBlank((CharSequence)e.getString(WORDCOMPCUST))) {
                        e.set(WORDCOMPCUST, (Object)dynamicObject.getString(WORDCOMPCUST));
                        e.set(WORDSTATUS, (Object)TermStatusEnum.PENDING_REPLACE.getCode());
                        partialList.add(e);
                    }
                });
            }
        });
        if (!partialList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])partialList.toArray(new DynamicObject[0]));
        }
    }

    public static void refreshTermWordCompStatus() {
        String defaultCode = String.valueOf(TermStatusEnum.DEFAULT.getCode());
        List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)"select fid,fwordcompcust from t_cts_termwordcomp where fenable = '1'", rs -> {
            ArrayList<Object[]> updateKeys = new ArrayList<Object[]>(16);
            while (rs.next()) {
                String fwordcompcust = rs.getString("fwordcompcust");
                if (!StringUtils.isBlank((CharSequence)fwordcompcust)) continue;
                long fid = rs.getLong("fid");
                updateKeys.add(new Object[]{defaultCode, fid});
            }
            return updateKeys;
        });
        if (!list.isEmpty()) {
            String sql = "update t_cts_termwordcomp set fwordstatus = ? WHERE fid = ?";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, (List)list);
        }
    }

    public static String buildCompKey(DynamicObject e) {
        return e.getDynamicObject(APP_ID).getPkValue().toString() + e.getDynamicObject(WORD_ID).getString("id") + e.getString("category") + e.getString("subjectid") + e.getString("key");
    }

    private static class MatchTermWordCompThreadPool {
        private static final ExecutorService executorService = ThreadPools.newExecutorService((String)"matchTermWordCompThreadPool", (int)10);

        private MatchTermWordCompThreadPool() {
        }
    }
}

