/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TermWordPresetHelper {
    private static final String TERMPRESETID = "termpresetid";
    private static final String TERMWORD = "termword";
    private static final String LANID = "lanid";
    private static final String CLOUDID = "cloudid";
    private static final String CLOUDS = "clouds";
    private static final String CTS_TERM_PRESET_DETAIL = "cts_term_preset_detail";
    private static final String DELIMITER = "__";
    private static final String OLDNAME = "oldname";
    private static final String ENABLE = "enable";
    private static final String ISSYSTEM = "issystem";
    private static final String STATUS = "status";
    private static final String TERMWORDCUST = "termwordcust";
    private static final String NEWNAME = "newname";
    private static final String PRESETDETAILID = "presetdetailid";

    public static void updateIndustryTerm(DynamicObject preset) {
        Long langId = preset.getLong("lanid.id");
        DynamicObjectCollection clouds = preset.getDynamicObjectCollection(CLOUDS);
        List cloudIds = clouds.stream().map(e -> e.getString(2)).collect(Collectors.toList());
        Map detail = BusinessDataServiceHelper.loadFromCache((String)CTS_TERM_PRESET_DETAIL, (QFilter[])new QFilter(TERMPRESETID, "=", preset.getPkValue()).toArray());
        QFilter qFilter = new QFilter(LANID, "=", (Object)langId).and(CLOUDID, "in", cloudIds);
        Map<String, List<DynamicObject>> collect = BusinessDataServiceHelper.loadFromCache((String)"cts_termword", (QFilter[])qFilter.toArray()).values().stream().collect(Collectors.groupingBy(v -> v.getDynamicObject(CLOUDID).getPkValue().toString() + DELIMITER + v.getString(TERMWORD)));
        ArrayList list = new ArrayList(10);
        ArrayList dupTermIdList = new ArrayList(10);
        detail.forEach((k, v) -> {
            for (String cloudId : cloudIds) {
                DynamicObject dynamicObject = null;
                String key = cloudId + DELIMITER + v.getString(OLDNAME);
                List duplicateTerms = (List)collect.get(key);
                boolean tt = true;
                if (null != duplicateTerms) {
                    Iterator iterator = duplicateTerms.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject term;
                        dynamicObject = term = (DynamicObject)iterator.next();
                        if (StringUtils.isEmpty((Object)term.getString("appid"))) {
                            tt = false;
                            dynamicObject.set(TERMWORDCUST, (Object)v.getString(NEWNAME));
                            dynamicObject.set(ISSYSTEM, (Object)Character.valueOf('1'));
                            dynamicObject.set(PRESETDETAILID, k);
                        } else {
                            dynamicObject.set(ENABLE, (Object)Character.valueOf('0'));
                            dynamicObject.set("disabler", (Object)RequestContext.get().getCurrUserId());
                            dynamicObject.set("disabletime", (Object)TimeServiceHelper.now());
                            dupTermIdList.add(dynamicObject.getPkValue());
                        }
                        list.add(dynamicObject);
                    }
                }
                if (null != duplicateTerms && !tt) continue;
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cts_termword");
                dynamicObject.set(TERMWORD, (Object)v.getString(OLDNAME));
                dynamicObject.set(TERMWORDCUST, (Object)v.getString(NEWNAME));
                dynamicObject.set(ENABLE, (Object)Character.valueOf('1'));
                dynamicObject.set(ISSYSTEM, (Object)Character.valueOf('1'));
                dynamicObject.set(STATUS, (Object)"C");
                dynamicObject.set(LANID, (Object)langId);
                dynamicObject.set(CLOUDID, (Object)cloudId);
                dynamicObject.set(PRESETDETAILID, k);
                list.add(dynamicObject);
            }
        });
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        if (!dupTermIdList.isEmpty()) {
            QFilter filter = new QFilter("wordid", "in", dupTermIdList);
            Map promptMap = BusinessDataServiceHelper.loadFromCache((String)"cts_termwordcomp", (QFilter[])filter.toArray());
            promptMap.values().forEach(e -> e.set(ENABLE, (Object)Character.valueOf('0')));
            SaveServiceHelper.update((DynamicObject[])promptMap.values().toArray(new DynamicObject[0]));
        }
    }
}

