/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper.preinsdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.enums.TermStatusEnum;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class RepairTermWordCompStatusServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(RepairTermWordCompStatusServiceImpl.class);
    private static final String REGEX = ",";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.repairHistoryData();
            result.setLog("repair TermWordComp Success.");
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error("repair TermWordComp fail", (Throwable)e);
            result.setErrorInfo("repair TermWordComp fail: " + e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private void repairHistoryData() {
        TermReplaceHelper.refreshTermWordCompStatus();
        RepairTermWordCompStatusServiceImpl.refreshTermWordStatus();
    }

    public static void refreshTermWordStatus() {
        HashSet<String> appids = new HashSet<String>(16);
        List comps = (List)DB.query((DBRoute)DBRoute.basedata, (String)"select fid,fwordstatus,fwordid,fwordcomp,fappid,fwordcompcust from t_cts_termwordcomp where fenable = '1'", rs -> {
            ArrayList<Object[]> updateKeys = new ArrayList<Object[]>(16);
            while (rs.next()) {
                long fid = rs.getLong("fid");
                String fwordstatus = rs.getString("fwordstatus");
                String fwordid = rs.getString("fwordid");
                String fwordcomp = rs.getString("fwordcomp");
                String fappid = rs.getString("fappid");
                String fwordcompcust = rs.getString("fwordcompcust");
                appids.add(fappid);
                updateKeys.add(new Object[]{fid, fwordstatus, fwordid, fwordcomp, fappid, fwordcompcust});
            }
            return updateKeys;
        });
        HashMap<Long, Set> map = new HashMap<Long, Set>(16);
        ArrayList updatelist = new ArrayList(16);
        comps.forEach(v -> {
            String termId = (String)v[2];
            if (termId != null) {
                Set wordStatus = map.getOrDefault(Long.parseLong(termId), new HashSet());
                wordStatus.add((String)v[1]);
                map.put(Long.parseLong(termId), wordStatus);
            }
        });
        String replacedCode = String.valueOf(TermStatusEnum.REPLACED.getCode());
        String partialReplacedCode = String.valueOf(TermStatusEnum.PARTIAL_REPLACED.getCode());
        String pendingReplaceCode = String.valueOf(TermStatusEnum.PENDING_REPLACE.getCode());
        String defaultCode = String.valueOf(TermStatusEnum.DEFAULT.getCode());
        map.forEach((k, v) -> {
            if (v.remove(replacedCode)) {
                if (!v.isEmpty()) {
                    updatelist.add(new Object[]{partialReplacedCode, k});
                } else {
                    updatelist.add(new Object[]{replacedCode, k});
                }
            } else if (v.contains(pendingReplaceCode)) {
                updatelist.add(new Object[]{pendingReplaceCode, k});
            } else {
                updatelist.add(new Object[]{defaultCode, k});
            }
        });
        if (!updatelist.isEmpty()) {
            String sql = "update t_cts_termword set fwordstatus = ? WHERE fid = ?";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, updatelist);
        }
        RepairTermWordCompStatusServiceImpl.updatePartialTermWordComps(comps, appids);
    }

    private static void updatePartialTermWordComps(List<Object[]> comps, Set<String> appIds) {
        HashMap appNameMap = new HashMap(16);
        if (appIds != null && !appIds.isEmpty()) {
            String sql = "select fid,fname from t_meta_bizapp_l  WHERE flocaleid='zh_CN' ";
            String paramStr = String.join((CharSequence)REGEX, Collections.nCopies(appIds.size(), "?"));
            sql = sql + String.format(" and fid in (%s)", paramStr);
            DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])appIds.toArray(), rs -> {
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    String fname = rs.getString("fname");
                    appNameMap.put(fid, fname);
                }
                return null;
            });
        }
        Map<String, List<Object[]>> map = comps.stream().collect(Collectors.groupingBy(e -> e[4] + (appNameMap.get((String)e[5]) == null ? "" : (String)e[5])));
        ArrayList partialList = new ArrayList();
        map.forEach((k, v) -> {
            boolean hasReplacedStatus = false;
            boolean hasNotReplacedStatus = false;
            for (Object[] dy : v) {
                if (TermStatusEnum.REPLACED.getCode() == Integer.parseInt((String)dy[1])) {
                    hasReplacedStatus = true;
                    continue;
                }
                hasNotReplacedStatus = true;
            }
            if (hasReplacedStatus && hasNotReplacedStatus) {
                Object[] dynamicObject = v.stream().filter(e -> TermStatusEnum.REPLACED.getCode() == Integer.parseInt((String)e[1])).findFirst().orElseGet(() -> (Object[])v.get(0));
                v.forEach(e -> {
                    if (StringUtils.isBlank((Object)e[5])) {
                        partialList.add(new Object[]{dynamicObject[5], String.valueOf(TermStatusEnum.PENDING_REPLACE.getCode()), e[0]});
                    }
                });
            }
        });
        if (!partialList.isEmpty()) {
            String sql = "update t_cts_termwordcomp set fwordcompcust = ?,fwordstatus = ? WHERE fid = ?";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, partialList);
        }
    }
}

