/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.helper.preinsdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class UpdateTermWordPreDataServiceImpl
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(UpdateTermWordPreDataServiceImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        LOGGER.info("\u672f\u8bed\u66ff\u6362\u811a\u672c\u6267\u884c\u5b8c\u6210\uff0c\u5f00\u59cb\u6267\u884c\u63d2\u4ef6\u5185\u903b\u8f91\u3002");
        try {
            String sql = "select fid, fcloudid, fappid from t_cts_termword";
            List termWords = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, resultSet -> {
                ArrayList result = new ArrayList(10);
                while (resultSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("fid", resultSet.getString("fid"));
                    map.put("fcloudid", resultSet.getString("fcloudid"));
                    map.put("fappid", resultSet.getString("fappid"));
                    result.add(map);
                }
                return result;
            });
            Set appIdSet = termWords.stream().map(termWord -> (String)termWord.get("fappid")).collect(Collectors.toSet());
            QFilter appIdFilter = new QFilter("id", "in", (Object)appIdSet.toArray());
            DynamicObject[] apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"bizcloud.id,id", (QFilter[])appIdFilter.toArray());
            Map<String, String> appId2CloudId = Arrays.stream(apps).collect(Collectors.toMap(app -> app.getString("id"), app -> app.getString("bizcloud.id")));
            String updateSql = "update t_cts_termword set fcloudid = ? where fappid = ?";
            appId2CloudId.forEach((appid, cloudid) -> {
                int updateResult = this.updateCloud(updateSql, cloudid, appid);
                LOGGER.info("{} -> {} \u66f4\u65b0\u7ed3\u679c\u4e3a\uff1a {}", new Object[]{appid, cloudid, updateResult});
            });
        }
        catch (Exception e) {
            LOGGER.error("\u672f\u8bed\u4e2d\u7684\u4e91\u66f4\u65b0\u5931\u8d25\u3002" + e.getMessage());
        }
        LOGGER.info("\u672f\u8bed\u4e2d\u7684\u4e91\u66f4\u65b0\u6210\u529f\uff01");
        return null;
    }

    private int updateCloud(String updateSql, Object ... params) {
        return DB.update((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])params);
    }
}

