/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.enums.TermStatusEnum;
import kd.bos.exception.KDException;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.BaseDataUtil;

public class ExtractTermWordTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ExtractTermWordTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Lang lang = RequestContext.get().getLang();
        String lanNum = lang != null ? lang.name() : "zh_CN";
        String lanId = BaseDataUtil.getLangIdByLanNum(lanNum);
        QFilter qFilter = new QFilter("lanid", "=", (Object)Long.parseLong(lanId)).and("wordstatus", "!=", (Object)String.valueOf(TermStatusEnum.REPLACING.getCode())).and("enable", "=", (Object)Character.valueOf('1'));
        Map words = BusinessDataServiceHelper.loadFromCache((String)"cts_termword", (String)"id, termword, termwordcust,cloudid, appid, lanid", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Map)words)) {
            return;
        }
        try {
            logger.info("ExtractTermWordTask task execute start");
            TermReplaceHelper.extractCompAndPrompt(words, lanId, 90, true, null);
            logger.info("ExtractTermWordTask task execute end");
        }
        catch (Exception e) {
            logger.error("ExtractTermWordTask task failed ", (Throwable)e);
        }
    }
}

