/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.task;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.enums.TermStatusEnum;
import kd.bos.exception.KDException;
import kd.bos.helper.TermReplaceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.BaseDataUtil;

public class TermWordReplaceTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(TermWordReplaceTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("wordstatus", "=", (Object)String.valueOf(TermStatusEnum.REPLACED.getCode()));
        Map terms = BusinessDataServiceHelper.loadFromCache((String)"cts_termword", (String)"id, termword, termwordcust, appid, lanid", (QFilter[])qFilter.toArray());
        if (!terms.isEmpty()) {
            String lanId = ((DynamicObject)terms.values().stream().findFirst().get()).getString("lanid");
            String lanNumber = BaseDataUtil.getLangNumByLanId(lanId);
            try {
                QFilter compQFilter = new QFilter("enable", "=", (Object)"1").and("wordstatus", "=", (Object)String.valueOf(TermStatusEnum.PENDING_REPLACE.getCode()));
                List<TermWordCompEntity> compDynamicObjects = TermReplaceHelper.getWordCompsByTermId(compQFilter.toArray());
                if (compDynamicObjects.isEmpty()) {
                    return;
                }
                compDynamicObjects = compDynamicObjects.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getWordcompcust())).collect(Collectors.toList());
                TermReplaceHelper.applyCompAndPrompt(compDynamicObjects, lanNumber, terms.keySet().toArray(), null, false);
            }
            catch (Exception e) {
                logger.error("TermWordReplaceTask task failed ", (Throwable)e);
            }
        }
    }
}

