/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class BaseDataUtil {
    private static final String DEFAULT_LAN_NUMBER = "zh_CN";
    private static final String NUMBER = "number";
    private static final String ID = "id";

    public static Map<String, String> getEnabledLanguage() {
        HashMap<String, String> lanId2Name = new HashMap<String, String>(10);
        List enabledLang = InteServiceHelper.getEnabledLang();
        if (enabledLang != null && !enabledLang.isEmpty()) {
            for (EnabledLang lang : enabledLang) {
                lanId2Name.put(lang.getId(), lang.getName());
            }
        }
        return lanId2Name;
    }

    public static String getLanguage() {
        return Lang.get().getLocale().toString();
    }

    public static String getLangNumByLanId(String lanId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"inte_language", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.parseLong(lanId))});
        return dynamicObject != null ? dynamicObject.getString(NUMBER) : DEFAULT_LAN_NUMBER;
    }

    public static String getLangIdByLanNum(String lanNum) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"inte_language", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)lanNum)});
        return dynamicObject != null ? dynamicObject.getString(ID) : "328738425610159104";
    }

    public static CommonFilterColumn customCommonFilterColumn(String filedName, String caption, List<ComboItem> comboItems, String defaultValue, boolean mustInput, boolean multi) {
        CommonFilterColumn column = new CommonFilterColumn(filedName);
        column.setType("enum");
        column.setCaption(new LocaleString(caption));
        column.setComboItems(comboItems);
        column.setMustInput(mustInput);
        column.setDefaultValue(defaultValue);
        column.setMulti(multi);
        return column;
    }

    public static String getResourceFileName(String number) {
        return number + "_" + "zh_CN.properties";
    }

    public static Map<String, String> getCloudIdByAppIds(Set<String> appIds) {
        HashMap<String, String> cloudId2AppIds = new HashMap<String, String>();
        for (String appId : appIds) {
            DynamicObject cloudByAppID = BizCloudServiceHelp.getBizCloudByAppID((String)appId);
            if (null == cloudByAppID) continue;
            String cloudId = cloudByAppID.getString(ID);
            cloudId2AppIds.put(appId, cloudId);
        }
        return cloudId2AppIds;
    }
}

