/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TermWordCompEntity;
import kd.bos.enums.AppWordTypeEnum;
import kd.bos.enums.TermWordLogTypeEnum;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class LogUtil {
    private static final Log logger = LogFactory.getLog(LogUtil.class);
    private static final String EMPTY = " ";
    private static final String WORD_ID = "wordid";
    private static final String TERMWORD_COMP = "termwordcomp";
    private static final String TERMWORD_COMP1 = "termwordComp";
    private static final String ID = "id";
    private static final String VERSION = "version";
    private static final String TYPE = "type";
    private static final String ENABLE = "enable";
    private static final String NAME = "name";
    private static final String CREATOR_ID = "creatorid";
    private static final String CREATE_TIME = "createtime";
    private static final String CTS_TERMWORD_APPLY_LOG = "cts_termwordapplylog";
    private static final String SOURCE_ID = "sourceid";
    private static final String SOURCE_NUMBER = "sourcenumber";
    private static final String APP_ID = "appid";
    private static final String CLOUD_ID = "cloudid";
    private static final String TERMWORD_LOG_ID = "termwordlogid";
    private static final String TERMWORD_COMP_ID = "termwordcompid";
    private static final String CTS_TERMWORD_COMP = "cts_termwordcomp";
    private static final String LAN_ID = "lanid";
    private static final String NEW_NAME = "newname";
    private static final String TERMWORD__COMP = "termwordComp";
    private static final String TERMWORD_ID = "termwordId";
    private static final String WORD_COMP = "wordcomp";
    private static final String CATEGORY = "category";

    private static void saveTermWordLog(Long id, Long termwordId, String termwordComp, TermWordLogTypeEnum type) {
        MainEntityType termWordLog = EntityMetadataCache.getDataEntityType((String)"cts_termwordlog");
        QFilter wordFilter = new QFilter(WORD_ID, "=", (Object)termwordId).and(TERMWORD_COMP, "=", (Object)termwordComp);
        DynamicObject object = new DynamicObject((DynamicObjectType)termWordLog);
        object.set(ID, (Object)id);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cts_termwordlog", (String)VERSION, (QFilter[])wordFilter.toArray(), (String)"createtime DESC", (int)1);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            object.set(VERSION, (Object)1);
        } else {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            object.set(VERSION, (Object)(Integer.parseInt(dynamicObject.get(VERSION).toString()) + 1));
        }
        object.set(WORD_ID, (Object)termwordId);
        object.set(TERMWORD_COMP, (Object)termwordComp);
        object.set(TYPE, (Object)type.getCode());
        object.set(ENABLE, (Object)"1");
        object.set(NAME, (Object)"1");
        object.set(CREATOR_ID, (Object)RequestContext.get().getCurrUserId());
        object.set(CREATE_TIME, (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    private static void saveTermWordApplyLog(Map<TermWordCompEntity, Long> applyLogMap) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)CTS_TERMWORD_APPLY_LOG);
        ArrayList<DynamicObject> termWordApplyLogList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<TermWordCompEntity, Long> entry : applyLogMap.entrySet()) {
            DynamicObject bizCloud;
            TermWordCompEntity compEntity = entry.getKey();
            Long termwordlogid = entry.getValue();
            DynamicObject dy = new DynamicObject((DynamicObjectType)entityType);
            dy.set(ID, (Object)kd.bos.id.ID.genLongId());
            dy.set(SOURCE_ID, (Object)compEntity.getSubjectid());
            DynamicObject termwordcompDy = BusinessDataServiceHelper.loadSingle((Object)compEntity.getId(), (String)CTS_TERMWORD_COMP);
            String category = EMPTY;
            if (termwordcompDy != null) {
                category = termwordcompDy.getString(CATEGORY);
            }
            if (AppWordTypeEnum.PROMPT.name().equals(category)) {
                dy.set(SOURCE_NUMBER, (Object)compEntity.getSubjectid());
            } else if (AppWordTypeEnum.MENU.name().equals(category)) {
                dy.set(SOURCE_NUMBER, (Object)"App/Menu");
            } else if (AppWordTypeEnum.FORM.name().equals(category) || AppWordTypeEnum.ENTITY.name().equals(category)) {
                String sourceNumber = MetadataDao.getNumberById((String)compEntity.getSubjectid());
                dy.set(SOURCE_NUMBER, (Object)sourceNumber);
            }
            dy.set(APP_ID, (Object)compEntity.getAppid());
            if (!StringUtils.isEmpty((String)compEntity.getAppid()) && (bizCloud = BizCloudServiceHelp.getBizCloudByAppID((String)compEntity.getAppid())) != null) {
                dy.set(CLOUD_ID, bizCloud.get(ID));
            }
            dy.set(NEW_NAME, (Object)compEntity.getWordcompcust());
            dy.set(TERMWORD_LOG_ID, (Object)termwordlogid);
            dy.set(TERMWORD_COMP_ID, (Object)compEntity.getId());
            if (termwordcompDy != null) {
                dy.set(LAN_ID, (Object)termwordcompDy.getLong(LAN_ID));
            }
            termWordApplyLogList.add(dy);
        }
        SaveServiceHelper.save((DynamicObject[])termWordApplyLogList.toArray(new DynamicObject[0]));
    }

    public static void addTermWordUpdateLog(Map<String, Map<String, Object>> logMap) {
        for (Map<String, Object> log : logMap.values()) {
            Long id = (Long)log.get(ID);
            Long termwordId = (Long)log.get(TERMWORD_ID);
            String termwordComp = (String)log.get("termwordComp");
            TermWordLogTypeEnum type = (TermWordLogTypeEnum)((Object)log.get(TYPE));
            LogUtil.saveTermWordLog(id, termwordId, termwordComp, type);
        }
    }

    public static void saveTermWordLogForReplaceOrRevert(List<TermWordCompEntity> compDynamicObjects, TermWordLogTypeEnum type) {
        try {
            if (compDynamicObjects == null || compDynamicObjects.size() == 0) {
                return;
            }
            HashMap<String, Map<String, Map<String, Object>>> logInfoMap = new HashMap<String, Map<String, Map<String, Object>>>(16);
            compDynamicObjects.forEach(res -> {
                Long termwordId = res.getWordid();
                String appId = res.getAppid();
                String wordComp = res.getWordcomp();
                String lanid = res.getLanid();
                HashMap<String, Object> log = new HashMap<String, Object>();
                log.put(ID, kd.bos.id.ID.genLongId());
                log.put(TERMWORD_ID, termwordId);
                log.put("termwordComp", wordComp);
                log.put(TYPE, (Object)type);
                HashMap wordCompMap = (HashMap)logInfoMap.get(appId);
                if (wordCompMap == null) {
                    wordCompMap = new HashMap();
                }
                wordCompMap.put(lanid + "/" + wordComp, log);
                logInfoMap.put(appId, wordCompMap);
            });
            logInfoMap.forEach((key, val) -> LogUtil.addTermWordUpdateLog(val));
            HashMap<TermWordCompEntity, Long> applyLogMap = new HashMap<TermWordCompEntity, Long>();
            for (TermWordCompEntity compEntity : compDynamicObjects) {
                LogUtil.addApplyLog(applyLogMap, compEntity, logInfoMap);
            }
            if (applyLogMap.size() != 0) {
                LogUtil.saveTermWordApplyLog(applyLogMap);
            }
        }
        catch (Exception e) {
            logger.error("save term log error, e:", (Throwable)e);
        }
    }

    private static void addApplyLog(Map<TermWordCompEntity, Long> applyLogMap, TermWordCompEntity compEntity, Map<String, Map<String, Map<String, Object>>> logInfoMap) {
        Long lanid;
        String key;
        Map<String, Object> logMap;
        String appid;
        Map<String, Map<String, Object>> appLogMap;
        DynamicObject app;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)compEntity.getId(), (String)CTS_TERMWORD_COMP, (String)"id,lanid,appid");
        if (dynamicObject != null && (app = dynamicObject.getDynamicObject(APP_ID)) != null && (appLogMap = logInfoMap.get(appid = app.getPkValue().toString())) != null && (logMap = appLogMap.get(key = (lanid = Long.valueOf(dynamicObject.getLong(LAN_ID))) + "/" + compEntity.getWordcomp())) != null) {
            compEntity.setAppid(appid);
            applyLogMap.put(compEntity, (Long)logMap.get(ID));
        }
    }
}

