/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MetadataUtil {
    private static final Log LOG = LogFactory.getLog(MetadataUtil.class);
    private static final String NUMBER = "number";
    private static final String FORM = "form";
    private static final String ITEM_TYPE = "itemtype";
    private static final String NAME = "Name";
    private static final String PROP_NAME = "propname";
    private static final String ID = "id";
    private static final String CTS_WORDENTRY = "cts_wordentry";
    private static final String BILL_NUMBER = "billnumber";
    private static final String VALUE = "value";
    private static final String FORM_ITEM_TYPE = "formitemtype";
    private static final String ENABLE = "enable";
    private static final String CTS_WORD_ITEMTYPE = "cts_word_itemtype";

    public static Object callInstanceMethod(String className, String methodName, Object obj, boolean isDec, Object[] param, Class<?> ... parameterTypes) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = null;
            method = isDec ? clazz.getDeclaredMethod(methodName, parameterTypes) : clazz.getMethod(methodName, parameterTypes);
            ReflectionUtils.makeAccessible((Method)method);
            return method.invoke(obj, param);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new HashMap();
        }
    }

    public static Object callConstructor(String className, Object[] param, Class<?> ... parameterTypes) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            Object object = constructor.newInstance(param);
            return object;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> getDetailData(String num) {
        Object obj = MetadataUtil.callConstructor("kd.bos.service.metadata.MultiLangMetadataLoad", null, new Class[0]);
        if (obj == null) {
            return new HashMap<String, Object>();
        }
        return (Map)MetadataUtil.callInstanceMethod("kd.bos.service.metadata.MultiLangMetadataLoad", "getDetailData", obj, true, new Object[]{num}, String.class);
    }

    public static void extractMetadata(String formNumber) {
        DynamicObject[] typeDyArray = BusinessDataServiceHelper.load((String)CTS_WORD_ITEMTYPE, (String)"", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")});
        Set typeSet = Arrays.stream(typeDyArray).map(dy -> dy.getString(NUMBER)).collect(Collectors.toSet());
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        Map<String, Object> map = MetadataUtil.getDetailData(formNumber);
        List item = (List)map.get(FORM);
        if (item != null) {
            DynamicObject[] inValidDyArray;
            HashSet<String> validIdList = new HashSet<String>();
            for (Map itemMap : item) {
                String itemType = (String)itemMap.get(ITEM_TYPE);
                if (!typeSet.contains(itemType) || !NAME.equals(itemMap.get(PROP_NAME))) continue;
                DynamicObject dy2 = null;
                String uniqueId = formId + "." + itemMap.get(ID);
                if (QueryServiceHelper.exists((String)CTS_WORDENTRY, (Object)uniqueId)) {
                    dy2 = BusinessDataServiceHelper.loadSingle((Object)uniqueId, (String)CTS_WORDENTRY);
                } else {
                    dy2 = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CTS_WORDENTRY));
                    dy2.set(ID, (Object)uniqueId);
                    dy2.set(BILL_NUMBER, (Object)formNumber);
                    dy2.set(NUMBER, (Object)uniqueId);
                    DynamicObject itemTypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)CTS_WORD_ITEMTYPE, (String)"", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)itemType)});
                    if (itemTypeDy != null) {
                        dy2.set(FORM_ITEM_TYPE, itemTypeDy.getPkValue());
                    }
                }
                dy2.set(NAME, (Object)LocaleString.fromMap((Map)((Map)itemMap.get(VALUE))));
                dy2.set(ENABLE, (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy2});
                validIdList.add(uniqueId);
            }
            QFilter billFilter = new QFilter(BILL_NUMBER, "=", (Object)formNumber);
            QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
            QFilter idFilter = new QFilter(ID, "not in", validIdList);
            for (DynamicObject dy3 : inValidDyArray = BusinessDataServiceHelper.load((String)CTS_WORDENTRY, (String)"id,enable", (QFilter[])new QFilter[]{billFilter, enableFilter, idFilter})) {
                dy3.set(ENABLE, (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])inValidDyArray);
        }
    }
}

