/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.upgradeservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ImageConfigDisableUpgradeServiceImpl
implements IUpgradeService {
    private static final int IMAGE_CONFIG_COUNT = 4;
    private static Map<String, String> preSetImageConfig = new HashMap<String, String>();
    private static final String QUERY_ALL_IMAGE_CONFIG_SQL = "select a.fid,a.fnumber,a.fenable,a.fimagesystermip,a.fimageport,a.fclientid,a.fclientsecret,a.fisrandom,b.fname,b.fsimplename,a.fexternalerpid,c.fnumber as erpnumber from t_bas_imageconfig a left join t_bas_imageconfig_l b on a.fid = b.fid and b.flocaleid = 'zh_CN' left join t_bas_extenderp c on a.fexternalerpid = c.fid";
    private static final String UPDATE_IMAGE_CONFIG_SQL = "update t_bas_imageconfig set fimagesystermip = ' ',fimageport = ' ',fclientid = ' ',fclientsecret = ' ',fenable = 'B'";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String algoKey = "ImageConfigDisableUpgradeServiceImpl";
        int count = 0;
        try (DataSet imageConfigInfo = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.base, (String)QUERY_ALL_IMAGE_CONFIG_SQL);){
            while (imageConfigInfo.hasNext()) {
                if (++count > preSetImageConfig.size()) {
                    imageConfigInfo.close();
                    result.setSuccess(false);
                    result.setLog(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u4e2a\u6570\u8d85\u51fa\u9884\u7f6e\u4e2a\u6570\uff0c\u4e0d\u8fdb\u884c\u6570\u636e\u5347\u7ea7", (String)"ImageConfigDisableUpgradeServiceImpl_0", (String)"bos-image-upgradeservice", (Object[])new Object[0]));
                } else {
                    Row imageConfig = imageConfigInfo.next();
                    String imageNumber = imageConfig.getString("fnumber");
                    String imageConfigStr = this.buildImageConfigStr(imageConfig);
                    String presetImageConfig = preSetImageConfig.get(imageNumber);
                    if (StringUtils.isBlank((CharSequence)presetImageConfig)) {
                        result.setSuccess(false);
                        result.setLog(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u65b0\u589e\u7684\u5f71\u50cf\u7cfb\u7edf%s\uff0c\u4e0d\u8fdb\u884c\u6570\u636e\u5347\u7ea7", (String)"ImageConfigDisableUpgradeServiceImpl_1", (String)"bos-image-upgradeservice", (Object[])new Object[0]), imageNumber));
                    } else {
                        if (StringUtils.equals((CharSequence)imageConfigStr, (CharSequence)presetImageConfig)) continue;
                        result.setSuccess(false);
                        result.setLog(String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u6570\u636e\u5df2\u6539\u52a8\uff0c\u4e0d\u8fdb\u884c\u6570\u636e\u5347\u7ea7\uff1a%s", (String)"ImageConfigDisableUpgradeServiceImpl_2", (String)"bos-image-upgradeservice", (Object[])new Object[0]), imageConfig));
                    }
                }
                break;
            }
        }
        if (!result.isSuccess()) {
            result.setSuccess(true);
            return result;
        }
        if (count != preSetImageConfig.size()) {
            result.setSuccess(true);
            result.setLog(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u4e2a\u6570\u4e0e\u9884\u7f6e\u6570\u636e\u4e0d\u5339\u914d\uff0c\u4e0d\u8fdb\u884c\u6570\u636e\u5347\u7ea7", (String)"ImageConfigDisableUpgradeServiceImpl_3", (String)"bos-image-upgradeservice", (Object[])new Object[0]));
            return result;
        }
        int update = DB.update((DBRoute)DBRoute.base, (String)UPDATE_IMAGE_CONFIG_SQL);
        if (update > 0) {
            result.setLog(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u6570\u636e\u5df2\u5347\u7ea7", (String)"ImageConfigDisableUpgradeServiceImpl_4", (String)"bos-image-upgradeservice", (Object[])new Object[0]));
        }
        result.setSuccess(true);
        return result;
    }

    private String buildImageConfigStr(Row imageConfig) {
        StringBuilder sb = new StringBuilder();
        sb.append(imageConfig.getLong("fid"));
        sb.append(imageConfig.getString("fnumber"));
        sb.append(imageConfig.getString("fenable"));
        sb.append(imageConfig.getString("fimagesystermip").replaceAll(" ", ""));
        sb.append(imageConfig.getString("fimageport").replaceAll(" ", ""));
        sb.append(imageConfig.getString("fclientid").replaceAll(" ", ""));
        sb.append(imageConfig.getString("fclientsecret").replaceAll(" ", ""));
        sb.append(imageConfig.getString("fexternalerpid"));
        sb.append(imageConfig.getString("erpnumber"));
        sb.append(imageConfig.getString("fisrandom"));
        sb.append(imageConfig.getString("fname"));
        return sb.toString();
    }

    static {
        preSetImageConfig.put("NGXHC", "1159228865441239040NGXHCB427215148743160832KDCC1KD");
        preSetImageConfig.put("GXHC", "1GXHCB0null1KD");
        preSetImageConfig.put("FPY", "861553024718362624FPYA1.1.1.18080427215148743160832KDCC1KD");
        preSetImageConfig.put("DKWS", "2DKWSB172.18.1.16980427215148743160832KDCC1KD");
    }
}

