/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ImageStrategyUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_STRATEGY_SQL = "select a.fid as id,a.flevel as priority,b.fpkid as orgEntryId,c.fpkid as billEntryId from t_bas_imagestrategy a left join t_bas_imastrategyorg b on a.fid = b.fid left join t_bas_imastrategybill c on a.fid = c.fid where a.fnumber != '001' ";
    private static final String UPDATE_SQL = "update t_bas_imagestrategy set flevel = ? where fid = ?";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        HashMap<Long, Boolean> fidOrgMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> fidBillMap = new HashMap<Long, Boolean>(16);
        DataSet imageStrategy = DB.queryDataSet((String)"ImageStrategyUpgrade_query", (DBRoute)DBRoute.base, (String)QUERY_STRATEGY_SQL);
        Object object = null;
        try {
            while (imageStrategy.hasNext()) {
                Row row = imageStrategy.next();
                Long fid = row.getLong("id");
                if (!fidOrgMap.containsKey(fid)) {
                    Long orgEntryId = row.getLong("orgEntryId");
                    fidOrgMap.put(fid, orgEntryId != 0L);
                }
                if (fidBillMap.containsKey(fid)) continue;
                Long billEntryId = row.getLong("billEntryId");
                fidBillMap.put(fid, billEntryId != 0L);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (imageStrategy != null) {
                if (object != null) {
                    try {
                        imageStrategy.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    imageStrategy.close();
                }
            }
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Map.Entry entry : fidOrgMap.entrySet()) {
            int level = 50;
            Long fid = (Long)entry.getKey();
            Boolean hasOrg = (Boolean)entry.getValue();
            Boolean hasBill = (Boolean)fidBillMap.get(fid);
            if (hasBill == null) {
                hasBill = Boolean.FALSE;
            }
            Object[] paramArr = new Object[2];
            if (hasOrg.booleanValue() && hasBill.booleanValue()) {
                level = 20;
            } else if (hasOrg.booleanValue()) {
                level = 30;
            } else if (hasBill.booleanValue()) {
                level = 40;
            }
            paramArr[0] = level;
            paramArr[1] = fid;
            params.add(paramArr);
        }
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.base, (String)UPDATE_SQL, params);
        }
        return upgradeResult;
    }
}

