/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.image.algo.CustomSortConcatAggFunction;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class InvoiceIndexFieldUpgradeServiceImp
implements IUpgradeService {
    private static final String QUERY_SQL_TRAIN = "select fid, concat(concat(finvoicekey, '='), finvoicevalue) as propmap from t_bas_invoicekey where (fid in (select fid from t_bas_invoice where finvoicetype = '9' and findexfield = ' ')) and finvoicekey in ('printingSequenceNo', 'trainNum', 'invoiceDate')";
    private static final String QUERY_SQL_AIRPLANE = "select fid, concat(concat(finvoicekey, '='), finvoicevalue) as propmap from t_bas_invoicekey where (fid in (select fid from t_bas_invoice where finvoicetype = '10' and findexfield = ' ')) and finvoicekey in ('electronicTicketNum', 'customerIdentityNum', 'printNum')";
    private static final String UPDATE_SQL = "update t_bas_invoice set findexfield = ? where fid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result;
        block76: {
            result = new UpgradeResult();
            String algoKey = "upgradeIndexFieldOfInvoice";
            try (DataSet dSetT = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.base, (String)QUERY_SQL_TRAIN);
                 DataSet dSetA = DB.queryDataSet((String)(algoKey + "_1"), (DBRoute)DBRoute.base, (String)QUERY_SQL_AIRPLANE);
                 DataSet resultSetT = dSetT.groupBy(new String[]{"fid"}).agg((CustomAggFunction)new CustomSortConcatAggFunction("pti", "|"), "propmap", "indexfield").finish();
                 DataSet resultSetA = dSetA.groupBy(new String[]{"fid"}).agg((CustomAggFunction)new CustomSortConcatAggFunction("ecp", "|"), "propmap", "indexfield").finish();
                 DataSet resultSet = resultSetT.union(resultSetA);){
                if (resultSet.hasNext()) {
                    ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                    for (Row r : resultSet) {
                        Object[] paramArr = new Object[]{r.getString("indexfield"), r.getLong("fid")};
                        params.add(paramArr);
                    }
                    try (TXHandle h = TX.requiresNew((String)"sys_image_invoice_update");){
                        try {
                            DB.executeBatch((DBRoute)DBRoute.base, (String)UPDATE_SQL, params);
                            result.setLog(String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u53d1\u7968\u6570\u636e\u6210\u529f\uff0c\u5171\u5347\u7ea7%s\u6761\u6570\u636e\u3002", (String)"InvoiceIndexFieldUpgradeServiceImp_0", (String)"bos-image-upgradeservice", (Object[])new Object[0]), params.size()));
                            result.setSuccess(true);
                        }
                        catch (Throwable e) {
                            h.markRollback();
                            result.setErrorInfo(e.getMessage());
                            result.setLog(ResManager.loadKDString((String)"\u5347\u7ea7\u53d1\u7968\u6570\u636e\u5931\u8d25\u3002", (String)"InvoiceIndexFieldUpgradeServiceImp_1", (String)"bos-image-upgradeservice", (Object[])new Object[0]));
                            result.setSuccess(false);
                        }
                        break block76;
                    }
                }
                result.setLog(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u8fdb\u884c\u5347\u7ea7\u7684\u53d1\u7968\u6570\u636e\u3002", (String)"InvoiceIndexFieldUpgradeServiceImp_2", (String)"bos-image-upgradeservice", (Object[])new Object[0]));
                result.setSuccess(true);
            }
        }
        return result;
    }
}

