/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.pojo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ImageInfo
implements Serializable {
    private static final Log log = LogFactory.getLog(ImageInfo.class);
    private static final long serialVersionUID = 8945516962561023580L;
    private String imageNo = "";
    private String billId = "";
    private String heterogeneid = "";
    private String billNo = "";
    private String creator = "";
    private String billtype = "";
    private String orgId = "";
    private String processingId = "";
    private String scanuserId = "";
    private String scanclientip = "";
    private Date createtime;
    private String imageState = "";
    private String operation = "";
    private String launch = "2";
    private String billData = "";
    private String imageScan = "1";
    private boolean isFillImageNo = true;
    private String imageNoFieldName = "";
    private String sourceSys;
    private String creatorAccount;
    private String creatorName;
    private String orgName;
    private String creatorPhone;
    private String billtypeName;
    private String erpUserName;
    private String imageId;
    private int uploadFlag = -1;
    private int electricAutoCommit = -1;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageScan() {
        return this.imageScan;
    }

    public void setImageScan(String imageScan) {
        this.imageScan = imageScan;
    }

    public String getBillData() {
        return this.billData;
    }

    public void setBillData(String billData) {
        this.billData = billData;
    }

    public String getImageNo() {
        return this.imageNo;
    }

    public String getProcessingId() {
        return this.processingId;
    }

    public void setProcessingId(String processingId) {
        this.processingId = processingId;
    }

    public String getScanuserId() {
        return this.scanuserId;
    }

    public void setScanuserId(String scanuserId) {
        this.scanuserId = scanuserId;
    }

    public String getImageState() {
        return this.imageState;
    }

    public void setImageState(String imageState) {
        this.imageState = imageState;
    }

    public String getScanclientip() {
        return this.scanclientip;
    }

    public Date getCreatetime() {
        return this.createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    public void setScanclientip(String scanclientip) {
        this.scanclientip = scanclientip;
    }

    public void setImageNo(String imageNo) {
        this.imageNo = imageNo;
    }

    public String getBillId() {
        return this.billId;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getBilltype() {
        return this.billtype;
    }

    public void setBilltype(String billtype) {
        this.billtype = billtype;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getLaunch() {
        return this.launch;
    }

    public void setLaunch(String launch) {
        this.launch = launch;
    }

    public boolean isFillImageNo() {
        return this.isFillImageNo;
    }

    public void setFillImageNo(boolean fillImageNo) {
        this.isFillImageNo = fillImageNo;
    }

    public String getImageNoFieldName() {
        return this.imageNoFieldName;
    }

    public void setImageNoFieldName(String imageNoFieldName) {
        this.imageNoFieldName = imageNoFieldName;
    }

    public String getSourceSys() {
        return this.sourceSys;
    }

    public void setSourceSys(String sourceSys) {
        this.sourceSys = sourceSys;
    }

    public String getCreatorAccount() {
        return this.creatorAccount;
    }

    public void setCreatorAccount(String creatorAccount) {
        this.creatorAccount = creatorAccount;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getCreatorPhone() {
        return this.creatorPhone;
    }

    public void setCreatorPhone(String creatorPhone) {
        this.creatorPhone = creatorPhone;
    }

    public String getBilltypeName() {
        return this.billtypeName;
    }

    public void setBilltypeName(String billtypeName) {
        this.billtypeName = billtypeName;
    }

    public String getErpUserName() {
        return this.erpUserName;
    }

    public void setErpUserName(String erpUserName) {
        this.erpUserName = erpUserName;
    }

    public String getHeterogeneid() {
        return this.heterogeneid;
    }

    public void setHeterogeneid(String heterogeneid) {
        this.heterogeneid = heterogeneid;
    }

    public String toString() {
        return "ImageInfo{imageNo='" + this.imageNo + '\'' + ", billId='" + this.billId + '\'' + ", billNo='" + this.billNo + '\'' + ", heterogeneid='" + this.heterogeneid + '\'' + ", creator='" + this.creator + '\'' + ", billtype='" + this.billtype + '\'' + ", orgId='" + this.orgId + '\'' + ", processingId='" + this.processingId + '\'' + ", scanuserId='" + this.scanuserId + '\'' + ", scanclientip='" + this.scanclientip + '\'' + ", createtime=" + this.createtime + ", imageState='" + this.imageState + '\'' + ", operation='" + this.operation + '\'' + ", launch='" + this.launch + '\'' + ", billData='" + this.billData + '\'' + ", imageScan='" + this.imageScan + '\'' + ", isFillImageNo=" + this.isFillImageNo + ", imageNoFieldName='" + this.imageNoFieldName + '\'' + ", sourceSys='" + this.sourceSys + '\'' + ", creatorAccount='" + this.creatorAccount + '\'' + ", creatorName='" + this.creatorName + '\'' + ", orgName='" + this.orgName + '\'' + ", billtypeName='" + this.billtypeName + '\'' + ", erpUserName='" + this.erpUserName + '\'' + '}';
    }

    public static List<ImageInfo> buildImageInfoListByBillDatas(@NotNull DynamicObject[] billDatas, @NotNull Map<String, String> imageServiceConfig, String billType) {
        ArrayList<ImageInfo> imageInfoList = new ArrayList<ImageInfo>(billDatas.length);
        ArrayList<Long> userIdList = new ArrayList<Long>(billDatas.length);
        String billno = imageServiceConfig.get("billno");
        String applier = imageServiceConfig.get("applier");
        String imagenumber = imageServiceConfig.get("imagenumber");
        String imagestatus = imageServiceConfig.get("imagestatus");
        String company = imageServiceConfig.get("company");
        String imageScan = imageServiceConfig.get("isimagescan");
        String heterogeneidField = imageServiceConfig.get("heterogeneid");
        String billTypeName = ImageInfo.getBillTypeName(billType);
        String uploadFlag = imageServiceConfig.get("uploadflag");
        String electricAutoCommit = imageServiceConfig.get("electricautocommit");
        String NEED_UPLOAD_IMAGE = "1";
        for (DynamicObject billData : billDatas) {
            String billid = billData.getPkValue().toString();
            ImageInfo imageInfo = new ImageInfo();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{heterogeneidField}) && billData.containsProperty(heterogeneidField)) {
                imageInfo.setHeterogeneid(billData.getString(heterogeneidField));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{imagenumber}) && billData.containsProperty(imagenumber)) {
                imageInfo.setImageNo(billData.getString(imagenumber));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{imagestatus}) && billData.containsProperty(imagestatus)) {
                String imageStatusValue = billData.getString(imagestatus);
                if (StringUtils.isBlank((CharSequence)imageStatusValue)) {
                    imageStatusValue = "0";
                }
                imageInfo.setImageState(imageStatusValue);
            }
            imageInfo.setBillId(billid);
            imageInfo.setBillNo(billData.getString(billno));
            imageInfo.setBilltype(billType);
            imageInfo.setBilltypeName(billTypeName);
            imageInfo.setBillData(imageServiceConfig.toString());
            if (imageScan != null && !"".equals(imageScan)) {
                Object imageScanField = billData.get(imageScan);
                if (imageScanField != null && !"".equals(imageScanField)) {
                    imageInfo.setImageScan(String.valueOf(imageScanField));
                } else {
                    imageInfo.setImageScan(NEED_UPLOAD_IMAGE);
                }
            } else {
                imageInfo.setImageScan(NEED_UPLOAD_IMAGE);
            }
            try {
                imageInfo.setOrgId(billData.getDynamicObject(company).getPkValue().toString());
                imageInfo.setOrgName(billData.getDynamicObject(company).getString("name"));
            }
            catch (Exception e1) {
                imageInfo.setOrgId(billData.getString(company));
            }
            try {
                Long userId = (Long)billData.getDynamicObject(applier).getPkValue();
                userIdList.add(userId);
                imageInfo.setCreator(String.valueOf(userId));
            }
            catch (Exception e) {
                imageInfo.setCreator(billData.getString(applier));
            }
            if (StringUtils.isNotBlank((CharSequence)uploadFlag)) {
                try {
                    boolean canHandUpImage = billData.getBoolean(uploadFlag);
                    imageInfo.setUploadFlag(canHandUpImage ? 0 : 1);
                }
                catch (Exception e) {
                    log.info("\u8bfb\u53d6\u5355\u636euploadFlag\u6620\u5c04\u5b57\u6bb5\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)electricAutoCommit)) {
                try {
                    boolean canAutoCommit = billData.getBoolean(electricAutoCommit);
                    imageInfo.setElectricAutoCommit(canAutoCommit ? 0 : 1);
                }
                catch (Exception e) {
                    log.info("\u8bfb\u53d6\u5355\u636eelectricAutoCommit\u6620\u5c04\u5b57\u6bb5\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
            imageInfoList.add(imageInfo);
        }
        if (userIdList.size() > 0) {
            Object[] userIdArray = userIdList.toArray(new Long[0]);
            Map bosUserMap = BusinessDataServiceHelper.loadFromCache((Object[])userIdArray, (String)"bos_user");
            for (ImageInfo imageInfo : imageInfoList) {
                try {
                    Long creator = Long.valueOf(imageInfo.getCreator());
                    if (!userIdList.contains(creator)) continue;
                    DynamicObject userObj = (DynamicObject)bosUserMap.get(creator);
                    imageInfo.setCreatorName(userObj.getString("name"));
                    imageInfo.setCreatorPhone(userObj.getString("phone"));
                    imageInfo.setErpUserName(userObj.getString("username"));
                }
                catch (Exception e) {
                    log.info(imageInfo + "\u6784\u5efa\u5904\u7406\u4eba\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
        return imageInfoList;
    }

    public int getUploadFlag() {
        return this.uploadFlag;
    }

    public void setUploadFlag(int uploadFlag) {
        this.uploadFlag = uploadFlag;
    }

    public int getElectricAutoCommit() {
        return this.electricAutoCommit;
    }

    public void setElectricAutoCommit(int electricAutoCommit) {
        this.electricAutoCommit = electricAutoCommit;
    }

    public static DynamicObject covertImageInfo(ImageInfo imageInfo, String imageNumber) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_billimagemap");
        DynamicObject obj = new DynamicObject((DynamicObjectType)type);
        obj.set("billid", (Object)imageInfo.getBillId());
        obj.set("billnumber", (Object)imageInfo.getBillNo());
        obj.set("billtype", (Object)imageInfo.getBilltype());
        obj.set("imagestate", (Object)(StringUtils.isNotBlank((CharSequence)imageInfo.getImageState()) ? imageInfo.getImageState() : "0"));
        obj.set("creator", (Object)imageInfo.getCreator());
        obj.set("modifier", (Object)imageInfo.getCreator());
        obj.set("billfieldmap", (Object)imageInfo.getBillData());
        obj.set("creatororgid", (Object)imageInfo.getOrgId());
        obj.set("heterogeneid", (Object)imageInfo.getHeterogeneid());
        obj.set("billtype", (Object)imageInfo.getBilltype());
        obj.set("imagenumber", (Object)imageNumber);
        Date now = new Date();
        obj.set("createtime", (Object)now);
        obj.set("modifytime", (Object)now);
        obj.set("needimagescan", (Object)imageInfo.getImageScan());
        obj.set("sourcesys", (Object)(imageInfo.getSourceSys() == null ? "KDCC" : imageInfo.getSourceSys()));
        obj.set("orgname", (Object)imageInfo.getOrgName());
        obj.set("creatoraccount", (Object)imageInfo.getCreatorAccount());
        obj.set("creatorname", (Object)imageInfo.getCreatorName());
        obj.set("heterogeneid", (Object)imageInfo.getHeterogeneid());
        return obj;
    }

    private static String getBillTypeName(String billType) {
        try {
            QFilter filter = new QFilter("number", "=", (Object)billType);
            DynamicObject billTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{filter});
            return billTypeObj.getString("name");
        }
        catch (Exception e1) {
            return "";
        }
    }
}

