/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.bizrule.OpBizRule;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.image.pojo.NoticeImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.image.ImageServiceNewHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ImageServiceOpAction
extends AbstractOpBizRuleAction {
    public static final String SAVE_OP = "1";
    public static final String SUBMIT_OP = "2";
    public static final String DELETE_OP = "3";
    public static final String UNSUBMIT_OP = "4";
    public static final String DISCARD_OP = "5";
    public static final String SYN = "1";
    public static final String ASYN = "2";
    private static final Log log = LogFactory.getLog(ImageServiceOpAction.class);

    /*
     * WARNING - void declaration
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] billDatas = e.getDataEntities();
        OpBizRule bizRule = this.getBizRule();
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        log.info("endOperationTransaction-\u5f71\u50cf\u670d\u52a1\u914d\u7f6e \uff1a" + bizRule.getParameter());
        String operation = (String)params.get("operation");
        if ("1".equals(operation) || "2".equals(operation)) {
            String isAsyn = (String)params.get("isasyn");
            String imagenumberKey = (String)params.get("imagenumber");
            boolean isFillImageNo = StringUtils.isNotEmpty((String)imagenumberKey);
            String billType = billDatas[0].getDataEntityType().getName();
            List imageInfoList = ImageInfo.buildImageInfoListByBillDatas((DynamicObject[])billDatas, (Map)params, (String)billType);
            HashMap<String, Object> billIdImageNoMap = new HashMap<String, Object>();
            if (imageInfoList.size() == 1 || "1".equals(isAsyn)) {
                for (Object imageInfo : imageInfoList) {
                    void var14_14;
                    Object var14_15 = null;
                    try {
                        String string = ImageServiceHelper.createImageInfo((ImageInfo)imageInfo);
                    }
                    catch (Exception e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                    if (!StringUtils.isNotEmpty((String)var14_14)) continue;
                    billIdImageNoMap.put(imageInfo.getBillId(), var14_14);
                    log.info("\u540c\u6b65\u65b9\u5f0f\u6210\u529f\u751f\u6210\u5f71\u50cf\u7f16\u7801 \uff1a" + (String)var14_14);
                }
            } else {
                Map imageInfoBatch = ImageServiceHelper.createImageInfoBatch((List)imageInfoList);
                for (Map.Entry entry : imageInfoBatch.entrySet()) {
                    String billId = (String)entry.getKey();
                    String imageNumber = ((ImageInfo)entry.getValue()).getImageNo();
                    billIdImageNoMap.put(billId, imageNumber);
                }
            }
            if (isFillImageNo) {
                ArrayList<Long> pkIds = new ArrayList<Long>(billDatas.length);
                for (DynamicObject billInfo : billDatas) {
                    pkIds.add((Long)billInfo.getPkValue());
                }
                DynamicObject[] billInfos = BusinessDataServiceHelper.load((String)billType, (String)("id," + imagenumberKey), (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                if (billInfos != null && billInfos.length > 0) {
                    for (DynamicObject billInfo : billInfos) {
                        billInfo.set(imagenumberKey, billIdImageNoMap.get(billInfo.getString("id")));
                    }
                    SaveServiceHelper.update((DynamicObject[])billInfos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] billDatas = e.getDataEntities();
        int billDatasLength = billDatas.length;
        if (billDatasLength <= 0) {
            log.info("\u5f71\u50cf\u7f16\u7801\u521b\u5efa\u4e0e\u5220\u9664\u670d\u52a1dataEntities\u7684size\u4e3a0");
            return;
        }
        OpBizRule bizRule = this.getBizRule();
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        log.info("\u5f71\u50cf\u670d\u52a1\u914d\u7f6e \uff1a" + bizRule.getParameter());
        String operation = (String)params.get("operation");
        if (DELETE_OP.equals(operation)) {
            if (billDatasLength == 1) {
                ImageInfo queryParam = new ImageInfo();
                String billId = billDatas[0].getPkValue().toString();
                queryParam.setBillId(billId);
                ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)queryParam);
                if (imageInfoInside == null) {
                    log.info(billId + "\u672a\u67e5\u8be2\u5230\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u5220\u9664");
                    return;
                }
                try (TXHandle h = TX.requiresNew();){
                    try {
                        ImageServiceHelper.deleteImage((String)imageInfoInside.getImageNo(), (String)RequestContext.get().getUserName(), null);
                    }
                    catch (Exception e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                        h.markRollback();
                    }
                }
            } else {
                ArrayList<String> billIds = new ArrayList<String>(billDatasLength);
                for (DynamicObject billData : billDatas) {
                    String billId = billData.getPkValue().toString();
                    billIds.add(billId);
                }
                Map billImageInfoMap = ImageServiceNewHelper.getImageInfoInsideBatch(billIds, (String)"billid");
                if (billImageInfoMap == null) {
                    log.info("\u6279\u91cf\u5220\u9664\u5f71\u50cf\uff0c\u672a\u627e\u5230\u5f71\u50cf\u6570\u636e");
                    return;
                }
                ArrayList deleteImageInfoList = new ArrayList(billImageInfoMap.size());
                billImageInfoMap.forEach((key, value) -> deleteImageInfoList.add(value));
                try (MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.imageplatform.service.asynDeleteImage");){
                    String jsonMassage = JSONUtils.toString(deleteImageInfoList);
                    pub.publish(jsonMassage);
                }
            }
        } else if (DISCARD_OP.equals(operation)) {
            if (billDatasLength == 1) {
                ImageInfo queryParam = new ImageInfo();
                String billId = billDatas[0].getPkValue().toString();
                queryParam.setBillId(billId);
                ImageInfo imageInfoInside = ImageServiceHelper.getImageInfoInside((ImageInfo)queryParam);
                if (imageInfoInside != null) {
                    try (TXHandle h = TX.requiresNew();){
                        try {
                            NoticeImageInfo noticeImageInfo = new NoticeImageInfo();
                            noticeImageInfo.setImageNo(imageInfoInside.getImageNo());
                            noticeImageInfo.setUserId(RequestContext.get().getUserId());
                            noticeImageInfo.setBillId(billId);
                            ImageServiceHelper.discardImage((NoticeImageInfo)noticeImageInfo);
                        }
                        catch (Exception e1) {
                            log.error(e1.getMessage(), (Throwable)e1);
                            h.markRollback();
                        }
                    }
                }
            } else {
                ArrayList<String> billIds = new ArrayList<String>(billDatasLength);
                for (DynamicObject billData : billDatas) {
                    String billId = billData.getPkValue().toString();
                    billIds.add(billId);
                }
                ImageServiceNewHelper.batchDiscardImage(billIds);
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        OpBizRule bizRule = this.getBizRule();
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        for (String value : params.values()) {
            if (!StringUtils.isNotEmpty((String)value)) continue;
            fieldKeys.add(value);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        OpBizRule bizRule = this.getBizRule();
        log.info("\u5355\u636e\u63d2\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c\u5f71\u50cf\u4e1a\u52a1\u56de\u6eda");
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        log.info("rollbackOperation-\u8bfb\u53d6\u5f71\u50cf\u670d\u52a1\u914d\u7f6e \uff1a" + bizRule.getParameter());
        String operation = (String)params.get("operation");
        if ("1".equals(operation) || "2".equals(operation)) {
            for (DynamicObject dynamicObject : e.getDataEntitys()) {
                DynamicObject billImageMap;
                Long fid = dynamicObject.getLong("id");
                String billNoKey = (String)params.get("billno");
                String billNo = dynamicObject.getString(billNoKey);
                boolean fromDataBase = dynamicObject.getDataEntityState().getFromDatabase();
                log.info(billNo + "\u53d1\u751f\u4e86\u56de\u6eda\uff0c fromDataBase = " + fromDataBase);
                if (fromDataBase || (billImageMap = QueryServiceHelper.queryOne((String)"task_billimagemap", (String)"imagenumber", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)String.valueOf(fid))})) == null) continue;
                String imageNo = billImageMap.getString("imagenumber");
                ImageServiceHelper.deleteImage((String)imageNo, (String)RequestContext.get().getUserName(), null);
            }
        }
    }
}

