/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.formplugin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import kd.bos.cache.BosImageDistributeSessionCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.image.util.ImageLicenseUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ImageConfigListPlugin
extends AbstractListPlugin
implements ClickListener,
IConfirmCallBack {
    private static final String TABLE_BAS_IMAGECONFIG = "bas_imageconfig";
    private static final String DYNAMIC_PROPERTY_ENABLE = "enable";
    private static final String SYS_NUMBER = "FPY";
    private static final int TIME_OUT = 3000;
    private static final Log log = LogFactory.getLog(ImageConfigListPlugin.class);
    private static final Set<String> DEFAULT_IMG_SYS = new HashSet<String>(4);
    private static final Set<String> NO_NEED_LICENSE_IMG_SYS = new HashSet<String>(2);

    public void initialize() {
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("modifytime desc");
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing".equals(operateKey)) {
            this.enableImageSystem();
            BosImageDistributeSessionCache.remove("enableImgSys");
            BosImageDistributeSessionCache.remove("hasEnableImgSys");
        } else if ("disable".equals(operateKey)) {
            BosImageDistributeSessionCache.remove("enableImgSys");
            BosImageDistributeSessionCache.remove("hasEnableImgSys");
        }
    }

    private void enableImageSystem() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        ORM orm = ORM.create();
        DynamicObjectCollection imageSystems = orm.getByFilter(TABLE_BAS_IMAGECONFIG, null);
        if (imageSystems.size() == 1) {
            for (DynamicObject imageSysInfo : imageSystems) {
                imageSysInfo.set(DYNAMIC_PROPERTY_ENABLE, (Object)"A");
            }
            orm.update((List)imageSystems);
            this.getView().updateView();
        }
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u9879", (String)"ImageConfigListPlugin_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"ImageConfigListPlugin_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() == 1) {
            LicenseCheckResult result;
            boolean haslic;
            ListSelectedRow selectedRow = selectedRows.get(0);
            long id = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject imageSysInfo = this.getImageSysInfoById(id);
            if (imageSysInfo == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5f71\u50cf\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25\uff01\u5f71\u50cf\u7cfb\u7edf\uff1a%1$s", (String)"ImageConfigListPlugin_2", (String)"bos-image-formplugin", (Object[])new Object[0]), id));
                return;
            }
            String imgSysNumber = imageSysInfo.getString("number");
            if (!NO_NEED_LICENSE_IMG_SYS.contains(imgSysNumber) && !(haslic = (result = ImageLicenseUtils.getLicenseCheckResult4New()).getHasLicense().booleanValue())) {
                String licParameter = result.getCancelFormShowParameter();
                if (licParameter != null) {
                    this.getView().showForm(FormShowParameter.fromJsonString((String)licParameter));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8d2d\u4e70\u5f71\u50cf\u670d\u52a1\u7684\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ImageConfigListPlugin_5", (String)"bos-image-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            String enableValue = (String)imageSysInfo.get(DYNAMIC_PROPERTY_ENABLE);
            if ("A".equals(enableValue)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5f71\u50cf\u7cfb\u7edf\u5df2\u542f\u7528", (String)"ImageConfigListPlugin_3", (String)"bos-image-formplugin", (Object[])new Object[0]));
            } else if (!this.printTest(imageSysInfo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f71\u50cf\u670d\u52a1\u5668\u65e0\u6cd5\u8bbf\u95ee\uff0c\u542f\u7528\u5931\u8d25", (String)"ImageConfigListPlugin_6", (String)"bos-image-formplugin", (Object[])new Object[0]));
            } else {
                this.setAllDisable();
                this.setSelectedEnable(id);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8be5\u5f71\u50cf\u7cfb\u7edf\u542f\u7528\u6210\u529f", (String)"ImageConfigListPlugin_4", (String)"bos-image-formplugin", (Object[])new Object[0]));
                this.getView().updateView();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        int result;
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        long selectRowId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        if (e.getCallBackId().equals("callBackId") && (result = e.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            this.setAllDisable();
            this.setSelectedEnable(selectRowId);
            this.getView().updateView();
        }
    }

    private DynamicObject getImageSysInfoById(long id) {
        DynamicObject ImageSysInfo2 = null;
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)TABLE_BAS_IMAGECONFIG, (String)"number,enable, imagesystermip, imageport", (QFilter[])qFilters);
        if (dynamicObjects.size() > 0) {
            ImageSysInfo2 = (DynamicObject)dynamicObjects.get(0);
        }
        return ImageSysInfo2;
    }

    private void setAllDisable() {
        ORM orm = ORM.create();
        DynamicObjectCollection imageSystems = orm.getByFilter(TABLE_BAS_IMAGECONFIG, null);
        for (DynamicObject imageSysInfo : imageSystems) {
            imageSysInfo.set(DYNAMIC_PROPERTY_ENABLE, (Object)"B");
        }
        orm.update((List)imageSystems);
    }

    private void setSelectedEnable(long id) {
        ORM orm = ORM.create();
        DynamicObject imageSysInfo = orm.getById(TABLE_BAS_IMAGECONFIG, (Object)id);
        Timestamp modifyTime = new Timestamp(System.currentTimeMillis());
        imageSysInfo.set(DYNAMIC_PROPERTY_ENABLE, (Object)"A");
        imageSysInfo.set("modifytime", (Object)modifyTime);
        orm.update(imageSysInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean printTest(DynamicObject imageconfig) {
        String number = imageconfig.getString("number");
        if (!DEFAULT_IMG_SYS.contains(number)) {
            return true;
        }
        String imagesystermip = imageconfig.getString("imagesystermip");
        String imageport = imageconfig.getString("imageport");
        if (StringUtils.isEmpty((String)imagesystermip) || StringUtils.isEmpty((String)imageport)) {
            return false;
        }
        Socket socket = null;
        try {
            socket = SSLSocketFactory.getDefault().createSocket();
            socket.connect(new InetSocketAddress(imagesystermip, Integer.parseInt(imageport)), 3000);
        }
        catch (Exception e) {
            log.warn("\u8fde\u63a5\u5f71\u50cf\u7cfb\u7edf\u5931\u8d25\uff1a" + e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                log.error("\u5173\u95edsocket\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    static {
        DEFAULT_IMG_SYS.add(SYS_NUMBER);
        DEFAULT_IMG_SYS.add("DKWS");
        DEFAULT_IMG_SYS.add("GXHC");
        DEFAULT_IMG_SYS.add("NGXHC");
        DEFAULT_IMG_SYS.add("DKWS_LINUX");
        NO_NEED_LICENSE_IMG_SYS.add(SYS_NUMBER);
        NO_NEED_LICENSE_IMG_SYS.add("IMC");
    }
}

