/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.formplugin.process;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.BosImageDistributeSessionCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.image.pojo.ImageErrorInfo;
import kd.bos.imageplatform.helper.NoticeImageSysFactory;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ImageErrorInfoRetryProcess
implements Runnable {
    private static final Log log = LogFactory.getLog(ImageErrorInfoRetryProcess.class);
    private final String taskId;
    private final int batchCount;
    private final List<ImageErrorInfo> errorInfos;
    private final List<String> existImageNumberList;
    private static final String TAG_DELRETRY = "TAG_OPERATION_DELRETRY";

    public ImageErrorInfoRetryProcess(String taskId, int batchCount, List<ImageErrorInfo> errorInfos, List<String> existImageNumberList) {
        this.taskId = taskId;
        this.batchCount = batchCount;
        this.errorInfos = errorInfos;
        this.existImageNumberList = existImageNumberList;
    }

    @Override
    public void run() {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            ImageErrorInfoRetryProcess.setInterruption(this.taskId, true);
            log.error("BatchAllocateTaskException:" + e.getMessage(), (Throwable)e);
        }
        finally {
            ImageErrorInfoRetryProcess.setFinished(this.taskId, true);
        }
    }

    private void doExecute() {
        List imageIds;
        QFilter filter;
        DynamicObject[] errorInfoArray;
        List<ImageErrorInfo> ids;
        int seq;
        int totalCount = this.errorInfos.size();
        int times = totalCount / this.batchCount + 1;
        int finishCount = seq * this.batchCount;
        for (seq = ImageErrorInfoRetryProcess.getBatchSeq(this.taskId); seq < times && !(ids = this.getCurrIds(seq)).isEmpty(); ++seq) {
            try {
                this.deleteImageBatch(this.taskId, ids);
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
            int percent = (finishCount += ids.size()) * 100 / totalCount;
            String tip = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5206\u6279\u5904\u7406\u4e2d\uff0c\u6bcf\u6279%1$s\u5f20\uff0c\u5df2\u5b8c\u6210 %2$s/%3$s\u5f20", (String)"ImageErrorInfoRetryProcess_0", (String)"bos-image-formplugin", (Object[])new Object[0]), this.batchCount, finishCount, totalCount);
            ImageErrorInfoRetryProcess.setProgress(this.taskId, percent);
            ImageErrorInfoRetryProcess.setProgressTip(this.taskId, tip);
        }
        if (finishCount >= totalCount) {
            ImageErrorInfoRetryProcess.setCompleted(this.taskId, true);
        } else {
            ImageErrorInfoRetryProcess.setInterruption(this.taskId, true);
        }
        Map<String, Boolean> retryResult = ImageErrorInfoRetryProcess.getRetryResultFromCache(this.taskId);
        if (retryResult != null && (errorInfoArray = BusinessDataServiceHelper.load((String)"bas_imageerrorinfo", (String)"imageid,retrycount,retryresult", (QFilter[])new QFilter[]{filter = new QFilter("imageid", "in", imageIds = this.errorInfos.stream().map(ImageErrorInfo::getImageId).collect(Collectors.toList()))})) != null && errorInfoArray.length > 0) {
            for (DynamicObject errorInfo : errorInfoArray) {
                int retryCount = errorInfo.getInt("retrycount");
                String imageId = errorInfo.getString("imageid");
                boolean result = retryResult.get(imageId) != null && retryResult.get(imageId) != false;
                errorInfo.set("retrycount", (Object)(++retryCount));
                errorInfo.set("retryresult", (Object)(result ? "1" : "0"));
            }
            SaveServiceHelper.update((DynamicObject[])errorInfoArray);
        }
    }

    private void deleteImageBatch(String taskId, List<ImageErrorInfo> imageErrorInfoList) {
        for (ImageErrorInfo info : imageErrorInfoList) {
            String imageNumber = info.getImageNumber();
            if ("1".equals(info.getRetryresult())) {
                ImageErrorInfoRetryProcess.recordErrorInfoInCache(taskId, imageNumber, ResManager.loadKDString((String)"\u8be5\u9519\u8bef\u8bb0\u5f55\u5df2\u7ecf\u91cd\u8bd5\u6210\u529f\uff0c\u4e0d\u518d\u91cd\u8bd5\u3002", (String)"ImageErrorInfoRetryProcess_2", (String)"bos-image-formplugin", (Object[])new Object[0]));
                ImageErrorInfoRetryProcess.addExecuteCount(taskId);
                continue;
            }
            if (this.existImageNumberList.contains(imageNumber)) {
                ImageErrorInfoRetryProcess.recordErrorInfoInCache(taskId, imageNumber, ResManager.loadKDString((String)"\u8be5\u5f71\u50cf\u7f16\u7801\u5b58\u5728\u4e8e\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868\uff0c\u53ef\u80fd\u662f\u5f71\u50cf\u7f16\u7801\u590d\u7528\u4e86\uff0c\u4e0d\u6267\u884c\u5220\u9664\u91cd\u8bd5\u3002", (String)"ImageErrorInfoRetryProcess_3", (String)"bos-image-formplugin", (Object[])new Object[0]));
                ImageErrorInfoRetryProcess.addExecuteCount(taskId);
                continue;
            }
            String userName = info.getCreator();
            NoticeImageSysDestroyInfo destroyInfo = new NoticeImageSysDestroyInfo();
            destroyInfo.setImageNo(imageNumber);
            destroyInfo.setMessage(ResManager.loadKDString((String)"\u624b\u52a8\u91cd\u8bd5\u5220\u9664\u5f71\u50cf\u7f16\u7801", (String)"ImageErrorInfoRetryProcess_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            destroyInfo.setOpreatePerson(userName);
            destroyInfo.setUseraccount(RequestContext.get().getUserId());
            destroyInfo.setUsername(RequestContext.get().getUserName());
            try {
                String result = NoticeImageSysFactory.getInstance().destroyImage(destroyInfo);
                if (!"1".equals(result)) {
                    ImageErrorInfoRetryProcess.recordErrorInfoInCache(taskId, info.getImageNumber(), result);
                    ImageErrorInfoRetryProcess.recordRetryResult(taskId, info.getImageId(), false);
                } else {
                    ImageErrorInfoRetryProcess.recordRetryResult(taskId, info.getImageId(), true);
                }
            }
            catch (Exception e) {
                log.error("\u5f71\u50cf\u7f16\u7801\u5220\u9664\u8865\u507f\u5931\u8d25,\u5f71\u50cf\u7f16\u7801:" + info.getImageNumber() + ", \u7528\u6237\u540d:" + info.getCreator() + ", \u5806\u6808:" + e.getMessage());
                ImageErrorInfoRetryProcess.recordErrorInfoInCache(taskId, info.getImageNumber(), e.getMessage());
                ImageErrorInfoRetryProcess.recordRetryResult(taskId, info.getImageId(), false);
            }
            ImageErrorInfoRetryProcess.addExecuteCount(taskId);
        }
    }

    private List<ImageErrorInfo> getCurrIds(int seq) {
        ArrayList<ImageErrorInfo> ids = new ArrayList<ImageErrorInfo>();
        int begin = seq * this.batchCount;
        int end = begin + this.batchCount;
        for (int i = begin; i < end && i < this.errorInfos.size(); ++i) {
            ids.add(this.errorInfos.get(i));
        }
        return ids;
    }

    public static void addExecuteCount(String taskId) {
        String executeCountKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_executeCount";
        String str = BosImageDistributeSessionCache.get(executeCountKey);
        if (StringUtils.isEmpty((CharSequence)str)) {
            int count = 0;
            BosImageDistributeSessionCache.put(executeCountKey, String.valueOf(++count));
        } else {
            int count = Integer.parseInt(str);
            BosImageDistributeSessionCache.put(executeCountKey, String.valueOf(++count));
        }
    }

    public static int getExecuteCount(String taskId) {
        String executeCountKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_executeCount";
        String str = BosImageDistributeSessionCache.get(executeCountKey);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public static void recordErrorInfoInCache(String taskId, String imageNo, String msg) {
        String errorImageNoKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_errorImageNo";
        String str = BosImageDistributeSessionCache.get(errorImageNoKey);
        String string = msg = StringUtils.isNotEmpty((CharSequence)msg) && msg.length() >= 50 ? msg.substring(0, 48) : msg;
        if (StringUtils.isEmpty((CharSequence)str)) {
            LinkedList<String> list = new LinkedList<String>();
            list.add(imageNo + ": " + msg + "\n");
            BosImageDistributeSessionCache.put(errorImageNoKey, JSONObject.toJSONString(list));
        } else {
            List list = JSONObject.parseArray((String)str, String.class);
            list.add(imageNo + ": " + msg + "\n");
            BosImageDistributeSessionCache.put(errorImageNoKey, JSONObject.toJSONString((Object)list));
        }
    }

    public static Map<String, Boolean> getRetryResultFromCache(String taskId) {
        String cachedKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_retryResult";
        String cachedContent = BosImageDistributeSessionCache.get(cachedKey);
        Map map = (Map)JSONObject.parseObject((String)cachedContent, Map.class);
        return map;
    }

    private static void recordRetryResult(String taskId, String imageId, boolean result) {
        if (StringUtils.isEmpty((CharSequence)imageId)) {
            return;
        }
        String cachedKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_retryResult";
        Map<String, Boolean> map = ImageErrorInfoRetryProcess.getRetryResultFromCache(taskId);
        if (map == null) {
            map = new HashMap<String, Boolean>(16);
        }
        map.put(imageId, result);
        String cacheContent = JSONObject.toJSONString(map);
        BosImageDistributeSessionCache.put(cachedKey, cacheContent);
    }

    public static List<String> getErrorImageNo(String taskId) {
        String errorImageNoKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_errorImageNo";
        String str = BosImageDistributeSessionCache.get(errorImageNoKey);
        return JSONObject.parseArray((String)str, String.class);
    }

    public static void setProgress(String taskId, int progress) {
        String progressKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_progress";
        BosImageDistributeSessionCache.put(progressKey, String.valueOf(progress));
    }

    public static void setProgressTip(String taskId, String tip) {
        String tipKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_tip";
        BosImageDistributeSessionCache.put(tipKey, tip);
    }

    public static void setCompleted(String taskId, boolean complete) {
        String completeKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_complete";
        BosImageDistributeSessionCache.put(completeKey, String.valueOf(complete));
    }

    public static int getBatchSeq(String taskId) {
        String seqKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_batchseq";
        String seq = BosImageDistributeSessionCache.get(seqKey);
        return StringUtils.isBlank((CharSequence)seq) ? 0 : Integer.parseInt(seq);
    }

    public static void setInterruption(String taskId, boolean interruption) {
        String interruptionKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_interruption";
        BosImageDistributeSessionCache.put(interruptionKey, String.valueOf(interruption));
    }

    public static void setFinished(String taskId, boolean finish) {
        String finishKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_finish";
        BosImageDistributeSessionCache.put(finishKey, String.valueOf(finish));
    }

    private static String buildCacheType(String taskId) {
        return "RetryProcess_" + taskId;
    }

    public static boolean isCompleted(String taskId) {
        String completeKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_complete";
        String complete = BosImageDistributeSessionCache.get(completeKey);
        return !StringUtils.isBlank((CharSequence)complete) && Boolean.parseBoolean(complete);
    }

    public static boolean isFinished(String taskId) {
        String finishKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_finish";
        String finish = BosImageDistributeSessionCache.get(finishKey);
        return !StringUtils.isBlank((CharSequence)finish) && Boolean.parseBoolean(finish);
    }

    public static boolean isInteruption(String taskId) {
        String interruptionKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_interruption";
        String interruption = BosImageDistributeSessionCache.get(interruptionKey);
        return !StringUtils.isBlank((CharSequence)interruption) && Boolean.parseBoolean(interruption);
    }

    public static int getProgress(String taskId) {
        String progressKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_progress";
        String progress = BosImageDistributeSessionCache.get(progressKey);
        return StringUtils.isBlank((CharSequence)progress) ? 0 : Integer.parseInt(progress);
    }

    public static String getProgressTip(String taskId) {
        String tipKey = ImageErrorInfoRetryProcess.buildCacheType(taskId) + "_tip";
        return BosImageDistributeSessionCache.get(tipKey);
    }

    public static void clearCache(String taskId) {
        String keyPrefix = ImageErrorInfoRetryProcess.buildCacheType(taskId);
        BosImageDistributeSessionCache.remove(keyPrefix + "_executeCount");
        BosImageDistributeSessionCache.remove(keyPrefix + "_errorImageNo");
        BosImageDistributeSessionCache.remove(keyPrefix + "_retryResult");
        BosImageDistributeSessionCache.remove(keyPrefix + "_progress");
        BosImageDistributeSessionCache.remove(keyPrefix + "_tip");
        BosImageDistributeSessionCache.remove(keyPrefix + "_complete");
        BosImageDistributeSessionCache.remove(keyPrefix + "_batchseq");
        BosImageDistributeSessionCache.remove(keyPrefix + "_interruption");
        BosImageDistributeSessionCache.remove(keyPrefix + "_finish");
    }
}

