/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.common;

import java.io.StringReader;
import java.util.Iterator;
import kd.bos.imageplatform.common.XmlUtil;
import kd.bos.imageplatform.pojo.BaseImageInfo;
import kd.bos.imageplatform.pojo.BaseImageList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class Dom4jUtil {
    private static Log log = LogFactory.getLog(Dom4jUtil.class);

    public static BaseImageInfo getImageInfo(String xml) {
        BaseImageInfo imageInfo = null;
        InputSource in = new InputSource(new StringReader(xml));
        in.setEncoding("UTF-8");
        try {
            SAXReader reader = SAXReaderUtil.getSAXReader();
            Document document = reader.read(in);
            Element root = document.getRootElement();
            imageInfo = (BaseImageInfo)XmlUtil.fromXmlToBean(root, BaseImageInfo.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return imageInfo;
    }

    public static BaseImageList getImageList(String xml, Class Class2) {
        BaseImageList list = new BaseImageList();
        try {
            Document doc = SAXReaderUtil.parseText((String)xml);
            Element rootElt = doc.getRootElement();
            String returnCode = rootElt.elementTextTrim("desc");
            Iterator it = rootElt.elementIterator("Image");
            while (it.hasNext()) {
                Element elementGroupService = (Element)it.next();
                BaseImageInfo baseBean = (BaseImageInfo)XmlUtil.fromXmlToBean(elementGroupService, Class2);
                list.addImageList(baseBean);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return list;
    }
}

