/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.common;

import java.lang.reflect.Field;
import java.util.Date;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Element;

public class XmlUtil {
    private static final Log log = LogFactory.getLog(XmlUtil.class);

    public static Object fromXmlToBean(Element rootElt, Class pojo) {
        Field[] fields = pojo.getDeclaredFields();
        Object obj = null;
        try {
            obj = pojo.newInstance();
        }
        catch (Exception e) {
            log.error("\u5b9e\u4f8b\u5316\u5bf9\u8c61\u51fa\u9519", (Throwable)e);
            return obj;
        }
        for (Field field : fields) {
            ReflectionUtils.makeAccessible((Field)field);
            String name = field.getName();
            try {
                rootElt.attributeValue(name);
            }
            catch (Exception ex) {
                continue;
            }
            if (rootElt.attributeValue(name) == null || "".equals(rootElt.attributeValue(name))) continue;
            try {
                if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
                    field.set(obj, Long.parseLong(rootElt.attributeValue(name)));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(obj, rootElt.attributeValue(name));
                    continue;
                }
                if (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE)) {
                    field.set(obj, Double.parseDouble(rootElt.attributeValue(name)));
                    continue;
                }
                if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
                    field.set(obj, Integer.parseInt(rootElt.attributeValue(name)));
                    continue;
                }
                if (!field.getType().equals(Date.class)) continue;
                field.set(obj, Date.parse(rootElt.attributeValue(name)));
            }
            catch (IllegalAccessException e) {
                log.error("\u5b57\u6bb5\u7c7b\u578b\u8f6c\u5316\u51fa\u9519", (Throwable)e);
            }
        }
        return obj;
    }
}

