/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.imageplatform.common.ImageSysEnum;
import kd.bos.imageplatform.helper.NoticeImageSysHelper;
import kd.bos.imageplatform.helper.NoticeImageSysHelper_DKWS;
import kd.bos.imageplatform.helper.NoticeImageSysHelper_EAS;
import kd.bos.imageplatform.helper.NoticeImageSysHelper_FPY;
import kd.bos.imageplatform.helper.NoticeImageSysHelper_GXHC;
import kd.bos.imageplatform.helper.NoticeImageSysHelper_IMC;
import kd.bos.imageplatform.helper.NoticeImageSysHelper_NGXHC;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class NoticeImageSysFactory {
    private static final Log logger = LogFactory.getLog(NoticeImageSysFactory.class);
    private static ConcurrentHashMap<String, NoticeImageSysHelper> instanceMap = NoticeImageSysFactory.initMap();
    private static final String HISENSE = "HISENSE";

    private static ConcurrentHashMap<String, NoticeImageSysHelper> initMap() {
        DynamicObject[] imageConfigArray = BusinessDataServiceHelper.load((String)"bas_imageconfig", (String)"number,imageplugin", null);
        ConcurrentHashMap<String, NoticeImageSysHelper> map = new ConcurrentHashMap<String, NoticeImageSysHelper>(10);
        map.put(ImageSysEnum.EAS.getValue(), new NoticeImageSysHelper_EAS());
        if (imageConfigArray != null && imageConfigArray.length > 0) {
            for (DynamicObject imageConfig : imageConfigArray) {
                String number = imageConfig.getString("number");
                String className = imageConfig.getString("imageplugin");
                if (StringUtils.isEmpty((CharSequence)className)) continue;
                try {
                    Class<?> classes = Class.forName(className);
                    Object instance = classes.newInstance();
                    if (!(instance instanceof NoticeImageSysHelper)) {
                        logger.error("\u7f16\u7801\u4e3a" + number + "\u7684\u5b9e\u73b0\u7c7b\u4e0d\u662fNoticeImageSysHelper\u7684\u5b9e\u73b0\u7c7b");
                        continue;
                    }
                    map.put(number, (NoticeImageSysHelper)instance);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.error("\u7f16\u7801\u4e3a" + number + "\u7684\u5904\u7406\u7c7b" + className + "\u5b9e\u4f8b\u5316\u5931\u8d25\uff1a" + e.getCause());
                }
            }
        }
        return map;
    }

    public static void registerHelperInstance(String number, String className) {
        try {
            Class<?> classes = Class.forName(className);
            Object instance = classes.newInstance();
            if (!(instance instanceof NoticeImageSysHelper)) {
                logger.error("\u7f16\u7801\u4e3a" + number + "\u7684\u5b9e\u73b0\u7c7b\u4e0d\u662fNoticeImageSysHelper\u7684\u5b9e\u73b0\u7c7b");
            } else {
                instanceMap.put(number, (NoticeImageSysHelper)instance);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("\u7f16\u7801\u4e3a" + number + "\u7684\u5904\u7406\u7c7b" + className + "\u5b9e\u4f8b\u5316\u5931\u8d25\uff1a" + e.getCause());
        }
    }

    public static void removeHelperInstance(String number) {
        instanceMap.remove(number);
        logger.info("\u79fb\u9664\u7f16\u7801\u4e3a" + number + "\u7684NoticeImageSysHelper\u7684\u5b9e\u4f8b");
    }

    public static NoticeImageSysHelper getInstance() {
        ImageSysInfo imageSysInfo = null;
        try {
            imageSysInfo = SSCImageUtils.getEnableImageSysInfo();
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"NoticeImageSysFactory_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        return NoticeImageSysFactory.getInstance(imageSysInfo);
    }

    public static NoticeImageSysHelper getImplInstance(ImageSysInfo imageSysInfo) {
        return NoticeImageSysFactory.getInstance(imageSysInfo);
    }

    private static NoticeImageSysHelper getInstance(ImageSysInfo imageSysInfo) {
        String number = imageSysInfo.getNumber();
        String externalerpNumber = imageSysInfo.getExternalerpNumber();
        NoticeImageSysHelper helperInstance = null;
        helperInstance = ImageSysEnum.EAS.getValue().equals(externalerpNumber) ? instanceMap.get(ImageSysEnum.EAS.getValue()) : instanceMap.get(number);
        if (helperInstance == null) {
            logger.info("\u4eceinstanceMap\u4e2d\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f8b\uff0c\u4f7f\u7528\u65e7\u65b9\u6cd5\u5bfb\u627e");
            helperInstance = NoticeImageSysFactory.getInstance(number, externalerpNumber);
        }
        if (helperInstance == null) {
            logger.error("\u65e0\u8be5\u5f71\u50cf\u7cfb\u7edf:" + number);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u8be5\u5f71\u50cf\u7cfb\u7edf\u7684\u5904\u7406\u7c7b\uff1a%1$s", (String)"NoticeImageSysFactory_2", (String)"bos-image-formplugin", (Object[])new Object[0]), number));
        }
        return helperInstance;
    }

    private static NoticeImageSysHelper getInstance(String number, String externalerpNumber) {
        NoticeImageSysHelper helperInstance = null;
        if (ImageSysEnum.EAS.getValue().equals(externalerpNumber)) {
            helperInstance = new NoticeImageSysHelper_EAS();
        } else if (ImageSysEnum.DKWS.getValue().equals(number)) {
            helperInstance = new NoticeImageSysHelper_DKWS();
        } else if (ImageSysEnum.GXHC.getValue().equals(number)) {
            helperInstance = new NoticeImageSysHelper_GXHC();
        } else if (ImageSysEnum.FPY.getValue().equals(number)) {
            helperInstance = new NoticeImageSysHelper_FPY();
        } else if (ImageSysEnum.FPY_IMC.getValue().equals(number)) {
            helperInstance = new NoticeImageSysHelper_IMC();
        } else if (ImageSysEnum.NGXHC.getValue().equals(number)) {
            helperInstance = new NoticeImageSysHelper_NGXHC();
        } else if (HISENSE.equals(number)) {
            try {
                helperInstance = (NoticeImageSysHelper)Class.forName("com.hisense.bos.integration.siitplugin.CreateSiitBillApiService").newInstance();
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5b9e\u4f8b\u62a5\u9519\uff1a" + e.getMessage(), (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5b9e\u4f8b\u62a5\u9519\uff1a%1$s", (String)"NoticeImageSysFactory_1", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        } else {
            logger.error("\u65e0\u8be5\u5f71\u50cf\u7cfb\u7edf:" + number);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u8be5\u5f71\u50cf\u7cfb\u7edf\u7684\u5904\u7406\u7c7b\uff1a%1$s", (String)"NoticeImageSysFactory_2", (String)"bos-image-formplugin", (Object[])new Object[0]), number));
        }
        return helperInstance;
    }
}

