/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.xml.rpc.ServiceException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.imageplatform.helper.NoticeImageSysHelper;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSys2getScanHomeInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysCancelRescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysStartWorkFlow;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.util.HttpClientUtils;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class NoticeImageSysHelper_DKWS_LINUX
extends NoticeImageSysHelper {
    public final String symbol = "DKWS_LINUX";
    private static final Log logger = LogFactory.getLog(NoticeImageSysHelper_DKWS_LINUX.class);
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 30000;
    private static final String SUCCESS_CODE = "1";
    private static final String GET_VIEW_URL = "/api/ThirdPartyInvoking/GetViewUrl";
    private static final String REJECT_IMAGE_URL = "/api/ThirdPartyInvoking/RejectImage";
    private static final String DESTROY_IMAGE_URL = "/api/ThirdPartyInvoking/DestroyBillImage";
    private static final String BATCH_VIEW_IMAGE_PC = "/api/ThirdPartyInvoking/CreateImagePaths";
    private static final String VIEW_IMAGE_MOBILE = "/api/ThirdPartyInvoking/GetMobileViewUrl";
    private static final String GET_SCAN_HOME = "/api/ThirdPartyInvoking/SingleSignON";

    @Override
    public String getScanHomeUrl(NoticeImageSys2getScanHomeInfo scanHomeInfo) throws Exception, ServiceException {
        JSONObject param = new JSONObject();
        param.put("ThirdSystemName", (Object)this.getThirdSystemName());
        param.put("ScanLocation", (Object)scanHomeInfo.getScanLocation());
        param.put("Account", (Object)scanHomeInfo.getPersonId());
        param.put("UserID", (Object)scanHomeInfo.getPersonId());
        param.put("UserName", (Object)RequestContext.get().getUserName());
        String scanUrl = NoticeImageSysHelper_DKWS_LINUX.sendHttpRequestByPost(GET_SCAN_HOME, param.toJSONString());
        logger.info("\u83b7\u53d6\u5230\u7684\u626b\u63cf\u5458\u9996\u9875\u4e3a\uff1a" + scanUrl);
        return scanUrl;
    }

    @Override
    public String rescan(NoticeImageSys2RescanInfo rescanInfo) throws Exception {
        JSONObject param = new JSONObject();
        param.put("ThirdSystemName", (Object)this.getThirdSystemName());
        param.put("BillNo", (Object)rescanInfo.getBarCode());
        param.put("OperationUser", (Object)String.valueOf(rescanInfo.getRescanPerson()));
        param.put("ReScanReason", (Object)rescanInfo.getRescanMessage());
        NoticeImageSysHelper_DKWS_LINUX.sendHttpRequestByPost(REJECT_IMAGE_URL, param.toJSONString());
        return SUCCESS_CODE;
    }

    @Override
    public String cancelRescan(NoticeImageSysCancelRescanInfo cancelRescanInfo) throws Exception {
        String name = SSCImageUtils.getEnableImageSysInfo().getName();
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u5f71\u50cf\u53d6\u6d88\u9000\u626b\u3002", (String)"NoticeImageSysHelper_DKWS_LINUX_2", (String)"bos-image-formplugin", (Object[])new Object[0]), name));
    }

    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws Exception {
        String publicImageUrl;
        String[] barCodes = viewPhotoInfo.getBarCode().split(",");
        boolean isApp = viewPhotoInfo.getisApp();
        boolean isBatch = barCodes.length > 1;
        JSONObject param = new JSONObject();
        param.put("ThirdSystemName", (Object)this.getThirdSystemName());
        String requestUrl = null;
        if (isApp) {
            param.put("BillNos", (Object)barCodes);
            requestUrl = VIEW_IMAGE_MOBILE;
        } else if (isBatch) {
            param.put("BillNos", (Object)barCodes);
            requestUrl = BATCH_VIEW_IMAGE_PC;
        } else {
            param.put("BillNo", (Object)barCodes[0]);
            requestUrl = GET_VIEW_URL;
        }
        logger.info("\u9053\u53ef\u7ef4\u65af\u67e5\u770b\u5f71\u50cf\uff1a\u662f\u5426\u4e3a\u79fb\u52a8\u7aef\uff1a" + isApp + "\uff0c\u662f\u5426\u4e3a\u6279\u91cf\uff1a" + isBatch);
        String viewImageUrl = NoticeImageSysHelper_DKWS_LINUX.sendHttpRequestByPost(requestUrl, param.toJSONString());
        logger.info("\u83b7\u53d6\u5230\u7684\u67e5\u770b\u5f71\u50cf\u5730\u5740\u4e3a\uff1a" + viewImageUrl);
        if (isApp && StringUtils.isNotEmpty((String)(publicImageUrl = (String)SSCImageUtils.getImageSysParams("publicimageurl")))) {
            logger.info("\u5f53\u524d\u79fb\u52a8\u7aef\u516c\u7f51\u67e5\u770b\u5f71\u50cf\u53c2\u6570\u503c\u4e3a\uff1a" + publicImageUrl);
            int index = viewImageUrl.indexOf("phoneViews.html");
            if (index != -1) {
                viewImageUrl = publicImageUrl + "/" + viewImageUrl.substring(index);
            }
            logger.info("\u66ff\u6362\u516c\u7f51\u5f71\u50cf\u5730\u5740\u540e\uff1a" + viewImageUrl);
        }
        return viewImageUrl;
    }

    @Override
    public String viewPhotoOnPhone() throws Exception {
        return null;
    }

    @Override
    public String viewPhotos() throws Exception {
        return null;
    }

    @Override
    public String viewPhotosOnPhone() throws Exception {
        return null;
    }

    @Override
    public String imageUpload() throws Exception {
        return null;
    }

    @Override
    public String synVoucherInfo() throws Exception {
        return null;
    }

    @Override
    public String deleteImage() throws Exception {
        return null;
    }

    @Override
    public String destroyImage(NoticeImageSysDestroyInfo destroyInfo) throws Exception {
        JSONObject param = new JSONObject();
        param.put("ThirdSystemName", (Object)this.getThirdSystemName());
        param.put("BillNo", (Object)destroyInfo.getImageNo());
        param.put("OperationUser", (Object)String.valueOf(destroyInfo.getOpreatePerson()));
        param.put("DestroyReason", (Object)destroyInfo.getMessage());
        logger.info("\u8c03\u7528\u9053\u53ef\u7ef4\u65af\u5e9f\u5f03\u5f71\u50cf\u63a5\u53e3");
        String result = NoticeImageSysHelper_DKWS_LINUX.sendHttpRequestByPost(DESTROY_IMAGE_URL, param.toJSONString());
        return SUCCESS_CODE;
    }

    @Override
    public String submit2ImageSys() throws Exception {
        return null;
    }

    @Override
    public String startWorkFlow(NoticeImageSysStartWorkFlow startWorkFlow) throws Exception {
        return SUCCESS_CODE;
    }

    private static String sendHttpRequestByPost(String url, String params) {
        JSONObject resultJson = null;
        CloseableHttpResponse resp = null;
        ImageSysInfo enableImageSysInfo = SSCImageUtils.getEnableImageSysInfo();
        url = enableImageSysInfo.getImageUrl() + url;
        try {
            CloseableHttpClient httpClient = HttpClientUtils.createHttpClient(5000, 30000);
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setEntity((HttpEntity)new StringEntity("InputJson=" + params, "utf-8"));
            logger.info("\u8bf7\u6c42\u9053\u53ef\u7ef4\u65af\u5730\u5740\uff1a" + url + "\u53c2\u6570\uff1a" + params);
            resp = httpClient.execute((HttpUriRequest)httpPost);
            String respContent = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)"utf-8");
            logger.info("\u54cd\u5e94\u4fe1\u606f\uff1a" + respContent);
            if (StringUtils.isBlank((String)respContent)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u5f71\u50cf\u7cfb\u7edf\u672a\u83b7\u53d6\u5230\u54cd\u5e94\u4fe1\u606f", (String)"NoticeImageSysHelper_DKWS_LINUX_4", (String)"bos-image-formplugin", (Object[])new Object[0]));
            }
            resultJson = JSONObject.parseObject((String)respContent);
            if (SUCCESS_CODE.equals(resultJson.getString("errorCode"))) {
                String string = resultJson.getString("errorText");
                return string;
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u9053\u53ef\u7ef4\u65af\u63a5\u53e3\u5f02\u5e38\uff1a%s\u3002", (String)"NoticeImageSysHelper_DKWS_LINUX_0", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8fde\u63a5\u62a5\u9519" + e.getMessage(), (Throwable)e);
                }
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u9053\u53ef\u7ef4\u65af\u63a5\u53e3\u5931\u8d25\uff1a%s\u3002", (String)"NoticeImageSysHelper_DKWS_LINUX_1", (String)"bos-image-formplugin", (Object[])new Object[0]), resultJson));
    }

    private String getThirdSystemName() {
        return ResManager.loadKDString((String)"\u661f\u701a", (String)"NoticeImageSysHelper_DKWS_LINUX_3", (String)"bos-image-formplugin", (Object[])new Object[0]);
    }
}

