/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.imageplatform.axis.EASLoginProxyServiceStub;
import kd.bos.imageplatform.helper.NoticeImageSysHelper;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSys2getScanHomeInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysCancelRescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysStartWorkFlow;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.service.EASConfig;
import kd.bos.imageplatform.service.EasWebServiceClient;
import kd.bos.imageplatform.service.ImageServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.sysint.servicehelper.SysIntegrationServiceHelper;
import kd.bos.util.JSONUtils;

public class NoticeImageSysHelper_EAS
extends NoticeImageSysHelper {
    private static final Log log = LogFactory.getLog(NoticeImageSysHelper_EAS.class);
    public static final String symbol = "EAS";
    private static final String LOGIN_EAS_RESULT = "loginEAS -result : ";
    private static final String HTTP = "http://";
    private static final String HTTP_LOGIN_WEBSERVICE_BOS_KINGDEE_COM = "http://login.webservice.bos.kingdee.com";
    private static final String SESSION_ID = "SessionId";
    private static final String EA_SUSER_ID = "EASuserID";
    private static final String POST_EAS_RESULT = "postEAS -result : ";
    private static final String IMAGENUMBER = "imagenumber";

    private String EAS_ERROR() {
        return ResManager.loadKDString((String)"\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25\uff01", (String)"NoticeImageSysHelper_EAS_0", (String)"bos-image-formplugin", (Object[])new Object[0]);
    }

    @Override
    public String getScanHomeUrl(NoticeImageSys2getScanHomeInfo scanHomeInfo) throws Exception {
        return null;
    }

    @Override
    public String rescan(NoticeImageSys2RescanInfo rescanInfo) throws Exception {
        log.info("\u901a\u77e5--imageRescan--\u5f00\u59cb");
        EASConfig eas = EASConfig.getConfig();
        EasWebServiceClient call = EasWebServiceClient.getInstance();
        EASLoginProxyServiceStub.WSContext svcCtx = call.callMethodForEASLogin();
        if (svcCtx == null) {
            throw new KDBizException(this.EAS_ERROR());
        }
        log.info(LOGIN_EAS_RESULT + eas.getIP() + ":" + eas.getPort());
        try {
            Map map = this.NextToEAS();
            Object[] params = new Object[]{null, rescanInfo.getBarCode(), rescanInfo.getBillId(), map.get(EA_SUSER_ID)};
            String methodName = "imageRescan";
            String sessionId = svcCtx.getSessionId();
            String namespaceURI = HTTP + eas.getIP() + ":" + eas.getPort() + "/ormrpc/services/WSSSCTaskCenterBaseSeviceFacade?wsdl";
            String result = (String)call.callMethodForEasService(params, namespaceURI, methodName, sessionId);
            log.info(POST_EAS_RESULT + result);
            return "1";
        }
        catch (RemoteException e) {
            String errorMsg = e.getMessage();
            log.error("postEAS\u9000\u626b\u540c\u6b65\u5931\u8d25:" + errorMsg, (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"postEAS\u9000\u626b\u540c\u6b65\u5931\u8d25\uff1a%1$s", (String)"NoticeImageSysHelper_EAS_1", (String)"bos-image-formplugin", (Object[])new Object[0]), errorMsg));
        }
    }

    @Override
    public String cancelRescan(NoticeImageSysCancelRescanInfo cancelRescanInfo) throws Exception {
        log.info("\u901a\u77e5--imageRescan--\u5f00\u59cb");
        EASConfig eas = EASConfig.getConfig();
        EasWebServiceClient call = EasWebServiceClient.getInstance();
        EASLoginProxyServiceStub.WSContext svcCtx = call.callMethodForEASLogin();
        if (svcCtx == null) {
            throw new KDBizException(this.EAS_ERROR());
        }
        log.info(LOGIN_EAS_RESULT + eas.getIP() + ":" + eas.getPort());
        try {
            Map map = this.NextToEAS();
            ImageServiceImpl imageService = new ImageServiceImpl();
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setImageNo(cancelRescanInfo.getBarCode());
            ImageInfo imageInfoInside = imageService.getImageInfoInside(imageInfo);
            Object[] params = new Object[]{null, cancelRescanInfo.getBarCode(), imageInfoInside.getBillId(), map.get(EA_SUSER_ID)};
            String methodName = "imageCancelRescan";
            String sessionId = svcCtx.getSessionId();
            String namespaceURI = HTTP + eas.getIP() + ":" + eas.getPort() + "/ormrpc/services/WSSSCTaskCenterBaseSeviceFacade?wsdl";
            String result = (String)call.callMethodForEasService(params, namespaceURI, methodName, sessionId);
            log.info(POST_EAS_RESULT + result);
            return "1";
        }
        catch (RemoteException e) {
            log.error("postEAS\u9000\u626b\u540c\u6b65\u5931\u8d25:" + e);
            throw new KDBizException(e.getMessage());
        }
    }

    private Map NextToEAS() {
        String EASuserName;
        String EASuserID;
        HashMap<String, String> map = new HashMap<String, String>();
        String userID = String.valueOf(RequestContext.get().getUserId());
        Map internalData = SysIntegrationServiceHelper.getExternalData((Long)1L, (String)"bos_person", (String)userID, null, null);
        if (internalData != null) {
            EASuserID = (String)internalData.get("id");
            EASuserName = (String)internalData.get("name");
        } else {
            EASuserID = "qXxoe6X7T9iQePymnEYevYDvfe0=";
            EASuserName = "";
        }
        map.put(EA_SUSER_ID, EASuserID);
        map.put("EASuserName", EASuserName);
        return map;
    }

    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws Exception {
        EASConfig eas = EASConfig.getConfig();
        EasWebServiceClient call = EasWebServiceClient.getInstance();
        EASLoginProxyServiceStub.WSContext svcCtx = call.callMethodForEASLogin();
        if (svcCtx == null) {
            throw new KDBizException(this.EAS_ERROR());
        }
        try {
            log.info(LOGIN_EAS_RESULT + eas.getIP() + ":" + eas.getPort());
            HashMap<String, String> map = new HashMap<String, String>();
            Map easMap = this.NextToEAS();
            map.put("SynEasImageMap", "viewImage");
            map.put(IMAGENUMBER, viewPhotoInfo.getBarCode());
            map.put("easuserid", (String)easMap.get(EA_SUSER_ID));
            String massage = JSONUtils.toString(map);
            log.info("\u67e5\u770b\u5f71\u50cf\uff1a" + massage);
            Object[] params = new Object[]{massage};
            String sessionId = svcCtx.getSessionId();
            String methodName = "imageReady";
            String namespaceURI = HTTP + eas.getIP() + ":" + eas.getPort() + "/ormrpc/services/WSSSCImageBaseServiceFacade?wsdl";
            String imageUrl = (String)call.callMethodForEasService(params, namespaceURI, methodName, sessionId);
            log.info(POST_EAS_RESULT + imageUrl);
            return imageUrl;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528EAS\u67e5\u770b\u5f71\u50cf\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String viewPhotoOnPhone() throws Exception {
        return null;
    }

    @Override
    public String viewPhotos() throws Exception {
        return null;
    }

    @Override
    public String viewPhotosOnPhone() throws Exception {
        return null;
    }

    @Override
    public String imageUpload() throws Exception {
        return null;
    }

    @Override
    public String synVoucherInfo() throws Exception {
        return null;
    }

    @Override
    public String deleteImage() throws Exception {
        return null;
    }

    @Override
    public String destroyImage(NoticeImageSysDestroyInfo destroyInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map easMap = this.NextToEAS();
        map.put("SynEasImageMap", "deleteImage");
        map.put(IMAGENUMBER, destroyInfo.getImageNo());
        map.put("easuserid", (String)easMap.get(EA_SUSER_ID));
        String jsonMassage = null;
        try {
            jsonMassage = JSONUtils.toString(map);
        }
        catch (IOException e) {
            log.error("map\u8f6cjson\u51fa\u9519\uff01");
        }
        this.SynEasImageMap(jsonMassage, destroyInfo.getImageNo());
        return "1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SynEasImageMap(String massage, String imagenumber) {
        HashMap<String, String> imageMap = new HashMap<String, String>();
        imageMap.put("massage", massage);
        imageMap.put(IMAGENUMBER, imagenumber);
        log.error("\u5165\u961fMQ");
        log.error("\u521b\u5efaMQ\u6210\u529f");
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.imageplatform.service.image");){
            pub.publish(imageMap);
            log.info(imagenumber + "\u521b\u5efaMQ\u6210\u529f\uff0c\u5185\u5bb9\u662f\uff1a" + massage);
        }
    }

    @Override
    public String submit2ImageSys() throws Exception {
        return null;
    }

    @Override
    public String startWorkFlow(NoticeImageSysStartWorkFlow startWorkFlow) throws Exception {
        return "1";
    }
}

