/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.imageplatform.common.ImageOperaionEnum;
import kd.bos.imageplatform.helper.NoticeImageSysHelper;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSys2getScanHomeInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysCancelRescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysStartWorkFlow;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.ksql.util.StringUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class NoticeImageSysHelper_FPY
extends NoticeImageSysHelper {
    private static final String HOME_URL = "/imgsys/bill/outside/getHomeUrl?access_token=";
    private static final String IMAGE_URL = "/imgsys/bill/outside/getScanUrl?access_token=";
    private static final String APP_IMAGE_URL = "/imgsys/bill/h5/getH5ViewPageUrl?access_token=";
    private static final String REJECT_URL = "/imgsys/bill/outside/reject?access_token=";
    private static final String REPEAL_URL = "/imgsys/bill/outside/reject/cancel?access_token=";
    private static final String DELETE_URL = "/imgsys/bill/outside/delete?access_token=";
    private static final String REVIEW_URL = "/imgsys/bill/outside/review?access_token=";
    private static final String PUSH_URL = "/imgsys/bill/signPost/erpBillPush?access_token=";
    private static final String ENABLE_ARCHIVE_URL = "/imgsys/bill/signPost/erpBillEnablePost?access_token=";
    private static final Log log = LogFactory.getLog(NoticeImageSysHelper_FPY.class);
    private static final String ERRORDESCNO_SUCCESS = "0000";
    private static final String ERRORDESCNO_TOKEN_INVAILD = "1300";
    private static final int DEFAULT_MAX_RETYR = 3;
    private static final int DEFAULT_BASE_DELAY = 1000;
    public final String symbol = "FPY";

    @Override
    public String getScanHomeUrl(NoticeImageSys2getScanHomeInfo scanHomeInfo) throws Exception {
        JSONObject params = new JSONObject();
        String requestUrl = this.buildRequestUrl(HOME_URL, (Map<String, Object>)params);
        params.put("language", (Object)Lang.get().name());
        String requestParam = params.toJSONString();
        params.remove((Object)"fpy_access_token");
        log.info("\u83b7\u53d6\u91c7\u96c6\u9996\u9875\uff0c\u53c2\u6570\uff1a" + params);
        String responseData = SSCImageUtils.sendFpyPostHttpsRequest("image-fpy-getHome", requestUrl, requestParam);
        log.info("\u83b7\u53d6\u91c7\u96c6\u9996\u9875\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a" + responseData);
        JSONObject jsonObject = JSONObject.parseObject((String)responseData);
        String errcode = jsonObject.getString("errcode");
        if (ERRORDESCNO_SUCCESS.equals(errcode)) {
            JSONObject data = jsonObject.getJSONObject("data");
            return data.getString("url");
        }
        throw new Exception(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u91c7\u96c6\u9996\u9875\u5931\u8d25\uff0c\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_2", (String)"bos-image-formplugin", (Object[])new Object[0]), jsonObject.toJSONString()));
    }

    @Override
    public String rescan(NoticeImageSys2RescanInfo rescanInfo) throws Exception {
        JSONObject params = new JSONObject();
        String requestUrl = this.buildRequestUrl(REJECT_URL, (Map<String, Object>)params);
        params.put("scanBillNo", (Object)rescanInfo.getBarCode());
        params.put("rejectReason", (Object)rescanInfo.getRescanMessage());
        String requestParam = params.toJSONString();
        params.remove((Object)"fpy_access_token");
        log.info("\u5f71\u50cf\u9000\u626b\uff0c\u53c2\u6570\uff1a" + params);
        String responseData = SSCImageUtils.sendFpyPostHttpsRequest("image_fpy_reject", requestUrl, requestParam);
        log.info("\u5f71\u50cf\u9000\u626b\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a" + responseData);
        JSONObject jsonObject = JSONObject.parseObject((String)responseData);
        String errcode = jsonObject.getString("errcode");
        if (ERRORDESCNO_SUCCESS.equals(errcode)) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_3", (String)"bos-image-formplugin", (Object[])new Object[0]), jsonObject.toJSONString()));
    }

    @Override
    public String cancelRescan(NoticeImageSysCancelRescanInfo cancelRescanInfo) throws Exception {
        JSONObject params = new JSONObject();
        String requestUrl = this.buildRequestUrl(REPEAL_URL, (Map<String, Object>)params);
        params.put("scanBillNo", (Object)cancelRescanInfo.getBarCode());
        params.put("cancelRejectReason", (Object)cancelRescanInfo.getCancelMessage());
        String requestParam = params.toJSONString();
        params.remove((Object)"fpy_access_token");
        log.info("\u53d6\u6d88\u9000\u626b\uff0c\u53c2\u6570\uff1a" + params);
        String responseData = SSCImageUtils.sendFpyPostHttpsRequest("image-fpy-rejectcancel", requestUrl, requestParam);
        log.info("\u53d6\u6d88\u9000\u626b\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a" + requestUrl);
        JSONObject jsonObject = JSONObject.parseObject((String)responseData);
        String errcode = jsonObject.getString("errcode");
        if (ERRORDESCNO_SUCCESS.equals(errcode)) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_3", (String)"bos-image-formplugin", (Object[])new Object[0]), jsonObject.toJSONString()));
    }

    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws Exception {
        boolean isApp = viewPhotoInfo.getisApp();
        String url = isApp ? APP_IMAGE_URL : IMAGE_URL;
        JSONObject params = new JSONObject();
        String requestUrl = this.buildRequestUrl(url, (Map<String, Object>)params);
        params.put("scanBillNo", (Object)viewPhotoInfo.getBarCode());
        params.put("isRemark", (Object)Boolean.FALSE);
        params.put("isRescan", (Object)Boolean.FALSE);
        params.put("isEdit", (Object)Boolean.FALSE);
        if (isApp) {
            params.put("isApp", (Object)Boolean.TRUE);
            params.put("language", (Object)Lang.get().name());
        }
        String requestParam = params.toJSONString();
        params.remove((Object)"fpy_access_token");
        log.info("\u67e5\u770b\u5f71\u50cf\uff0c\u53c2\u6570\uff1a" + params);
        String responseData = SSCImageUtils.sendFpyPostHttpsRequest("image-fpy-scanurl", requestUrl, requestParam);
        log.info("\u67e5\u770b\u5f71\u50cf\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a" + responseData);
        JSONObject jsonObject = JSONObject.parseObject((String)responseData);
        String errcode = jsonObject.getString("errcode");
        if (ERRORDESCNO_SUCCESS.equals(errcode)) {
            JSONObject data = jsonObject.getJSONObject("data");
            String scanHome = data.getString("url");
            if (isApp) {
                String publicimageurl = (String)SSCImageUtils.getImageSysParams("publicimageurl");
                if (StringUtils.isNotEmpty((String)publicimageurl)) {
                    scanHome = scanHome.replace(url.replace("/api", ""), publicimageurl);
                }
                log.info("\u79fb\u52a8\u7aef\u67e5\u770b\u5f71\u50cfurl:" + scanHome);
            }
            return scanHome;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_3", (String)"bos-image-formplugin", (Object[])new Object[0]), jsonObject.toString()));
    }

    @Override
    public String viewPhotoOnPhone() throws Exception {
        return null;
    }

    @Override
    public String viewPhotos() throws Exception {
        return null;
    }

    @Override
    public String viewPhotosOnPhone() throws Exception {
        return null;
    }

    @Override
    public String imageUpload() throws Exception {
        return null;
    }

    @Override
    public String synVoucherInfo() throws Exception {
        return null;
    }

    @Override
    public String deleteImage() throws Exception {
        return null;
    }

    @Override
    public String destroyImage(NoticeImageSysDestroyInfo destroyInfo) throws Exception {
        JSONObject params = new JSONObject();
        String requestUrl = this.buildRequestUrl(DELETE_URL, (Map<String, Object>)params);
        params.put("scanBillNo", (Object)destroyInfo.getImageNo());
        params.put("deleteReason", (Object)destroyInfo.getMessage());
        String requestParam = params.toJSONString();
        params.remove((Object)"fpy_access_token");
        log.info("\u5220\u9664\u5f71\u50cf\uff0c\u53c2\u6570\uff1a" + params);
        String responseData = SSCImageUtils.sendFpyPostHttpsRequest("image-fpy-deleteimage", requestUrl, requestParam);
        log.info("\u5220\u9664\u5f71\u50cf\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a" + responseData);
        JSONObject jsonObject = JSONObject.parseObject((String)responseData);
        String errcode = jsonObject.getString("errcode");
        if (ERRORDESCNO_SUCCESS.equals(errcode)) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u672a\u77e5\u9519\u8bef\uff1a%1$s", (String)"NoticeImageSysHelper_FPY_3", (String)"bos-image-formplugin", (Object[])new Object[0]), jsonObject.toJSONString()));
    }

    @Override
    public String submit2ImageSys() throws Exception {
        return null;
    }

    @Override
    public String startWorkFlow(NoticeImageSysStartWorkFlow startWorkFlow) {
        return "1";
    }

    @Override
    public void pushImageInfo(ImageInfo imageInfo) {
        boolean pushResult = false;
        String errorMsg = null;
        try {
            JSONObject requestParams = this.buildPushImageInfoRequestParams(imageInfo);
            String requestUrl = this.buildRequestUrl(PUSH_URL, (Map<String, Object>)requestParams);
            errorMsg = this.pushImageInfoToFPY(requestUrl, requestParams);
            if ("1".equals(errorMsg)) {
                pushResult = true;
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u4e91\u5355\u636e\u4fe1\u606f\u63a8\u9001\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            errorMsg = e.getMessage();
        }
        if (!pushResult) {
            imageInfo.setBillData(errorMsg);
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.PUSH);
        }
    }

    @Override
    public void pushImageInfoBatch(Map<String, ImageInfo> billImageInfoMap) {
        HashMap<ImageInfo, Boolean> resultMap = new HashMap<ImageInfo, Boolean>(16);
        for (ImageInfo imageInfo : billImageInfoMap.values()) {
            boolean pushResult = false;
            try {
                JSONObject jsonObject = this.createPushImageInfoRequestParams(imageInfo);
                String requestUrl = this.buildRequestUrl(PUSH_URL, (Map<String, Object>)jsonObject);
                String responseData = this.pushImageInfoToFPY(requestUrl, jsonObject);
                if ("1".equals(responseData)) {
                    pushResult = true;
                }
            }
            catch (Exception e) {
                log.info(imageInfo.getImageNo() + "\u5728\u6279\u91cf\u63a8\u9001\u5355\u636e\u4fe1\u606f\u7ed9\u53d1\u7968\u4e91\u8fc7\u7a0b\u4e2d\u5f02\u5e38\uff1a" + e.getMessage());
                imageInfo.setBillData(e.getMessage());
            }
            resultMap.put(imageInfo, pushResult);
        }
        try (TXHandle h = TX.requiresNew((String)"pushImageInfoToFpyBatch");){
            SSCImageUtils.recordErrorInfoBatch(resultMap, ImageOperaionEnum.PUSH);
        }
    }

    private String pushImageInfoToFPY(String requestUrl, JSONObject requestParams) {
        try {
            String requestParam = requestParams.toJSONString();
            requestParams.remove((Object)"fpy_access_token");
            requestParams.remove((Object)"fapplyUserPhone");
            log.info("pushImageInfo\uff0crequestParam \uff1a" + requestParams);
            String responseData = SSCImageUtils.sendFpyPostHttpsRequest("image-fpy-erpbillpush", requestUrl, requestParam);
            log.info("pushImageInfo\u54cd\u5e94\u7ed3\u679c\uff1a" + responseData);
            JSONObject responseJsonObject = JSONObject.parseObject((String)responseData);
            String errcode = responseJsonObject.getString("errcode");
            if (ERRORDESCNO_SUCCESS.equals(errcode)) {
                return "1";
            }
            return responseJsonObject.toJSONString();
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u4e91\u5355\u636e\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return "-2";
        }
    }

    private JSONObject buildPushImageInfoRequestParams(ImageInfo imageInfo) {
        JSONObject param = new JSONObject();
        param.put("fscanBillNo", (Object)imageInfo.getImageNo());
        param.put("fbillId", (Object)imageInfo.getBillId());
        param.put("fapplyOrganizationCode", (Object)imageInfo.getOrgId());
        param.put("fbillTypeCode", (Object)imageInfo.getBilltype());
        param.put("fapplyErpUserName", (Object)imageInfo.getCreator());
        param.put("fapplyOrganizationName", (Object)imageInfo.getOrgName());
        param.put("fapplyUserName", (Object)imageInfo.getCreatorName());
        param.put("fapplyUserPhone", (Object)imageInfo.getCreatorPhone());
        param.put("fbillTypeDes", (Object)imageInfo.getBilltypeName());
        param.put("ferpDataId", (Object)RequestContext.get().getAccountId());
        param.put("fsource", (Object)4);
        int uploadFlag = imageInfo.getUploadFlag();
        param.put("fuploadFlag", (Object)(uploadFlag == -1 ? 0 : uploadFlag));
        int electricAutoCommit = imageInfo.getElectricAutoCommit();
        if (electricAutoCommit != -1) {
            param.put("fadditionalElectricDocs", (Object)electricAutoCommit);
        }
        if (StringUtils.isEmpty((String)imageInfo.getOrgName())) {
            String orgName = "";
            DynamicObject orgDynObj = BusinessDataServiceHelper.loadSingle((Object)imageInfo.getOrgId(), (String)"bos_org", (String)"number");
            if (orgDynObj != null) {
                orgName = StringUtils.isEmpty((String)orgDynObj.getString("name")) ? "" : orgDynObj.getString("name");
            }
            param.put("fapplyOrganizationName", (Object)orgName);
        }
        if (StringUtils.isEmpty((String)imageInfo.getCreatorName())) {
            String userName = "";
            String userPhone = "";
            DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)imageInfo.getCreator(), (String)"bos_user", (String)"username,name,phone");
            if (userObj != null) {
                userName = userObj.getString("name");
                userPhone = userObj.getString("phone");
            }
            param.put("fapplyUserName", (Object)userName);
            param.put("fapplyUserPhone", (Object)userPhone);
        }
        if (StringUtils.isEmpty((String)imageInfo.getBilltypeName())) {
            String billTypeName = "";
            QFilter filter = new QFilter("number", "=", (Object)imageInfo.getBilltype());
            DynamicObject billTypeObj = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{filter});
            if (billTypeObj != null) {
                billTypeName = StringUtils.isEmpty((String)billTypeObj.getString("name")) ? "" : billTypeObj.getString("name");
            }
            param.put("fbillTypeDes", (Object)billTypeName);
        }
        return param;
    }

    @Override
    public ImageInfo auditImage(ImageInfo imageInfo) {
        try {
            JSONObject params = new JSONObject();
            String requestUrl = this.buildRequestUrl(REVIEW_URL, (Map<String, Object>)params);
            params.put("scanBillNo", (Object)imageInfo.getImageNo());
            String requestParam = params.toJSONString();
            params.remove((Object)"fpy_access_token");
            log.info("auditImage\uff0c\u53c2\u6570\uff1a" + params);
            String responseData = SSCImageUtils.sendFpyPostHttpsRequest("image-fpy-review", requestUrl, requestParam);
            log.info("auditImage\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a" + responseData);
            JSONObject jsonObject = JSONObject.parseObject((String)responseData);
            String errcode = jsonObject.getString("errcode");
            if (!ERRORDESCNO_SUCCESS.equals(errcode)) {
                throw new KDBizException(jsonObject.toJSONString());
            }
            log.info("\u5f71\u50cf\u5ba1\u6838\u901a\u8fc7" + imageInfo.getImageNo());
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u5ba1\u6838\u62a5\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
        return imageInfo;
    }

    @Override
    public ImageInfo enableArchive(ImageInfo imageInfo) {
        try {
            JSONObject params = new JSONObject();
            String requestUrl = this.buildRequestUrl(ENABLE_ARCHIVE_URL, (Map<String, Object>)params);
            String respResult = this.pushImageEnableArchive(imageInfo, requestUrl, params);
            if (StringUtil.equals((String)"1", (String)respResult)) {
                return imageInfo;
            }
            String tryAaginPushResult = this.tryAaginPushEnabeleArchive(imageInfo, requestUrl, params);
            if (StringUtil.equals((String)"1", (String)tryAaginPushResult)) {
                return imageInfo;
            }
            log.error("\u5f71\u50cf\u662f\u5426\u53ef\u4ee5\u5f52\u6863\u63a8\u9001\u5931\u8d25\uff1a" + tryAaginPushResult);
            imageInfo.setBillData(tryAaginPushResult);
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.ARCHIVE);
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u662f\u5426\u53ef\u4ee5\u5f52\u6863\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            imageInfo.setBillData(e.getMessage());
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.ARCHIVE);
        }
        return null;
    }

    private String tryAaginPushEnabeleArchive(ImageInfo imageInfo, String requestUrl, JSONObject params) throws InterruptedException {
        AtomicInteger retryCounter = new AtomicInteger(0);
        String respResult = "-2";
        while (retryCounter.intValue() < 3) {
            int i = retryCounter.incrementAndGet();
            Thread.sleep(1000 * i);
            log.info("\u53d1\u7968\u4e91\u5355\u636e\u662f\u5426\u53ef\u4ee5\u5f52\u6863\u63a8\u9001\u5931\u8d25\uff0c\u5f00\u59cb\u7b2c" + i + "\u6b21\u91cd\u8bd5");
            respResult = this.pushImageEnableArchive(imageInfo, requestUrl, params);
            if (!StringUtil.equals((String)"1", (String)respResult)) continue;
            return "1";
        }
        return respResult;
    }

    private String pushImageEnableArchive(ImageInfo imageInfo, String requestUrl, JSONObject params) {
        try {
            params.put("fscanBillNo", (Object)imageInfo.getImageNo());
            log.info("imageEnableArchive\uff0crequestUrl \uff1a" + requestUrl + "\uff0c\u53c2\u6570\uff1a" + params);
            String responseData = SSCImageUtils.sendFpyPostHttpsRequest("image-fpy-imagepost", requestUrl, params.toJSONString());
            log.info("imageEnableArchive\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a" + responseData);
            JSONObject jsonObject = JSONObject.parseObject((String)responseData);
            String errcode = jsonObject.getString("errcode");
            if (ERRORDESCNO_SUCCESS.equals(errcode)) {
                return "1";
            }
            return jsonObject.toJSONString();
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u4e91\u5355\u636e\u662f\u5426\u53ef\u4ee5\u5f52\u6863\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return "-2";
        }
    }

    private String buildRequestUrl(String route, Map<String, Object> map) throws Exception {
        ImageSysInfo imageSysInfo = SSCImageUtils.getEnableImageSysInfo();
        if (imageSysInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\uff01", (String)"SSCImageUtils_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        String url = imageSysInfo.getImageUrl();
        String token = SSCImageUtils.getFpyAccessToken(imageSysInfo);
        String requestUrl = url + route + token;
        map.put("imageUrl", url);
        map.put("fpy_access_token", token);
        return requestUrl;
    }

    private String getPushRequestUrl(String token, ImageSysInfo imageSysInfo) {
        String url = imageSysInfo.getImageUrl();
        log.info("\u6279\u91cf\u63a8\u9001\u5f71\u50cf\u8bf7\u6c42requestUrl:" + url + PUSH_URL);
        return url + PUSH_URL + token;
    }

    private JSONObject createPushImageInfoRequestParams(ImageInfo imageInfo) {
        JSONObject param = new JSONObject();
        param.put("fscanBillNo", (Object)imageInfo.getImageNo());
        param.put("fbillId", (Object)imageInfo.getBillId());
        param.put("fapplyUserName", (Object)imageInfo.getCreatorName());
        param.put("fapplyUserPhone", (Object)imageInfo.getCreatorPhone());
        param.put("fapplyErpUserName", (Object)imageInfo.getCreator());
        param.put("fapplyOrganizationCode", (Object)imageInfo.getOrgId());
        param.put("fapplyOrganizationName", (Object)imageInfo.getOrgName());
        param.put("fbillTypeCode", (Object)imageInfo.getBilltype());
        param.put("fbillTypeDes", (Object)imageInfo.getBilltypeName());
        param.put("fuploadFlag", (Object)0);
        param.put("ferpDataId", (Object)RequestContext.get().getAccountId());
        param.put("fsource", (Object)4);
        return param;
    }
}

