/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import com.siit.image.wscommon.tools.ResultMsg;
import java.io.IOException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.imageplatform.helper.NoticeImageSysHelper;
import kd.bos.imageplatform.helper.SiitParamsHelper;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSys2getScanHomeInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysCancelRescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysStartWorkFlow;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.pojo.ParamsSiit;
import kd.bos.imageplatform.service.ImageConfig;
import kd.bos.imageplatform.util.HttpClientUtils;
import kd.bos.imageplatform.util.XmlParseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class NoticeImageSysHelper_GXHC
extends NoticeImageSysHelper {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    public final String symbol = "GXHC";
    private static final int CONNECTIONTIMEOUT = 5000;
    private static final int READTIMEOUT = 30000;
    private static final Log log = LogFactory.getLog(NoticeImageSysHelper_GXHC.class);
    private static final SiitParamsHelper siitParamsHelper = new SiitParamsHelper();

    @Override
    public String startWorkFlow(NoticeImageSysStartWorkFlow startWorkFlow) throws Exception {
        try {
            String rootOrgId = String.valueOf(OrgUnitServiceHelper.getRootOrgId());
            startWorkFlow.setOrgId(rootOrgId);
            String userId = startWorkFlow.getUserId();
            DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
            Object phone = userObject.get("phone");
            if (StringUtils.isNotEmpty((String)String.valueOf(phone))) {
                startWorkFlow.setUserId(String.valueOf(phone));
            }
            ParamsSiit paramsSiit = siitParamsHelper.buildStartWorkFlowParams(startWorkFlow);
            String xml = paramsSiit.toXml();
            log.info("\u63a8\u5f85\u529e-\u56fd\u4fe1\u83b7\u5f97\u5f71\u50cf\u8c03\u9605\u5730\u5740,\u8f93\u5165\u53c2\u6570\u503c\u4e3a:" + xml);
            String result = this.invoke(xml);
            log.info("\u63a8\u5f85\u529e-\u56fd\u4fe1\u83b7\u5f97\u5f71\u50cf\u8c03\u9605\u5730\u5740,\u7ed3\u679c\u53c2\u6570\u503c\u4e3a:" + result);
            ResultMsg resultMsg = XmlParseUtil.getResultMsg(result);
            if ("0".equals(resultMsg.getResult())) {
                return "1";
            }
            log.error("\u56fd\u4fe1\u5408\u6210\u89e6\u53d1\u5355\u636e\u626b\u63cf\u6d41\u7a0b\u63a5\u53e3,\u63a5\u53e3\u8fd4\u56de\u4e3a1\u5931\u8d25:" + resultMsg.getErrormsg());
            return resultMsg.getErrormsg();
        }
        catch (Exception e) {
            log.error("\u56fd\u4fe1\u5408\u6210\u89e6\u53d1\u5355\u636e\u626b\u63cf\u6d41\u7a0b\u63a5\u53e3\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56fd\u4fe1\u5408\u6210\u89e6\u53d1\u5355\u636e\u626b\u63cf\u6d41\u7a0b\u63a5\u53e3\u5931\u8d25\uff1a%1$s", (String)"NoticeImageSysHelper_GXHC_0", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    @Override
    public String getScanHomeUrl(NoticeImageSys2getScanHomeInfo scanHomeInfo) throws Exception {
        return null;
    }

    @Override
    public String rescan(NoticeImageSys2RescanInfo rescanInfo) throws Exception {
        try {
            ParamsSiit paramsSiit = siitParamsHelper.buildRescanParams(rescanInfo);
            String xml = paramsSiit.toXml();
            log.info("\u56fd\u4fe1\u9000\u56de\u91cd\u626b\u5f71\u50cf,\u8f93\u5165\u53c2\u6570\u503c\u4e3a:" + xml);
            String result = this.invoke(xml);
            log.info("\u56fd\u4fe1\u9000\u56de\u91cd\u626b\u5f71\u50cf,\u7ed3\u679c\u53c2\u6570\u503c\u4e3a:" + result);
            ResultMsg resultMsg = XmlParseUtil.getResultMsg(result);
            if ("0".equals(resultMsg.getResult())) {
                return "1";
            }
            log.error("\u56fd\u4fe1\u9000\u56de\u91cd\u626b\u5f71\u50cf\u5931\u8d25,\u63a5\u53e3\u8fd4\u56de\u4e3a1\u5931\u8d25:" + resultMsg.getErrormsg());
            throw new KDBizException(resultMsg.getErrormsg());
        }
        catch (Exception e) {
            log.error("\u56fd\u4fe1\u9000\u56de\u91cd\u626b\u5f71\u50cf\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56fd\u4fe1\u9000\u56de\u91cd\u626b\u5f71\u50cf\u5931\u8d25\uff1a%1$s", (String)"NoticeImageSysHelper_GXHC_1", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    @Override
    public String cancelRescan(NoticeImageSysCancelRescanInfo cancelRescanInfo) throws Exception {
        throw new KDBizException(ResManager.loadKDString((String)"\u56fd\u4fe1\u5408\u6210\u5f71\u50cf\u7cfb\u7edf\u4e0d\u652f\u6301\u53d6\u6d88\u5f71\u50cf\u9000\u56de\u91cd\u626b\uff01", (String)"NoticeImageSysHelper_GXHC_4", (String)"bos-image-formplugin", (Object[])new Object[0]));
    }

    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws Exception {
        String url = null;
        try {
            ParamsSiit paramsSiit = siitParamsHelper.buildCreateImagePathParams(viewPhotoInfo);
            String xml = paramsSiit.toXml();
            log.info("\u56fd\u4fe1\u83b7\u5f97\u5f71\u50cf\u8c03\u9605\u5730\u5740,\u8f93\u5165\u53c2\u6570\u503c\u4e3a:" + xml);
            String result = this.invoke(xml);
            log.info("\u56fd\u4fe1\u83b7\u5f97\u5f71\u50cf\u8c03\u9605\u5730\u5740,\u7ed3\u679c\u53c2\u6570\u503c\u4e3a:" + result);
            ResultMsg resultMsg = XmlParseUtil.getResultMsg(result);
            if ("0".equals(resultMsg.getResult())) {
                url = resultMsg.getSuccess();
            } else {
                log.error("\u83b7\u5f97\u5f71\u50cf\u8c03\u9605\u5730\u5740\u5931\u8d25,\u63a5\u53e3\u8fd4\u56de\u4e3a1\u5931\u8d25:" + resultMsg.getErrormsg());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u5f97\u5f71\u50cf\u8c03\u9605 \u5730\u5740\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u5f97\u5f71\u50cf\u8c03\u9605\u5730\u5740\u5931\u8d25\uff1a%1$s", (String)"NoticeImageSysHelper_GXHC_2", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return url;
    }

    @Override
    public String viewPhotoOnPhone() throws Exception {
        return null;
    }

    @Override
    public String viewPhotos() throws Exception {
        return null;
    }

    @Override
    public String viewPhotosOnPhone() throws Exception {
        return null;
    }

    @Override
    public String imageUpload() throws Exception {
        return null;
    }

    @Override
    public String synVoucherInfo() throws Exception {
        return null;
    }

    @Override
    public String deleteImage() throws Exception {
        return "1";
    }

    @Override
    public String destroyImage(NoticeImageSysDestroyInfo destroyInfo) throws Exception {
        try {
            ParamsSiit paramsSiit = siitParamsHelper.buildRejectBillParams(destroyInfo);
            String xml = paramsSiit.toXml();
            log.info("\u56fd\u4fe1\u5220\u9664\u5f71\u50cf,\u8f93\u5165\u53c2\u6570\u503c\u4e3a:" + xml);
            String result = this.invoke(xml);
            log.info("\u56fd\u4fe1\u5220\u9664\u5f71\u50cf,\u7ed3\u679c\u53c2\u6570\u503c\u4e3a:" + result);
            ResultMsg resultMsg = XmlParseUtil.getResultMsg(result);
            if ("0".equals(resultMsg.getResult())) {
                return "1";
            }
            log.error("\u56fd\u4fe1\u5220\u9664\u5f71\u50cf\u5931\u8d25,\u63a5\u53e3\u8fd4\u56de\u4e3a1\u5931\u8d25:" + resultMsg.getErrormsg());
            return resultMsg.getErrormsg();
        }
        catch (Exception e) {
            log.error("\u56fd\u4fe1\u5220\u9664\u5f71\u50cf\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56fd\u4fe1\u5220\u9664\u5f71\u50cf\u5931\u8d25\uff1a%1$s", (String)"NoticeImageSysHelper_GXHC_3", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    @Override
    public String submit2ImageSys() throws Exception {
        return null;
    }

    private String invoke(String xml) throws Exception {
        String cDATAxml = "<![CDATA[" + xml + "]]>";
        String body = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:imag=\"http://imageCenter.web.com\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <imag:ImageInterfaceService soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n         <param xsi:type=\"soapenc:string\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">" + cDATAxml + "</param>\n      </imag:ImageInterfaceService>\n   </soapenv:Body>\n</soapenv:Envelope>";
        String url = this.buildTargetEndPoint();
        return this.sendHttpsRequestByPost(this.buildTargetEndPoint(), body);
    }

    private String buildTargetEndPoint() {
        ImageConfig conf = ImageConfig.getConfig();
        String url = conf.getUrl();
        url = url == null || "".equals(url) ? "http://" + conf.getIP() + ":" + conf.getPort() + "/SiitFrameWs/services/AutoImageCenter.ws" : url + "/SiitFrameWs/services/AutoImageCenter.ws";
        return url;
    }

    public final String sendHttpsRequestByPost(String url, String json) throws Exception {
        String responseContent = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientUtils.createHttpClient(5000, 30000);
            HttpPost httpPost = new HttpPost(url);
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_SOAP_XML);
            httpPost.addHeader("SOAPAction", "");
            httpPost.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001HTTP POST\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u8fde\u63a5\u62a5\u9519" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return responseContent;
    }
}

